set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9864346';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.984470,
      3.407139,
      NULL,
      3,
      2.913313,
      1,
      0.014773,
      NULL,
      '102',
      NULL,
      49,
      NULL,
      '3204000',
      3,
      0.501122,
      NULL,
      0,
      '3010',
      2.691327,
      0,
      NULL,
      NULL,
      ' 7-20-1992',
      NULL,
      17,
      NULL,
      0,
      3,
      ' 7-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-23-1991',
      ' 5-27-1979',
      ' 9-14-1984',
      0,
      3,
      3.677287,
      2.072954,
      0.112966,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.854070,
      4.675487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.541238,
      1,
      0,
      0,
      0.277993,
      0.494475,
      NULL,
      3.287042,
      1,
      1.078218,
      0,
      3,
      4,
      NULL,
      2.249959,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      2,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.194841,
      2,
      1.314650,
      0.750072,
      3.798332,
      0,
      3,
      NULL,
      1.002073,
      2.580477,
      0,
      2,
      1.080056,
      1,
      2,
      0,
      0.963470,
      0,
      NULL,
      3,
      4,
      NULL,
      1,
      0,
      1.463172,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      2,
      0,
      1,
      4,
      3,
      1,
      5,
      5,
      1,
      4,
      0,
      6.623151,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      1,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      2,
      4,
      5,
      3,
      1,
      0,
      NULL,
      0,
      3,
      0,
      7,
      2.004625,
      ' 9-16-2001',
      4.963789,
      ' 8-12-1994',
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.891576,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.472634,
      3.789839,
      0.278317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.716104,
      0,
      0.570064,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.663544,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1.917240,
      1,
      0,
      9.679209,
      1.642155,
      1,
      0,
      0.502196,
      0.014749,
      0,
      0,
      1,
      NULL,
      0.847635,
      NULL,
      0,
      0.271265,
      1.348786,
      1,
      8,
      NULL,
      2.153723,
      3,
      11.349088,
      NULL,
      5,
      0.187757,
      4,
      1.479028,
      3,
      2.755674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      3,
      3,
      2.375366,
      '21004',
      '12032',
      NULL,
      1.516022,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      3.763616,
      14.503814,
      67,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.990541,
      NULL,
      1.860474,
      NULL,
      NULL,
      0.905335,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.906293,
      6.196131,
      NULL,
      0,
      0.121551,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.382339,
      1,
      0.425640,
      2.025779,
      0.005029,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.013171,
      1,
      1.230739,
      3.265363,
      NULL,
      1,
      1.401018,
      0,
      1.338541,
      0,
      3,
      0,
      0,
      0,
      0.391847,
      1.779212,
      1,
      1.679407,
      1,
      0,
      0.464265,
      1,
      6,
      3.133843,
      6.430518,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.136960,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      2.093845,
      1,
      NULL,
      NULL,
      5,
      5.584934,
      2,
      2.611854,
      2,
      NULL,
      0.187509,
      NULL,
      NULL,
      NULL,
      0.111661,
      1.708740,
      1.238546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541276,
      NULL,
      NULL,
      1.637411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.651579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.771016,
      NULL,
      NULL,
      2,
      1.168566,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.403147,
      0.860151,
      0.839633,
      NULL,
      NULL,
      0.245687,
      2,
      NULL,
      NULL,
      6.385604,
      1,
      0.119588,
      2.017075,
      0.266935,
      1.818633,
      2.019027,
      2.468817,
      1,
      0.005098,
      1,
      3,
      2.074345,
      NULL,
      3,
      4.083072,
      2,
      3.168002,
      5,
      2,
      NULL,
      3,
      1,
      0.693191,
      0,
      0.911926,
      NULL,
      2.800458,
      NULL,
      NULL,
      1.752371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.220052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.810359,
      NULL,
      NULL,
      1.942590,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.659168,
      NULL,
      NULL,
      0,
      1.510924,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.914481,
      NULL,
      NULL,
      NULL,
      0.668995,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.770702,
      NULL,
      NULL,
      NULL,
      1.902363,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.444059,
      NULL,
      NULL,
      NULL,
      2.983800,
      1,
      2.026246,
      0.430839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.652325,
      NULL,
      NULL,
      0.671160,
      NULL,
      NULL,
      1.639414,
      NULL,
      NULL,
      1.532313,
      NULL,
      1.664298,
      36,
      6,
      0.724532,
      1,
      1.151883,
      0,
      0,
      0.609297,
      0.857890,
      1.118482,
      1.377982,
      0,
      0.587143,
      0.118559,
      0,
      0.446618,
      0,
      1.674992,
      NULL,
      0.868062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048637,
      0.868387,
      1.876911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098034,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308589,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      249,
      NULL,
      1,
      NULL,
      1.121627,
      NULL,
      0,
      NULL,
      1,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      10,
      2.465762,
      2,
      2.561340,
      1,
      NULL,
      0,
      0.374824,
      0,
      0,
      0.785305,
      NULL,
      1.497351,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.059467,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      2.772744,
      NULL,
      1.875360,
      0.267440,
      NULL,
      0.277393,
      3,
      NULL,
      0.286570,
      0.271297,
      NULL,
      1.148805,
      0.125817,
      NULL,
      3,
      3.821805,
      0.814524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      2,
      0,
      1.633902,
      NULL,
      NULL,
      0,
      90,
      1,
      2,
      1,
      '41243',
      '30101',
      '',
      1.523408,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


