set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '3411414',
      2.599960,
      1,
      0,
      0,
      '0034',
      1,
      1,
      NULL,
      NULL,
      ' 5- 9-1993',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 2-10-1976',
      NULL,
      NULL,
      NULL,
      68.922408,
      0,
      ' 3- 6-1999',
      '11-27-2003',
      '10-19-1988',
      0,
      1,
      2,
      0,
      1.024330,
      0.458468,
      1,
      0,
      NULL,
      29,
      5,
      16,
      1.773802,
      6,
      22.028645,
      3,
      2,
      0,
      1,
      0,
      0.454628,
      0,
      1,
      1.687239,
      NULL,
      0.612542,
      0,
      1,
      1,
      1,
      2,
      7,
      2,
      3,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.267988,
      NULL,
      NULL,
      1.904543,
      NULL,
      NULL,
      2,
      1,
      0.557963,
      0,
      0,
      1,
      1,
      0.294744,
      1,
      NULL,
      1,
      NULL,
      0.562452,
      0,
      0.105856,
      1.736848,
      NULL,
      0.935010,
      1.829672,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      2,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      1,
      0,
      4,
      0,
      5,
      2,
      0,
      1,
      0,
      1,
      0,
      3,
      NULL,
      4,
      0,
      3,
      1,
      4,
      4,
      1,
      1,
      NULL,
      0.960473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.967452,
      1,
      1.081538,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.574729,
      NULL,
      1.099208,
      1,
      3,
      1.741495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      0,
      2.706033,
      0,
      NULL,
      3,
      1.381365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.690075,
      1,
      0,
      1.597790,
      NULL,
      9,
      0.529365,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.922164,
      2.118751,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      0,
      5,
      2.662674,
      1.959254,
      1,
      0,
      2.150012,
      1.466562,
      0.188278,
      1,
      0,
      1.918249,
      NULL,
      0.057994,
      1,
      0,
      1,
      NULL,
      0.556434,
      0,
      9.681338,
      7.329834,
      0,
      0,
      2.627592,
      NULL,
      0.943288,
      7.396999,
      3,
      1.444304,
      NULL,
      8.077979,
      1,
      NULL,
      NULL,
      58,
      37,
      20.794269,
      0,
      1,
      NULL,
      NULL,
      NULL,
      '',
      1.983072,
      '02033',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      30.979136,
      52.894914,
      NULL,
      0,
      NULL,
      7,
      NULL,
      NULL,
      0.025493,
      NULL,
      NULL,
      0.366280,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140360,
      NULL,
      NULL,
      1.404548,
      NULL,
      NULL,
      2.806020,
      3.411170,
      0.122123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.233598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.525036,
      3,
      2.281834,
      0,
      3,
      1.848908,
      1,
      NULL,
      NULL,
      1.999962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.280587,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.679444,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.721831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.070109,
      NULL,
      3,
      0,
      0.055784,
      NULL,
      1.964145,
      0.289103,
      2.163157,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.169829,
      1.196036,
      1.598281,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      3.227851,
      2.158254,
      0.527928,
      3,
      NULL,
      0.772414,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      6,
      5,
      0.983243,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.689296,
      0.287302,
      0.389438,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408495,
      3.984697,
      0.828607,
      NULL,
      1.838014,
      0.551844,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282893,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.822508,
      NULL,
      NULL,
      NULL,
      2.437334,
      NULL,
      NULL,
      NULL,
      0.092145,
      NULL,
      NULL,
      NULL,
      2.053416,
      NULL,
      NULL,
      NULL,
      0.861958,
      NULL,
      NULL,
      NULL,
      1.399354,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.574151,
      NULL,
      NULL,
      NULL,
      2.011247,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.900370,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.432375,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      6,
      NULL,
      2.314390,
      17,
      NULL,
      2.006209,
      14,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.867185,
      NULL,
      0,
      NULL,
      NULL,
      0,
      9.838758,
      NULL,
      0,
      NULL,
      NULL,
      21.296917,
      2,
      NULL,
      1,
      1.726217,
      0.661067,
      1.518023,
      1.364890,
      1,
      1,
      NULL,
      NULL,
      1.575156,
      1.057694,
      0,
      0,
      0,
      NULL,
      NULL,
      1.388274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      3,
      1,
      2,
      NULL,
      6,
      3,
      2.603742,
      1.380864,
      1.473718,
      NULL,
      NULL,
      NULL,
      3.438519,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.630296,
      1,
      NULL,
      0.200196,
      1.941483,
      NULL,
      NULL,
      1,
      NULL,
      0.458715,
      0,
      NULL,
      0,
      1.943268,
      NULL,
      1,
      0,
      NULL,
      2.892497,
      NULL,
      NULL,
      3.394111,
      0.524407,
      0.029318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325675,
      2.216796,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3.800346,
      NULL,
      2.610117,
      NULL,
      1.914003,
      NULL,
      1.284718,
      NULL,
      0.519305,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.815701,
      NULL,
      NULL,
      NULL,
      6.942162,
      0,
      7,
      NULL,
      NULL,
      0,
      NULL,
      1.354321,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      12.155725,
      5,
      1,
      0,
      '03121',
      '',
      '',
      3,
      '23002',
      NULL,
      '13103',
      0.192253,
      '',
      NULL,
      '');
commit;
end;
/


