set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0110333',
      3.024339,
      0,
      NULL,
      1,
      '0022',
      3,
      1,
      NULL,
      NULL,
      ' 0-16-1988',
      NULL,
      NULL,
      NULL,
      1.706073,
      5,
      '10- 3-1995',
      6,
      NULL,
      236.491842,
      11.935569,
      0,
      ' 0- 5-1976',
      NULL,
      NULL,
      0.843364,
      0,
      2,
      2.951604,
      1.595553,
      0.351324,
      1,
      NULL,
      0,
      26.599007,
      4,
      11.800791,
      3.559037,
      18,
      24.481891,
      3,
      8,
      NULL,
      2,
      8,
      NULL,
      1,
      1,
      1.614361,
      0,
      0,
      NULL,
      1.905522,
      NULL,
      0,
      121,
      4,
      6,
      5,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      4.842591,
      0,
      1,
      1,
      0,
      0.382775,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.744845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      1,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      1.061481,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      0.664749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154156,
      1,
      1,
      1.392312,
      NULL,
      NULL,
      7.458131,
      0,
      NULL,
      1,
      1,
      4.181724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.274513,
      NULL,
      NULL,
      0,
      11.725384,
      1,
      0.188040,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      3,
      1,
      0,
      3,
      1,
      0.708371,
      4,
      1.214760,
      0,
      NULL,
      NULL,
      4.965282,
      NULL,
      1.387358,
      1.606337,
      0.161921,
      1.933183,
      1.451691,
      1.452509,
      1.786579,
      1,
      NULL,
      4.838727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.683465,
      NULL,
      24,
      69,
      38.690171,
      1,
      1,
      NULL,
      '32212',
      '',
      '',
      3,
      NULL,
      '',
      '',
      1.998482,
      '',
      NULL,
      '',
      3,
      17.732505,
      NULL,
      26.387758,
      1,
      35,
      7.921344,
      NULL,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.123716,
      NULL,
      NULL,
      0.892112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.334092,
      NULL,
      NULL,
      NULL,
      1,
      0.901201,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.698332,
      3,
      1,
      1,
      1.948884,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.066005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214934,
      NULL,
      NULL,
      1.514611,
      NULL,
      NULL,
      2.763464,
      NULL,
      NULL,
      0.210461,
      NULL,
      NULL,
      3,
      1,
      1.740180,
      0.391437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914325,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.178110,
      NULL,
      NULL,
      1.014009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.472435,
      0.918874,
      NULL,
      1.682398,
      1.646796,
      7.770871,
      4.246555,
      0,
      1.796817,
      NULL,
      NULL,
      2.551768,
      0,
      1.582677,
      3.534909,
      NULL,
      1,
      NULL,
      1.207212,
      NULL,
      2.485888,
      4,
      1.107800,
      1.610387,
      NULL,
      NULL,
      1.721566,
      NULL,
      NULL,
      0,
      1,
      1.551478,
      1,
      3,
      2.721994,
      6,
      6.160279,
      5.606293,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.119738,
      NULL,
      NULL,
      1.411757,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518410,
      0.914639,
      1.752001,
      0.547812,
      NULL,
      1.784452,
      1.662486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.165020,
      4.388219,
      0,
      4,
      1.213458,
      343,
      NULL,
      3,
      NULL,
      NULL,
      0.182756,
      NULL,
      NULL,
      3,
      1829,
      NULL,
      1,
      NULL,
      NULL,
      3.792038,
      507.674233,
      NULL,
      NULL,
      NULL,
      0.194718,
      18458,
      140.440322,
      1,
      1,
      1.702194,
      0.925576,
      1.144458,
      1.852287,
      NULL,
      1,
      1.351177,
      1,
      1.325765,
      1.152890,
      NULL,
      0,
      1.599054,
      0.090015,
      NULL,
      0.147128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      NULL,
      3,
      2,
      12,
      3.523708,
      0.257544,
      0,
      2,
      NULL,
      NULL,
      0.011854,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.258773,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.580105,
      NULL,
      NULL,
      1.387162,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.545768,
      NULL,
      1.275380,
      NULL,
      14,
      NULL,
      0,
      NULL,
      3.744589,
      NULL,
      3.310047,
      NULL,
      0,
      NULL,
      1.423432,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.796560,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.929321,
      NULL,
      3,
      3,
      3,
      0.287137,
      NULL,
      NULL,
      75,
      22,
      3,
      NULL,
      NULL,
      '00333',
      '',
      '',
      0.227815,
      '41130',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


