set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '0213430',
      3,
      1.555749,
      5,
      1,
      '4210',
      3.419943,
      0.402019,
      NULL,
      NULL,
      ' 0- 2-1975',
      54,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.568934,
      84.711236,
      87.152038,
      1,
      '11- 2-1987',
      '10-26-1975',
      ' 6-14-1992',
      2.304620,
      0,
      NULL,
      1.816461,
      1.119490,
      0.558245,
      NULL,
      1.019526,
      0,
      48,
      6,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      0.574984,
      1.222794,
      1,
      1,
      0,
      0.710843,
      1,
      1,
      1,
      NULL,
      0,
      101.740577,
      0,
      0,
      7,
      2.651215,
      1,
      0,
      0,
      0,
      3,
      0,
      1,
      1,
      0,
      5,
      1,
      1,
      1.338911,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097594,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.403635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.643168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      3,
      NULL,
      1.998826,
      1,
      0,
      1,
      0,
      1.077411,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      0,
      1,
      2,
      NULL,
      4,
      0,
      1,
      1,
      5,
      0,
      1,
      4,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0.859340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.760294,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.559565,
      0,
      3,
      2.919322,
      1,
      1.862702,
      4,
      NULL,
      4,
      6,
      2.230002,
      1.880460,
      0,
      0,
      0.897478,
      5.845558,
      1.109178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.920185,
      0,
      1,
      1.995429,
      0.777201,
      NULL,
      3,
      4,
      3.075824,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.152503,
      0.567373,
      2,
      3,
      3,
      3,
      3,
      2,
      3,
      3,
      NULL,
      NULL,
      1.790854,
      NULL,
      0,
      0.572575,
      0,
      0,
      0.313264,
      1,
      NULL,
      1.337627,
      0,
      0.680116,
      1,
      0.272805,
      1,
      0,
      1,
      4,
      0.485434,
      6.817774,
      NULL,
      5.987815,
      0.452984,
      0,
      2,
      3.371485,
      3,
      6.698344,
      1.488984,
      0,
      NULL,
      15,
      1,
      1.467920,
      NULL,
      56,
      NULL,
      30,
      0,
      0.950125,
      0.494233,
      '40203',
      '',
      '',
      0,
      '22220',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      37,
      53,
      34,
      NULL,
      39.245409,
      2.256060,
      1,
      3,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.597264,
      NULL,
      NULL,
      0.231996,
      NULL,
      NULL,
      1.091528,
      NULL,
      NULL,
      NULL,
      0.543992,
      1,
      0.666551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.022896,
      NULL,
      0.003537,
      NULL,
      NULL,
      1.663166,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293042,
      8,
      2,
      3.513315,
      1.501498,
      NULL,
      NULL,
      NULL,
      1.056780,
      NULL,
      NULL,
      1.109186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.272342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.769276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      14.210438,
      0,
      1.190424,
      NULL,
      NULL,
      5,
      1.745455,
      1,
      1.855616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.688612,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.003154,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0.464625,
      1.232224,
      NULL,
      2.007684,
      1.568770,
      NULL,
      7,
      0,
      NULL,
      NULL,
      1,
      2.305292,
      2,
      NULL,
      0.674499,
      3,
      2.444958,
      2.274004,
      3.237219,
      NULL,
      NULL,
      1,
      0.123024,
      1,
      NULL,
      1.891630,
      NULL,
      NULL,
      3.548462,
      3,
      NULL,
      2.033842,
      3.313800,
      1,
      NULL,
      4,
      NULL,
      NULL,
      4.692939,
      5.507491,
      NULL,
      NULL,
      NULL,
      0.764993,
      0.383429,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185569,
      3.204675,
      3.475202,
      1,
      2.190874,
      1,
      0,
      NULL,
      4.342016,
      NULL,
      NULL,
      NULL,
      4.189512,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.153351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.503108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.453364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.564782,
      NULL,
      NULL,
      NULL,
      3.749293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617849,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      4,
      2,
      3.343697,
      2,
      3.960499,
      2,
      6.293415,
      1.839095,
      1,
      NULL,
      NULL,
      0,
      3.653199,
      NULL,
      1,
      NULL,
      NULL,
      0,
      11.786300,
      4,
      0,
      NULL,
      1.951378,
      14.354709,
      NULL,
      1.750119,
      0.874115,
      0,
      1.351962,
      NULL,
      1,
      1,
      1.341349,
      0.161994,
      1.043026,
      0.326397,
      1.634152,
      1,
      1,
      1.104374,
      0,
      1.010604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      3.331205,
      0.869395,
      2,
      8,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      0.339722,
      3,
      0.951849,
      0,
      1,
      3,
      0.553181,
      0.282416,
      0,
      2,
      3,
      3.863489,
      3.865746,
      2.036732,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      2,
      0.172748,
      0,
      2,
      0.899063,
      2.453254,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691051,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.618397,
      1.423053,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      2.966793,
      3.496257,
      3,
      2.679514,
      0.786951,
      2.633067,
      NULL,
      2.467441,
      0,
      0,
      3,
      2.040029,
      0,
      NULL,
      1,
      16.455563,
      1.356453,
      1.829972,
      0,
      0.563186,
      1,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.309418,
      21.695750,
      5,
      NULL,
      0.895634,
      '32404',
      '',
      '',
      4.890782,
      '42333',
      '11102',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


