set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505264';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '1024022',
      0.455326,
      1.997166,
      NULL,
      3,
      '1222',
      1.720706,
      1.355002,
      NULL,
      NULL,
      ' 1-25-2000',
      14,
      NULL,
      4,
      NULL,
      1,
      '11-20-1998',
      18.193623,
      NULL,
      67,
      44.553094,
      1,
      ' 0-24-1987',
      '10- 0-1996',
      NULL,
      3.699143,
      NULL,
      1.499110,
      3,
      0.530482,
      0,
      7,
      1.685242,
      NULL,
      169,
      1,
      12.903520,
      9.884691,
      11.555385,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3.921683,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1.045715,
      NULL,
      1.329439,
      0.570344,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      4,
      0,
      0,
      0,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0,
      8.309257,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0.497038,
      1.701264,
      2,
      1,
      1,
      2,
      0,
      NULL,
      3,
      1.188936,
      0,
      0.607039,
      2.788320,
      1.349060,
      0,
      NULL,
      0,
      1,
      10.530869,
      1,
      2,
      2.756036,
      1.507510,
      NULL,
      NULL,
      3.856729,
      2,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      0,
      NULL,
      1.889360,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      NULL,
      0,
      NULL,
      5,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      2.540619,
      NULL,
      ' 3- 5-1996',
      780.888823,
      ' 6-23-2002',
      688,
      0.558012,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      0,
      0,
      1.172602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.706899,
      1.835778,
      NULL,
      3,
      NULL,
      5,
      NULL,
      2,
      1,
      0,
      3,
      5,
      NULL,
      2,
      0,
      3,
      9,
      3.409805,
      0,
      NULL,
      NULL,
      0.398377,
      3.154497,
      1.352549,
      2,
      4,
      NULL,
      5,
      ' 6- 5-2001',
      NULL,
      ' 5- 0-1997',
      2,
      NULL,
      0,
      5,
      3,
      1.150137,
      NULL,
      0.346123,
      2,
      1.668696,
      1,
      3,
      24,
      3.238599,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.574566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      3.516860,
      NULL,
      3,
      3,
      1.590048,
      0,
      NULL,
      1.208677,
      NULL,
      0.599939,
      0.186709,
      NULL,
      0,
      1.042801,
      0.932462,
      0,
      1.821354,
      2,
      0,
      10,
      5.459162,
      2.494612,
      4.176450,
      0.705629,
      NULL,
      3,
      3,
      2,
      1.251137,
      0.907552,
      2.465652,
      37.433189,
      NULL,
      1.067549,
      NULL,
      26,
      18,
      NULL,
      NULL,
      NULL,
      6,
      '44443',
      NULL,
      '41203',
      NULL,
      '23033',
      '',
      '',
      2,
      NULL,
      '2313',
      '',
      3,
      NULL,
      158,
      21,
      0,
      47,
      3,
      11,
      3,
      0.340135,
      0.918467,
      1.612782,
      NULL,
      NULL,
      NULL,
      3,
      0.215864,
      1,
      NULL,
      0,
      3.097847,
      3,
      0,
      2.758492,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.124738,
      NULL,
      NULL,
      2.049212,
      1.369398,
      NULL,
      1,
      NULL,
      1.889883,
      NULL,
      7.607154,
      9.054954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.729282,
      0.668586,
      2,
      NULL,
      3,
      1,
      2.848186,
      2.778829,
      3.132805,
      NULL,
      1.850026,
      1,
      NULL,
      1,
      3,
      0,
      1,
      3.816886,
      2,
      3,
      1.015343,
      1,
      NULL,
      0.462892,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.244498,
      2.426660,
      9,
      NULL,
      9.877022,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312311,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.439442,
      1.765011,
      NULL,
      NULL,
      5.441279,
      10,
      1.207762,
      1,
      0,
      0.913683,
      0.336004,
      NULL,
      NULL,
      5,
      7.361825,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.405211,
      NULL,
      NULL,
      1.608796,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.196399,
      NULL,
      NULL,
      2,
      1,
      0,
      0.075538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      5,
      1,
      5.925468,
      3,
      NULL,
      1,
      2.658760,
      0,
      0.787151,
      3.478740,
      3.258943,
      3.300954,
      7.728105,
      3.296985,
      0.224353,
      NULL,
      0.272859,
      0.206976,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.885498,
      6.557139,
      0.238779,
      4,
      6,
      4.895330,
      1,
      3.657770,
      NULL,
      0,
      0,
      1.039698,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.887103,
      NULL,
      NULL,
      0.815353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482684,
      NULL,
      0,
      1,
      1.007034,
      NULL,
      0.702504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.821424,
      NULL,
      NULL,
      NULL,
      0.842312,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.242481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.764976,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.404886,
      NULL,
      NULL,
      NULL,
      3.002648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035131,
      NULL,
      NULL,
      NULL,
      3.955157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.069386,
      4,
      9,
      3,
      NULL,
      122,
      NULL,
      1,
      10,
      13.746156,
      0.996554,
      NULL,
      NULL,
      2,
      2.534721,
      NULL,
      2.467025,
      60,
      8.414320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      598.815745,
      28,
      0,
      1,
      0.804632,
      1.953057,
      NULL,
      0.816312,
      1,
      1.989662,
      NULL,
      0.765540,
      1.351266,
      NULL,
      NULL,
      1,
      1.379310,
      0.807435,
      1,
      1.512980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.584742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754477,
      1.989784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3.077777,
      NULL,
      NULL,
      NULL,
      3.569342,
      NULL,
      2,
      3.760835,
      1.313505,
      2,
      NULL,
      2.387367,
      NULL,
      470,
      NULL,
      1,
      NULL,
      0.513212,
      NULL,
      1,
      NULL,
      3,
      NULL,
      29,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1.929922,
      NULL,
      NULL,
      3,
      3,
      6,
      1.695671,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.420219,
      0.027787,
      NULL,
      0.296450,
      0.584067,
      NULL,
      1.000958,
      1.411111,
      NULL,
      NULL,
      1.995011,
      NULL,
      NULL,
      NULL,
      NULL,
      2.174607,
      2,
      NULL,
      2.045068,
      3,
      NULL,
      2,
      3.745689,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.919180,
      0,
      1.916762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.089200,
      NULL,
      0.679975,
      NULL,
      1,
      3,
      1,
      1.731813,
      NULL,
      0.688457,
      92,
      80,
      2,
      1.599538,
      7.407292,
      NULL,
      NULL,
      '22324',
      3,
      '21143',
      NULL,
      '',
      3.458818,
      '3314',
      '4130',
      '');
commit;
end;
/


