set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      1,
      NULL,
      2.960029,
      1,
      1,
      3,
      '124',
      '44212011',
      46.052416,
      30.221544,
      NULL,
      3,
      1.204602,
      4,
      3,
      '4312',
      NULL,
      0,
      NULL,
      NULL,
      '10-25-2003',
      47.830073,
      20,
      NULL,
      NULL,
      3,
      ' 1-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 2-16-1986',
      '11- 0-1993',
      '10-26-1987',
      0.666047,
      3.610869,
      3,
      1,
      0,
      NULL,
      0,
      3.587175,
      NULL,
      NULL,
      NULL,
      13,
      7.607763,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0.708009,
      NULL,
      3,
      0.707343,
      1,
      NULL,
      0,
      0.780673,
      1,
      NULL,
      0,
      4,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4.032008,
      3,
      1,
      2,
      1,
      1.629495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.010365,
      NULL,
      0.665236,
      NULL,
      2,
      0,
      0.632232,
      NULL,
      1.018275,
      1,
      0,
      NULL,
      0.800965,
      1.538286,
      1.195964,
      0,
      1.398243,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.668970,
      NULL,
      0.953866,
      0.430168,
      1.775976,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      3.684621,
      1,
      0,
      NULL,
      0,
      1.217421,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      3,
      1,
      1,
      3,
      0,
      0,
      3,
      0,
      4,
      5,
      2,
      4,
      4,
      5,
      4,
      5,
      5.774325,
      2,
      ' 9- 9-1981',
      30.138154,
      ' 5-17-1986',
      21,
      0,
      NULL,
      1,
      1,
      5,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      3,
      2,
      3,
      NULL,
      4,
      NULL,
      2,
      2,
      NULL,
      3,
      NULL,
      13,
      '11-22-1993',
      2,
      0.651307,
      2,
      0,
      NULL,
      NULL,
      1.651843,
      0.230079,
      0,
      4,
      NULL,
      0.149355,
      1.919111,
      0.775532,
      NULL,
      NULL,
      0.974575,
      NULL,
      1,
      3.225988,
      2.990497,
      3.540168,
      0,
      7.306293,
      1,
      2.768307,
      3.534861,
      1.129542,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.257037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.647924,
      0,
      1,
      3,
      0.273670,
      1,
      1,
      3,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      3,
      1,
      1,
      NULL,
      3,
      3,
      0,
      1,
      3.943819,
      0.656025,
      0.230049,
      0.334732,
      NULL,
      1,
      1.484239,
      1.493369,
      0,
      0,
      NULL,
      NULL,
      0.297886,
      0,
      1.461058,
      2.843722,
      0,
      3,
      11.263148,
      3,
      0,
      NULL,
      2,
      NULL,
      3.407687,
      2,
      3,
      0,
      0.587735,
      45.664905,
      0,
      1.523841,
      NULL,
      NULL,
      9,
      NULL,
      1,
      0,
      1,
      NULL,
      '03214',
      '10440',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      30.301903,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1.080794,
      NULL,
      NULL,
      1.054192,
      NULL,
      NULL,
      2,
      1.041822,
      NULL,
      1.855893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      45,
      1.054457,
      1.029785,
      1,
      1.899548,
      NULL,
      NULL,
      3.832208,
      NULL,
      NULL,
      1,
      1.683693,
      1,
      1,
      1,
      1.101534,
      0,
      1,
      NULL,
      0.632752,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.562231,
      NULL,
      NULL,
      2,
      2.568811,
      1,
      NULL,
      NULL,
      NULL,
      0.348931,
      NULL,
      1,
      NULL,
      1.546281,
      NULL,
      0,
      NULL,
      1.502581,
      NULL,
      1.058616,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.935108,
      NULL,
      1,
      NULL,
      1.349336,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.980770,
      1,
      NULL,
      0.462426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246906,
      NULL,
      NULL,
      0.600647,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.353297,
      NULL,
      0,
      NULL,
      0.815912,
      NULL,
      0,
      0.117185,
      3.939459,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.741648,
      NULL,
      1.796045,
      0,
      1,
      NULL,
      2.029050,
      NULL,
      2.888504,
      NULL,
      25,
      NULL,
      2.891700,
      NULL,
      1.685993,
      NULL,
      1,
      NULL,
      1.890094,
      1.130743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.991167,
      NULL,
      1.367912,
      NULL,
      NULL,
      NULL,
      0,
      3.061078,
      0.788218,
      3.104447,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      15.819776,
      NULL,
      0.199925,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      2,
      1,
      1.618615,
      1,
      3.359304,
      1,
      2.633717,
      0,
      0.962609,
      NULL,
      NULL,
      1.569942,
      1,
      NULL,
      0.236257,
      0,
      NULL,
      1,
      1,
      NULL,
      3.163890,
      NULL,
      NULL,
      1,
      0.359892,
      NULL,
      NULL,
      0,
      NULL,
      0.273866,
      1.941415,
      NULL,
      1.529211,
      1,
      NULL,
      0.618236,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.084136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.598265,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2,
      1.560011,
      NULL,
      NULL,
      116,
      NULL,
      4,
      3.543103,
      7,
      '20222',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


