set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6900066';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '10',
      22,
      6.982085,
      NULL,
      3,
      NULL,
      1,
      0,
      '4210',
      2,
      NULL,
      NULL,
      NULL,
      '11-10-2001',
      16,
      7,
      NULL,
      0,
      0.019094,
      ' 3-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-14-1985',
      NULL,
      ' 3-20-1984',
      NULL,
      NULL,
      2.203120,
      0,
      1.907743,
      NULL,
      0,
      0.970371,
      0.856431,
      583.166386,
      3,
      12,
      4.255470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.624681,
      NULL,
      NULL,
      1,
      0.133622,
      1,
      1.154536,
      68,
      NULL,
      4,
      6,
      1,
      4,
      1,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      4,
      2,
      0,
      1,
      3.824676,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      2,
      NULL,
      2,
      3,
      1,
      NULL,
      0.732267,
      0.719498,
      0.016286,
      NULL,
      1.044867,
      2,
      1.274161,
      NULL,
      NULL,
      1.776813,
      3,
      NULL,
      5,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      1,
      5,
      0,
      1,
      5,
      5,
      1,
      1,
      NULL,
      2,
      3,
      3,
      0,
      1,
      4,
      2,
      ' 0- 3-1977',
      NULL,
      ' 7-10-1995',
      1091,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.104804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679206,
      1,
      1.271531,
      NULL,
      1.241190,
      0,
      1.927200,
      NULL,
      NULL,
      NULL,
      0.047492,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.376639,
      0,
      3.759969,
      0.033838,
      NULL,
      1,
      2.938731,
      NULL,
      1.010598,
      3,
      9,
      182,
      72,
      3,
      1.732267,
      2,
      2,
      1,
      1,
      0,
      2,
      2,
      3,
      NULL,
      0,
      1,
      NULL,
      3.075381,
      NULL,
      0,
      2,
      1,
      NULL,
      0.207812,
      1.018797,
      0.432376,
      0.036367,
      0,
      1,
      1.466643,
      NULL,
      1,
      1,
      2.706718,
      1.586032,
      6,
      7,
      NULL,
      NULL,
      10.110059,
      NULL,
      5,
      2,
      NULL,
      2.666874,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      62,
      4.000552,
      NULL,
      3,
      NULL,
      '33030',
      '',
      '',
      0.507307,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      11.180457,
      4,
      17,
      1,
      32.587001,
      3,
      137,
      2,
      3,
      1.278824,
      0.355078,
      NULL,
      2,
      NULL,
      3,
      1.360740,
      NULL,
      3,
      0.285981,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.314965,
      2,
      2,
      2,
      0.290227,
      0,
      1,
      0,
      2,
      2.663559,
      1.233512,
      1,
      0,
      1.400705,
      2,
      0.459241,
      1.454464,
      NULL,
      3,
      1.203103,
      NULL,
      1,
      1.921889,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.349935,
      2.628303,
      2,
      3,
      1,
      2.124767,
      2,
      1.637639,
      0,
      0.596853,
      1,
      1,
      3,
      NULL,
      1,
      1,
      1,
      3.883179,
      0.430944,
      3,
      NULL,
      1,
      0.779276,
      1.338149,
      2,
      2.623622,
      0.985004,
      1,
      0,
      1,
      2.602098,
      NULL,
      0.336138,
      3.328087,
      NULL,
      NULL,
      NULL,
      NULL,
      8.005752,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.457271,
      1,
      1.311685,
      0,
      1,
      0,
      1.638246,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088410,
      0.748077,
      1,
      NULL,
      NULL,
      4.487096,
      0.600101,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.092257,
      3.159337,
      0.549645,
      0,
      2.701876,
      0.637132,
      1.541408,
      1.069216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.936497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.416142,
      NULL,
      2.335028,
      1.282354,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.139167,
      10.707979,
      NULL,
      4,
      0.985690,
      NULL,
      NULL,
      NULL,
      0.056690,
      0,
      1.581991,
      0,
      0.670803,
      1.734071,
      2,
      0,
      4.900494,
      3.620860,
      0.655169,
      NULL,
      2.871397,
      3.658290,
      3.211929,
      2,
      3.746565,
      3,
      2,
      1,
      2,
      2,
      NULL,
      7.709247,
      NULL,
      9,
      NULL,
      1,
      2,
      3,
      2,
      4,
      1.726891,
      NULL,
      1.526962,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      140.340169,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.364146,
      NULL,
      NULL,
      3.707806,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.045195,
      NULL,
      1.841756,
      1.259057,
      NULL,
      3,
      2,
      NULL,
      NULL,
      156.326598,
      NULL,
      419.331709,
      NULL,
      2.735626,
      NULL,
      1,
      NULL,
      1.207943,
      NULL,
      0.136971,
      NULL,
      1,
      1,
      1.173583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.683622,
      NULL,
      NULL,
      NULL,
      1.530685,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.792561,
      NULL,
      NULL,
      1.125568,
      1.991724,
      0.985996,
      NULL,
      3.045503,
      0,
      3,
      NULL,
      NULL,
      3,
      0.884605,
      NULL,
      3,
      3,
      0.624821,
      NULL,
      NULL,
      0,
      0.797797,
      NULL,
      2.617144,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      1.577458,
      5.817470,
      3,
      NULL,
      3,
      0.099370,
      32.112169,
      6,
      0,
      NULL,
      104.950382,
      95,
      3,
      107.783327,
      13.866993,
      0,
      NULL,
      NULL,
      2.948337,
      167.054143,
      84,
      1,
      71,
      NULL,
      1,
      NULL,
      NULL,
      3,
      12,
      NULL,
      66.584191,
      NULL,
      1.400736,
      0.926793,
      1,
      NULL,
      1,
      NULL,
      0,
      0.113109,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.454407,
      1.215307,
      0.711372,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      2.359349,
      NULL,
      2,
      1.790696,
      1,
      2.259896,
      1.788331,
      NULL,
      0,
      NULL,
      0.918560,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785332,
      1.786769,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628928,
      0.160671,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.963416,
      NULL,
      0.066038,
      1.451335,
      NULL,
      2.771511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.550819,
      1,
      NULL,
      1,
      NULL,
      1.982321,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.520565,
      NULL,
      1.781715,
      NULL,
      0.380158,
      NULL,
      0.824562,
      NULL,
      1.528236,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.625809,
      NULL,
      NULL,
      0.534097,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      3,
      0,
      2.711452,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3.428541,
      3.311967,
      '34340',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '44222',
      NULL,
      NULL);
commit;
end;
/


