set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0012033',
      NULL,
      0,
      0,
      NULL,
      '2220',
      0.991580,
      1.854256,
      NULL,
      NULL,
      NULL,
      95.094052,
      NULL,
      NULL,
      3.777886,
      2.089561,
      ' 2- 2-2002',
      NULL,
      1.335517,
      64,
      34,
      3,
      ' 9-27-1982',
      ' 2-19-1986',
      ' 6-24-1975',
      0,
      1.074531,
      0,
      1,
      0,
      NULL,
      3,
      0.503814,
      1,
      17.824715,
      2,
      3.852654,
      NULL,
      NULL,
      8,
      1,
      19.275782,
      NULL,
      3,
      4.440636,
      0.861994,
      1,
      0,
      1.124246,
      0,
      1,
      1.854928,
      0.126849,
      NULL,
      1.067605,
      0,
      3,
      2,
      2,
      1.558447,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      2,
      3,
      2,
      2.388829,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      1,
      0,
      2.994473,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      2.913624,
      0.739282,
      NULL,
      0.525030,
      NULL,
      2.326304,
      NULL,
      1,
      0,
      NULL,
      8,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      0,
      2,
      3,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0.224059,
      NULL,
      1.467196,
      1,
      4,
      1,
      0,
      2,
      NULL,
      1,
      0,
      4,
      1,
      0,
      NULL,
      2,
      2,
      5,
      2,
      1,
      4,
      4,
      2,
      0,
      4,
      0,
      NULL,
      3,
      6.241215,
      NULL,
      ' 5- 5-1998',
      NULL,
      ' 2- 6-1986',
      5,
      3.012430,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5.905993,
      1.635105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.416799,
      5,
      1.329923,
      NULL,
      5.678601,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.349193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584693,
      NULL,
      NULL,
      0.136578,
      1,
      1,
      2.846603,
      0.155034,
      1,
      1.042454,
      NULL,
      NULL,
      NULL,
      1,
      0.606258,
      0.816303,
      3,
      NULL,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      1,
      2,
      1,
      1.260760,
      3,
      2.205124,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.761482,
      0,
      1.801842,
      1,
      0.746320,
      3,
      1,
      NULL,
      0,
      3,
      8.387705,
      7,
      2,
      2,
      NULL,
      2.919827,
      3,
      1.760842,
      0,
      44.304222,
      3,
      3.763028,
      NULL,
      41,
      35,
      57.689931,
      NULL,
      5.189906,
      NULL,
      NULL,
      '12400',
      '04202',
      1,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      27,
      206,
      32,
      0.300953,
      1,
      1.420618,
      1.240598,
      1,
      1,
      NULL,
      NULL,
      0.653857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.801962,
      0.605274,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.878544,
      0.546264,
      1,
      1.230633,
      NULL,
      NULL,
      1.600950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.089882,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.361763,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      2,
      1,
      1,
      2,
      2,
      1,
      NULL,
      2.873701,
      1.787892,
      3,
      1.456206,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.613942,
      1.129392,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179774,
      1,
      1.700726,
      0,
      NULL,
      NULL,
      1.265130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.734778,
      NULL,
      NULL,
      NULL,
      0.964947,
      1.572722,
      0,
      0.200823,
      1.560620,
      2,
      1.755586,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.282147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.918624,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.258173,
      NULL,
      NULL,
      5.883470,
      NULL,
      0,
      3.351050,
      1.385801,
      1,
      3,
      1.691282,
      1.423525,
      1.195840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378907,
      1.042147,
      0.886083,
      2.595748,
      1,
      0,
      0,
      0.700401,
      1.673754,
      2.616291,
      1.954857,
      3,
      NULL,
      5.687850,
      NULL,
      NULL,
      2.470269,
      2,
      1,
      0,
      NULL,
      1,
      2.685077,
      0,
      NULL,
      1.005444,
      1.516146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842222,
      NULL,
      NULL,
      0.574647,
      0.992309,
      2,
      2.267162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695628,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819716,
      NULL,
      NULL,
      1,
      0.604788,
      NULL,
      NULL,
      1.982261,
      1,
      NULL,
      NULL,
      3.211126,
      NULL,
      NULL,
      NULL,
      3.989473,
      NULL,
      NULL,
      NULL,
      1.139859,
      0,
      NULL,
      NULL,
      1.940317,
      0,
      NULL,
      NULL,
      0.545099,
      1,
      NULL,
      NULL,
      0,
      1.375398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792954,
      NULL,
      NULL,
      NULL,
      5.608924,
      NULL,
      NULL,
      1.474220,
      0.412284,
      3,
      2,
      1,
      17,
      5.328955,
      2,
      0,
      0.506832,
      0,
      NULL,
      NULL,
      0.008459,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      9,
      13.994234,
      0,
      NULL,
      1,
      227.188560,
      22.080840,
      NULL,
      NULL,
      NULL,
      0,
      0.111597,
      2.824079,
      1,
      1.202554,
      0.515245,
      0.070847,
      NULL,
      NULL,
      1.516912,
      NULL,
      1,
      NULL,
      NULL,
      1.252944,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.218700,
      NULL,
      61.587684,
      NULL,
      4,
      14.080482,
      34,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.521713,
      NULL,
      1.584823,
      NULL,
      3,
      NULL,
      1.619419,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.087074,
      NULL,
      0,
      NULL,
      1.079528,
      NULL,
      NULL,
      NULL,
      1.097701,
      NULL,
      1,
      NULL,
      1.421172,
      1.138154,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024941,
      NULL,
      1,
      NULL,
      1.582744,
      NULL,
      1.869384,
      NULL,
      0.602273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114953,
      2.563121,
      NULL,
      NULL,
      NULL,
      0.645608,
      NULL,
      NULL,
      NULL,
      6.015240,
      NULL,
      1.144127,
      NULL,
      NULL,
      NULL,
      0.791948,
      1,
      3,
      NULL,
      1,
      NULL,
      0.615449,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      0.979794,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1.024555,
      NULL,
      1.940461,
      NULL,
      NULL,
      NULL,
      1.263296,
      1.961211,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.684108,
      NULL,
      3.304269,
      2.980519,
      0.027658,
      1,
      NULL,
      1004.843233,
      3,
      0.673926,
      1,
      0,
      NULL,
      2.011643,
      NULL,
      1.609909,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.964572,
      2,
      3.369749,
      1.849449,
      NULL,
      9.357696,
      2.535967,
      1,
      NULL,
      3,
      2,
      0.395966,
      1.393906,
      0,
      0.065714,
      0,
      1.866934,
      0.151433,
      NULL,
      3.946602,
      0.901158,
      0.073338,
      2,
      2,
      1,
      3,
      2,
      0.599548,
      NULL,
      0.507376,
      1.160366,
      1.209631,
      2.003910,
      NULL,
      0,
      2.897917,
      1.217717,
      2.610674,
      3.899813,
      0.018275,
      3.443962,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.044927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      3.197414,
      53,
      18,
      4,
      5,
      0.986559,
      '11402',
      '13422',
      '22012',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


