set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3220041',
      0.514298,
      0.715188,
      0,
      3,
      NULL,
      NULL,
      0.406837,
      NULL,
      NULL,
      NULL,
      25.027913,
      NULL,
      0,
      3,
      NULL,
      ' 4-24-1977',
      6.964851,
      0,
      16,
      94,
      0,
      NULL,
      NULL,
      ' 6-17-1996',
      3.084348,
      1,
      3,
      0,
      1.080565,
      0,
      3,
      2.711122,
      NULL,
      NULL,
      NULL,
      11.861462,
      3,
      18,
      20,
      NULL,
      27.355016,
      0,
      NULL,
      5.692702,
      1,
      NULL,
      0,
      1.961800,
      1.015145,
      0,
      0.142721,
      NULL,
      0,
      0,
      1.006778,
      4,
      NULL,
      4,
      2,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.086846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.322869,
      1.629403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      4,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.862132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      0,
      0,
      0,
      0.844359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.919604,
      0.584710,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587368,
      1.738688,
      3.277067,
      1,
      0.658423,
      5.358371,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.553672,
      0.030604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984300,
      1,
      1,
      1,
      0,
      0,
      0.661661,
      1.123200,
      NULL,
      0.284925,
      1.602453,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      1,
      3,
      1.150592,
      1.449515,
      0.002384,
      NULL,
      1,
      1.676129,
      1,
      0,
      1.809681,
      NULL,
      0.569009,
      0.974393,
      1.099405,
      NULL,
      1,
      1.374673,
      NULL,
      0,
      NULL,
      0.752237,
      NULL,
      11,
      11.923016,
      NULL,
      5.566660,
      0.805303,
      3.474300,
      1.740065,
      NULL,
      3,
      34.418230,
      3,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993884,
      3.367397,
      NULL,
      '',
      '',
      1.590491,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      15,
      NULL,
      8.825599,
      NULL,
      2.310921,
      9.107556,
      NULL,
      3,
      0.766237,
      NULL,
      NULL,
      1.941114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.197940,
      0.967246,
      1.546824,
      0.746408,
      3.051645,
      0.610103,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.599517,
      2,
      2,
      1.280862,
      1.098065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.483422,
      NULL,
      NULL,
      0.612969,
      NULL,
      NULL,
      7.130898,
      8,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      3.051892,
      NULL,
      19.229966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909384,
      0,
      0.216398,
      2.085194,
      NULL,
      NULL,
      3.076866,
      0,
      1.470011,
      0,
      1,
      0,
      0.122225,
      1,
      0,
      1.285312,
      0,
      NULL,
      NULL,
      0.149881,
      NULL,
      NULL,
      1.751901,
      NULL,
      NULL,
      7.742072,
      1.466320,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.788312,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.475980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.172441,
      1.372784,
      3.269695,
      0,
      0,
      0,
      NULL,
      NULL,
      3.599862,
      NULL,
      NULL,
      1.536278,
      NULL,
      NULL,
      1.217701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802495,
      NULL,
      NULL,
      1.943606,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.206444,
      0.387454,
      1.835723,
      NULL,
      NULL,
      0,
      4.035212,
      1.428632,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.775769,
      3,
      1.751733,
      1.618601,
      2.515923,
      NULL,
      NULL,
      NULL,
      2.607945,
      8.012390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.090337,
      0,
      3.588214,
      3,
      NULL,
      3.164627,
      3.099821,
      0,
      1,
      3.068086,
      8.465335,
      2,
      1.703442,
      0,
      NULL,
      3.283083,
      3,
      2,
      1.206630,
      NULL,
      1.822951,
      1,
      0.315366,
      1,
      NULL,
      NULL,
      0.054815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681263,
      NULL,
      NULL,
      0.551229,
      NULL,
      NULL,
      1.330550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693130,
      NULL,
      3,
      NULL,
      1.581135,
      0,
      2.042530,
      NULL,
      4,
      5.782957,
      7.879866,
      NULL,
      3,
      3,
      3,
      NULL,
      3.790244,
      1,
      3.580335,
      NULL,
      2.017953,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      1.457298,
      0,
      NULL,
      NULL,
      2.385523,
      0,
      NULL,
      NULL,
      0.741935,
      NULL,
      14,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.759883,
      NULL,
      NULL,
      2.314627,
      1,
      1.187363,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      2,
      3.074109,
      NULL,
      3,
      1.058161,
      NULL,
      NULL,
      1,
      1.967166,
      2.152444,
      NULL,
      2.746031,
      NULL,
      0,
      NULL,
      3.385981,
      1.635845,
      0.543838,
      NULL,
      14,
      3.033234,
      1,
      NULL,
      0,
      0.398594,
      NULL,
      NULL,
      NULL,
      1.231389,
      5.312904,
      6,
      3,
      32.891583,
      6.872835,
      0,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      1.735521,
      NULL,
      NULL,
      1.395973,
      NULL,
      NULL,
      1,
      NULL,
      1.683193,
      1,
      NULL,
      1.251041,
      0,
      NULL,
      0.545696,
      NULL,
      1,
      0.706228,
      1,
      0.403573,
      0.568537,
      NULL,
      0.618698,
      0,
      1,
      1.053492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      0.943119,
      3.548545,
      0,
      0,
      2,
      3,
      3,
      0.477236,
      NULL,
      0,
      1,
      0,
      NULL,
      1.191924,
      1.888075,
      0,
      2.748459,
      0,
      1.333906,
      NULL,
      1.249217,
      1.825882,
      NULL,
      1,
      1,
      1.896634,
      1.692671,
      1.529804,
      0,
      0.657947,
      NULL,
      1,
      NULL,
      NULL,
      0.268023,
      1.542382,
      1.985137,
      0.234744,
      1,
      NULL,
      1,
      NULL,
      0.210735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.229988,
      1,
      1,
      NULL,
      2,
      NULL,
      1.292973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.402326,
      NULL,
      1,
      NULL,
      3.409615,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.449164,
      NULL,
      1.127119,
      NULL,
      1.739037,
      NULL,
      NULL,
      1.986733,
      1,
      0,
      0.538701,
      0.900440,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      119,
      32,
      1,
      4,
      0.053062,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


