set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209180';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      2.656827,
      0,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      61.438983,
      NULL,
      4,
      0.713989,
      1,
      ' 2-29-1986',
      32.863892,
      4,
      NULL,
      79,
      2,
      NULL,
      ' 5-22-1998',
      ' 7-26-2002',
      1.526103,
      0.447673,
      1,
      0.900663,
      0,
      1,
      1,
      NULL,
      1,
      2,
      3,
      12.831023,
      4,
      21,
      NULL,
      0,
      20,
      3,
      2,
      NULL,
      0.095307,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1.897266,
      0.347535,
      1,
      1,
      1,
      2,
      0,
      3.486792,
      5,
      0,
      1,
      2,
      3,
      2,
      0,
      2,
      4,
      0,
      1,
      5,
      4,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      0.763169,
      NULL,
      0,
      2.792319,
      NULL,
      0.108722,
      NULL,
      1.752658,
      NULL,
      1,
      NULL,
      1.536580,
      NULL,
      1.528284,
      1.615643,
      NULL,
      3,
      NULL,
      5,
      0,
      NULL,
      5.157329,
      NULL,
      NULL,
      NULL,
      1.264779,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      0,
      3.297644,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      3,
      3,
      4,
      NULL,
      NULL,
      0,
      5,
      5.340069,
      NULL,
      ' 2- 4-2001',
      309.962006,
      ' 7- 5-2001',
      262.268251,
      2,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.461308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.807796,
      NULL,
      3.079400,
      1.851445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      0,
      2,
      0,
      2,
      4.552369,
      4.363761,
      NULL,
      6.727494,
      0.439024,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.870708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.174133,
      1,
      0,
      0,
      0.421878,
      51.616776,
      3.380550,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.458573,
      0,
      NULL,
      2,
      NULL,
      1,
      2,
      3,
      NULL,
      0,
      NULL,
      3,
      7,
      0,
      0,
      4,
      1,
      0.658086,
      0,
      1.868925,
      1.124193,
      1.641129,
      0,
      0.859206,
      1.774120,
      0.359677,
      0,
      0,
      1.743774,
      NULL,
      1.256579,
      10.666101,
      9,
      0,
      5.946616,
      NULL,
      4,
      2.079628,
      0.771273,
      1.939718,
      NULL,
      NULL,
      1.434704,
      33,
      2,
      1,
      NULL,
      52,
      22,
      NULL,
      3,
      1.652061,
      2,
      '32322',
      '',
      NULL,
      0.021550,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      69.601440,
      94,
      59,
      0.598331,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779865,
      1.826906,
      2.490999,
      0.094988,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.835028,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      3.236310,
      NULL,
      0,
      NULL,
      NULL,
      1.820751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      5,
      NULL,
      1.978833,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.816030,
      NULL,
      0.353693,
      0.864136,
      NULL,
      NULL,
      0.353082,
      NULL,
      NULL,
      2,
      1,
      1.553770,
      1.530187,
      2,
      1.974245,
      3,
      1,
      1,
      0,
      NULL,
      3.501610,
      0,
      2,
      1.345826,
      1,
      1.679495,
      2.098812,
      0,
      0,
      2,
      1,
      1.429353,
      2.159216,
      0.407473,
      1.251374,
      NULL,
      0.042300,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      2.385809,
      0,
      4.658227,
      2.869567,
      1.655283,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088959,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.867101,
      0.605038,
      3,
      3,
      0.218764,
      5,
      3.035754,
      NULL,
      3.451125,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565478,
      NULL,
      1.145794,
      NULL,
      NULL,
      3.974230,
      2,
      2,
      2,
      3,
      0.010717,
      0.701539,
      NULL,
      NULL,
      0,
      0.925331,
      3,
      NULL,
      0,
      1,
      0.955000,
      3,
      NULL,
      1.394284,
      0,
      0.369590,
      1.623463,
      0.839460,
      1.844579,
      NULL,
      NULL,
      0.467642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009419,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.983909,
      1.197776,
      0,
      3.713434,
      NULL,
      NULL,
      NULL,
      7.439499,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.968800,
      NULL,
      NULL,
      NULL,
      1.203548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.381575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836654,
      NULL,
      NULL,
      NULL,
      1.534552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.978406,
      2,
      31,
      2,
      0,
      NULL,
      NULL,
      0.410315,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.153365,
      1,
      1.815860,
      0.524150,
      1,
      NULL,
      1.696429,
      0.469827,
      0.108350,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0.046946,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      0,
      0,
      3,
      2,
      8.117525,
      1,
      1.651167,
      NULL,
      1.594828,
      0,
      NULL,
      0,
      0.297237,
      NULL,
      1,
      NULL,
      NULL,
      0.151580,
      1.054689,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      1.999394,
      NULL,
      0.342035,
      0,
      NULL,
      0.944421,
      0.997918,
      NULL,
      1.627742,
      0,
      NULL,
      0.774420,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.065099,
      NULL,
      0.624005,
      1,
      3,
      NULL,
      2,
      NULL,
      0,
      25.620108,
      65.873183,
      1,
      1,
      2.939369,
      '32223',
      '',
      '',
      1,
      '',
      '',
      '',
      0.851992,
      '',
      '',
      '');
commit;
end;
/


