set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0211333',
      2.846842,
      0.601981,
      NULL,
      1,
      '2304',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-26-1993',
      1.795383,
      NULL,
      3,
      NULL,
      1,
      ' 5-24-1997',
      NULL,
      1.025820,
      191,
      11,
      2,
      ' 7-23-1994',
      ' 7-19-1974',
      ' 1-10-1991',
      0.551143,
      2.307273,
      NULL,
      0,
      0.506239,
      NULL,
      NULL,
      1.466685,
      1,
      2,
      2,
      19.361537,
      1,
      4,
      21,
      NULL,
      32,
      0,
      3,
      8,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.718285,
      4,
      1,
      1,
      3,
      0,
      0,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      9.584306,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      3.436410,
      2.284736,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.633394,
      0,
      0.219112,
      0.700186,
      0.854875,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.216742,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.413539,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.128759,
      4,
      0,
      0,
      3,
      2,
      5,
      1,
      0,
      0,
      NULL,
      0,
      1,
      2,
      0,
      5,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      5,
      5,
      3,
      0,
      3.784325,
      3,
      '10- 0-1979',
      47.697218,
      ' 0-18-2003',
      39,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1.546923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      16.195562,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248891,
      0.880209,
      3,
      0,
      2,
      1.661718,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      34,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      0.373743,
      6.059083,
      NULL,
      0.850270,
      0.551844,
      0.375083,
      1.880866,
      1,
      NULL,
      1.280771,
      0.282857,
      0.883456,
      0,
      0,
      NULL,
      NULL,
      1.843080,
      0,
      1,
      NULL,
      6.699473,
      1,
      6.123862,
      8.173147,
      1.589930,
      NULL,
      2,
      4,
      0,
      2,
      3.072256,
      68.259580,
      NULL,
      2,
      NULL,
      13,
      48,
      61,
      0,
      NULL,
      0.748939,
      '00441',
      '',
      NULL,
      0.531615,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      9,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455051,
      0.101527,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.815549,
      1,
      3.098619,
      NULL,
      1.460525,
      NULL,
      NULL,
      NULL,
      1,
      3.904452,
      1.112439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2.243522,
      NULL,
      NULL,
      NULL,
      1.649556,
      6,
      5.004353,
      0,
      1.325699,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.324192,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666498,
      NULL,
      NULL,
      1.429588,
      NULL,
      NULL,
      1.400028,
      NULL,
      NULL,
      NULL,
      5.722297,
      2.806699,
      1,
      1.858641,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.927559,
      1,
      2,
      3.351403,
      NULL,
      2.854254,
      NULL,
      0,
      0,
      6.618190,
      1,
      1.095181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.678996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.816330,
      NULL,
      NULL,
      1.263032,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.644523,
      5,
      NULL,
      5.078558,
      0.361258,
      5.951873,
      1.369177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.860280,
      3.184512,
      1.222675,
      1,
      0,
      6,
      1.174470,
      3.106386,
      1,
      2.818427,
      1,
      NULL,
      3.455885,
      3,
      2.978147,
      2.970512,
      0,
      3.670290,
      NULL,
      3,
      2,
      1,
      NULL,
      1.741169,
      NULL,
      NULL,
      1.991758,
      1,
      1,
      1.355484,
      0,
      NULL,
      1,
      0.563020,
      3.451812,
      NULL,
      NULL,
      1.444396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208913,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.394597,
      NULL,
      NULL,
      0.001762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.602962,
      NULL,
      NULL,
      1.923615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713826,
      0,
      NULL,
      1,
      1.512799,
      0.014709,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.857975,
      NULL,
      NULL,
      NULL,
      0.992261,
      NULL,
      NULL,
      NULL,
      1.153599,
      NULL,
      NULL,
      NULL,
      0.932152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338587,
      NULL,
      NULL,
      1.706063,
      NULL,
      NULL,
      0.193450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.093699,
      NULL,
      NULL,
      1.593529,
      NULL,
      0.159356,
      NULL,
      0.889862,
      1.721751,
      1,
      1.790809,
      0,
      0,
      NULL,
      0,
      1.950542,
      0.780596,
      0.893717,
      0,
      0.225599,
      0,
      1.744152,
      1,
      NULL,
      1.907884,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      2.559121,
      3,
      1.493140,
      3,
      13.266863,
      3,
      1,
      1.117670,
      1.488387,
      0,
      NULL,
      1.748656,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.345794,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230332,
      1,
      NULL,
      3.242800,
      0,
      NULL,
      0.439932,
      0,
      NULL,
      0.893414,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.136821,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      2.043131,
      3,
      1.213439,
      19.052901,
      74.013957,
      NULL,
      1,
      0,
      '34444',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


