set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0101654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.191214,
      1,
      NULL,
      1.633165,
      2,
      3,
      NULL,
      2,
      '140',
      NULL,
      65.564879,
      12.259543,
      '0201102',
      2,
      NULL,
      1,
      0,
      '2432',
      NULL,
      1,
      NULL,
      NULL,
      ' 4-17-1986',
      NULL,
      194.184204,
      NULL,
      0,
      1.729065,
      ' 6-16-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 8-22-1980',
      0,
      1,
      1.864015,
      1.252146,
      NULL,
      3,
      0,
      0.416675,
      NULL,
      NULL,
      NULL,
      10.925433,
      1.289229,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.952604,
      0,
      1,
      0.471019,
      0.436953,
      1,
      2,
      NULL,
      3,
      NULL,
      5,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0,
      0,
      5,
      NULL,
      NULL,
      2.848946,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.787654,
      NULL,
      NULL,
      0,
      0,
      1.543851,
      NULL,
      NULL,
      NULL,
      3.149723,
      0.502426,
      1.603194,
      NULL,
      1.846393,
      3,
      2.205120,
      3.999290,
      1.569637,
      0,
      3.943151,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.939272,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      2,
      1,
      5,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0.710164,
      NULL,
      1,
      1,
      2,
      0,
      1,
      0,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      4,
      0,
      0,
      4,
      4,
      1,
      1,
      1.337796,
      NULL,
      ' 1-13-2002',
      NULL,
      NULL,
      NULL,
      0.331526,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1.212324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.187661,
      1.404986,
      1.207743,
      1,
      0,
      NULL,
      1.173756,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.566738,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.739217,
      NULL,
      NULL,
      0.170486,
      0,
      0,
      1.660817,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.449994,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      1,
      2,
      2.845370,
      2,
      NULL,
      1.652662,
      1.705845,
      1.067499,
      NULL,
      3.372994,
      0.719668,
      0.194340,
      NULL,
      1,
      0.805446,
      0,
      0.890801,
      1,
      1.795544,
      NULL,
      1.621438,
      3,
      9,
      0.634514,
      NULL,
      10.955893,
      1.574391,
      3.497928,
      3.305738,
      6.121242,
      3.073675,
      0.546966,
      2,
      37,
      0,
      0,
      70,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '31330',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '4432',
      '3313',
      '',
      0,
      16,
      264,
      17.794250,
      1,
      15.122410,
      4.569214,
      17.984919,
      2,
      3.842871,
      3.724228,
      3.474457,
      0,
      NULL,
      NULL,
      0.947827,
      NULL,
      NULL,
      2.859129,
      3.863049,
      1.228227,
      NULL,
      NULL,
      NULL,
      1,
      1.657629,
      NULL,
      3,
      3.089544,
      NULL,
      2.326134,
      1,
      NULL,
      0,
      3.499662,
      2,
      1,
      3,
      0.354398,
      0.778159,
      1,
      0,
      2,
      0,
      0,
      11,
      1,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908642,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.837197,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      2.600706,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.690809,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      1.697637,
      NULL,
      1,
      1.597990,
      NULL,
      3,
      0.054769,
      2.229808,
      1,
      0.777471,
      0,
      10.715792,
      6.377589,
      NULL,
      1.212305,
      NULL,
      NULL,
      NULL,
      0.157314,
      NULL,
      NULL,
      NULL,
      1.683680,
      NULL,
      NULL,
      NULL,
      3.282133,
      NULL,
      NULL,
      2,
      0,
      0.489355,
      NULL,
      NULL,
      4.184142,
      7,
      0.546884,
      2.591862,
      NULL,
      1.108437,
      1.255164,
      2.827533,
      0,
      6,
      8.346606,
      2.037588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.826785,
      NULL,
      NULL,
      1.605949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.100007,
      0,
      0.560342,
      4.091598,
      4.610293,
      5,
      NULL,
      1,
      NULL,
      1.396797,
      NULL,
      NULL,
      1,
      0.357446,
      1,
      3.791287,
      0,
      3.490635,
      NULL,
      1.783727,
      0,
      5.623841,
      8.359633,
      NULL,
      0.223973,
      2.718030,
      NULL,
      2.014321,
      3.358456,
      1.065775,
      2.434118,
      0,
      2.788766,
      2,
      3,
      NULL,
      1.944041,
      NULL,
      0,
      0.518043,
      NULL,
      NULL,
      0.986703,
      NULL,
      NULL,
      1.647673,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.780356,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.784312,
      1.823686,
      1,
      3,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.423496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982986,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.870711,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.082122,
      485,
      102.059054,
      2,
      12.548070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143445,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.296852,
      NULL,
      0,
      758.566656,
      NULL,
      1,
      2.706982,
      0.108256,
      NULL,
      1.842615,
      NULL,
      NULL,
      1.355432,
      NULL,
      NULL,
      0,
      1.841360,
      1,
      1.439962,
      0.681328,
      1,
      NULL,
      2.604999,
      NULL,
      0,
      NULL,
      3.164164,
      NULL,
      NULL,
      NULL,
      1.418638,
      NULL,
      3.207489,
      NULL,
      18.258917,
      NULL,
      3,
      2,
      24.630968,
      3.474262,
      2,
      0,
      NULL,
      1.110028,
      NULL,
      0,
      NULL,
      1.596013,
      NULL,
      1.655701,
      NULL,
      0.842218,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.259125,
      NULL,
      0.865809,
      NULL,
      0,
      NULL,
      1.362033,
      NULL,
      0.182436,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.346213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470554,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336069,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.216637,
      NULL,
      3,
      NULL,
      86,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.109090,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.742522,
      1.581735,
      2,
      1,
      1,
      5.802885,
      0.115455,
      NULL,
      0.374125,
      1,
      3,
      NULL,
      3.389798,
      NULL,
      0,
      0.833902,
      NULL,
      0,
      2,
      NULL,
      0.956231,
      1.014924,
      NULL,
      1.524411,
      1.025262,
      NULL,
      0,
      0.869366,
      NULL,
      0.389348,
      2,
      NULL,
      0,
      3.721289,
      NULL,
      0.960485,
      1.420518,
      NULL,
      1.659953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.295679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848680,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      5,
      0.736903,
      NULL,
      NULL,
      14,
      1.452766,
      2,
      0,
      1.239833,
      '21342',
      '30411',
      '00131',
      1,
      '',
      '',
      '',
      NULL,
      '3100',
      '1012',
      '');
commit;
end;
/


