set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '40',
      NULL,
      47.784670,
      '1330221',
      3.431293,
      1.073406,
      6,
      3,
      '0231',
      5.784397,
      1,
      NULL,
      NULL,
      ' 0-22-1990',
      9,
      9,
      NULL,
      1,
      3,
      ' 0-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 1-18-1998',
      ' 1- 6-1977',
      ' 3-18-2002',
      NULL,
      1,
      0,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.829657,
      0,
      1,
      0.488812,
      1,
      1,
      0,
      NULL,
      1,
      0.669755,
      1.050693,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      1,
      10,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.453548,
      2,
      0.201909,
      3.488859,
      NULL,
      1,
      3,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      0.451129,
      NULL,
      NULL,
      0,
      5.176949,
      1,
      1,
      0.168758,
      0.793680,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      2,
      NULL,
      1,
      1,
      2,
      0,
      2,
      NULL,
      7.970994,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0.152079,
      0,
      0,
      2,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      4,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      2,
      0,
      5.733452,
      3,
      ' 0- 6-1998',
      766.618534,
      NULL,
      98.099961,
      1.982407,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1.500424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      0,
      NULL,
      0.585289,
      NULL,
      2.203736,
      3,
      0,
      4.818750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475790,
      1.664005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.636010,
      NULL,
      0.204455,
      NULL,
      0.156154,
      NULL,
      6,
      3,
      1.260910,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      2,
      1,
      0,
      0,
      0,
      3,
      2,
      2,
      3.094739,
      NULL,
      1.832328,
      1.429129,
      0.963974,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.062216,
      0.998598,
      1,
      NULL,
      0,
      0.634990,
      1,
      7.066774,
      7,
      NULL,
      10,
      NULL,
      3,
      2.421606,
      NULL,
      0,
      1.875671,
      1,
      56.073370,
      2,
      NULL,
      1,
      NULL,
      53,
      21,
      2,
      NULL,
      3,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      28,
      180.486491,
      NULL,
      0.405892,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.308450,
      0.509756,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.487294,
      3,
      1.830385,
      0.792095,
      NULL,
      3,
      1,
      1,
      1.135431,
      0,
      0.316620,
      2.454815,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.647463,
      NULL,
      NULL,
      0.607515,
      1.982805,
      0,
      1.880796,
      2.687751,
      1,
      10,
      4.983157,
      3,
      1,
      1.311568,
      NULL,
      NULL,
      NULL,
      0.790201,
      NULL,
      NULL,
      NULL,
      2,
      1.024042,
      1.837201,
      2.797027,
      1,
      3.733591,
      1,
      2.156561,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.675272,
      2.226895,
      NULL,
      1.961112,
      2.848192,
      1.932700,
      0.117653,
      NULL,
      1,
      2.726473,
      2,
      2.410845,
      NULL,
      0.562080,
      3.824124,
      0.767392,
      2.766235,
      NULL,
      0.018025,
      3.667876,
      5,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.068108,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.139104,
      7,
      0,
      NULL,
      2.257885,
      2,
      0.672326,
      NULL,
      3,
      9,
      4.677521,
      3,
      0.568355,
      NULL,
      NULL,
      1.474811,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.397134,
      NULL,
      NULL,
      0,
      0.859743,
      1,
      0,
      NULL,
      NULL,
      0.749734,
      0,
      3.780845,
      NULL,
      5.178110,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700517,
      1.879292,
      0.149483,
      NULL,
      3,
      3,
      0,
      1,
      1.711138,
      0.113030,
      NULL,
      NULL,
      0.318363,
      1.616549,
      0.848724,
      2,
      2.697933,
      1.603386,
      1,
      1,
      NULL,
      3,
      1.216739,
      5.181845,
      8,
      9,
      4.782956,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.272036,
      1.115022,
      1,
      1.166625,
      2.303310,
      NULL,
      NULL,
      1.918252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098790,
      NULL,
      NULL,
      0.182716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.453563,
      NULL,
      NULL,
      1.422049,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.468800,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.554745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.764966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0.038659,
      0,
      1.070057,
      NULL,
      NULL,
      1.940453,
      NULL,
      NULL,
      1.392799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.577716,
      NULL,
      NULL,
      7848,
      55,
      1,
      0.886749,
      0.429515,
      NULL,
      NULL,
      1.659716,
      1,
      1.873661,
      1,
      0,
      0,
      0.722622,
      1,
      0,
      1,
      0.138127,
      0.128057,
      0.892540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.379193,
      1,
      3,
      1,
      0,
      3.508063,
      0,
      2,
      0,
      0.599512,
      0,
      NULL,
      1.713577,
      0.876300,
      NULL,
      0,
      0,
      NULL,
      1,
      1.395426,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.615063,
      NULL,
      1.682365,
      0.177432,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113531,
      NULL,
      1,
      NULL,
      4,
      5,
      6,
      3.288941,
      0.786745,
      2.003745,
      NULL,
      52,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1.229869,
      '',
      '',
      NULL);
commit;
end;
/


