set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4614445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0144033',
      3,
      1,
      3,
      2,
      '4310',
      2.323829,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583223,
      ' 0- 5-1992',
      83.121063,
      3.000497,
      80.417833,
      119.312720,
      3,
      NULL,
      NULL,
      ' 5-26-1991',
      3.152448,
      1.843772,
      NULL,
      0.051238,
      1,
      1.132978,
      2,
      1.589452,
      2,
      NULL,
      6,
      5.263145,
      5.440304,
      NULL,
      5,
      2,
      12.331736,
      1,
      1,
      10.816388,
      NULL,
      0,
      1,
      1,
      NULL,
      1.376670,
      1,
      3,
      2,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      0.857804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.454945,
      0,
      0,
      1.997192,
      1.539216,
      0.138737,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802267,
      0.126406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.055679,
      1,
      0.736115,
      0.628027,
      NULL,
      1.296641,
      1.497223,
      NULL,
      NULL,
      NULL,
      1,
      1.668292,
      2,
      1,
      2,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0.190382,
      NULL,
      0,
      3.301762,
      0,
      0.303680,
      0,
      1.446294,
      0.849597,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121274,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      '24113',
      '42440',
      NULL,
      0.927351,
      '',
      '',
      NULL,
      0.687341,
      '',
      '',
      '',
      NULL,
      NULL,
      956.919345,
      13,
      1,
      10,
      3.962199,
      16.953276,
      3,
      NULL,
      0.598280,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.521164,
      0.906050,
      0,
      NULL,
      NULL,
      1.591781,
      NULL,
      NULL,
      0.639365,
      NULL,
      NULL,
      1.173020,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.771015,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      0,
      NULL,
      0.419111,
      1.054211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887804,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.892124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899182,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.633284,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      8,
      3,
      1,
      1.087258,
      0.811298,
      NULL,
      2,
      1.948241,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      2.701069,
      NULL,
      0.362595,
      4,
      NULL,
      2.859218,
      3.609507,
      4.587234,
      2.934171,
      3.607301,
      1,
      NULL,
      NULL,
      0.388180,
      1.834224,
      1,
      0,
      1,
      1.454636,
      NULL,
      NULL,
      NULL,
      0.210500,
      0.702318,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.926631,
      3,
      1.130412,
      NULL,
      5,
      4,
      9,
      NULL,
      3,
      2,
      0,
      0,
      3,
      NULL,
      1,
      1,
      1.201784,
      0.950346,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.294647,
      NULL,
      NULL,
      0.301255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9.521831,
      NULL,
      NULL,
      2.480838,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791770,
      NULL,
      NULL,
      3.699676,
      1,
      NULL,
      0.903172,
      1.128438,
      1.416702,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139273,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.315379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      54.291599,
      1,
      1547,
      1.443048,
      0,
      NULL,
      0.115075,
      0,
      1,
      1.848692,
      0.112107,
      NULL,
      0.706896,
      1.273874,
      0,
      NULL,
      1.542638,
      1.425474,
      NULL,
      1,
      0.084170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0.430248,
      NULL,
      0.263805,
      3.607728,
      0,
      21,
      0.341127,
      0.295769,
      0.169183,
      0,
      0,
      1,
      0.741757,
      1.137139,
      NULL,
      1.911178,
      0.795182,
      1,
      0,
      1.514022,
      1.268730,
      1,
      1,
      0,
      1,
      0.247343,
      1.650428,
      1.293166,
      0,
      1,
      1,
      0,
      1.689203,
      1,
      0.829613,
      1,
      1,
      1.694196,
      NULL,
      NULL,
      3,
      3.293229,
      NULL,
      1.023792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722477,
      NULL,
      1,
      0.609952,
      1,
      1,
      0,
      5,
      1,
      1.347013,
      1,
      1.709418,
      105.877227,
      91.826253,
      3,
      1.870113,
      2,
      '42210',
      '21232',
      NULL,
      0,
      NULL,
      '',
      NULL,
      1.210880,
      '',
      '',
      '');
commit;
end;
/


