set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3230111',
      2,
      NULL,
      5,
      1,
      '1414',
      3.163667,
      0.170366,
      NULL,
      NULL,
      ' 0-29-2001',
      2.837941,
      NULL,
      NULL,
      NULL,
      1,
      ' 9- 6-1979',
      25.824269,
      NULL,
      211.057327,
      30.403733,
      3,
      ' 8-21-1989',
      ' 8- 4-1985',
      '11-23-1991',
      1,
      0.864338,
      0,
      1,
      0.433403,
      2.804243,
      1,
      1.004826,
      NULL,
      NULL,
      NULL,
      3,
      0,
      13,
      22.958661,
      4,
      20.179717,
      1,
      0,
      8.902426,
      1.814952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1.293063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7.439122,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      1,
      1.972085,
      NULL,
      1.232136,
      1,
      2,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      5,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      0.414661,
      0.780530,
      NULL,
      145,
      ' 0-13-1990',
      408.549461,
      3,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1.841259,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.907206,
      2,
      1.167125,
      0,
      1.014821,
      NULL,
      37.196538,
      3.083624,
      0.121564,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      3,
      3,
      2,
      2,
      1,
      3,
      0,
      NULL,
      0,
      3.972960,
      1,
      NULL,
      7.242434,
      NULL,
      0.002238,
      0,
      1.053448,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.616961,
      3.123069,
      NULL,
      6,
      9,
      3.404241,
      2,
      7,
      5.768397,
      NULL,
      NULL,
      5.538300,
      1.761783,
      NULL,
      0,
      38.731570,
      NULL,
      1,
      NULL,
      71,
      0,
      16.145312,
      1,
      0.729015,
      3,
      NULL,
      '',
      '',
      NULL,
      '2443',
      '',
      '',
      1.827857,
      '1232',
      '',
      NULL,
      3.256099,
      28.264056,
      122,
      23,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.717375,
      NULL,
      NULL,
      1.754801,
      NULL,
      NULL,
      0.674597,
      NULL,
      NULL,
      1.012853,
      NULL,
      NULL,
      2.622091,
      0.543544,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.037338,
      NULL,
      NULL,
      1.894504,
      NULL,
      NULL,
      1.177650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.949920,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.232001,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.930833,
      1.925251,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1.297501,
      4.580244,
      1,
      1.528854,
      NULL,
      NULL,
      NULL,
      0.363615,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748747,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.739386,
      0,
      1.872561,
      0,
      NULL,
      NULL,
      5.441612,
      NULL,
      2.680902,
      1.658072,
      NULL,
      NULL,
      1.635093,
      NULL,
      NULL,
      1.914462,
      NULL,
      NULL,
      0.588998,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563572,
      0.884626,
      1.216956,
      NULL,
      NULL,
      0.589488,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.459326,
      1,
      3,
      1,
      NULL,
      NULL,
      0.639847,
      4,
      NULL,
      0,
      3,
      0,
      0.098115,
      2.192410,
      2,
      NULL,
      0,
      NULL,
      0.443140,
      NULL,
      NULL,
      NULL,
      5,
      5.999849,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0.406421,
      NULL,
      0.717579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879143,
      1.561437,
      0.069944,
      0,
      1.542844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839695,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111430,
      0,
      2,
      13.832789,
      2,
      NULL,
      NULL,
      NULL,
      3.136084,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.332729,
      NULL,
      1,
      1447,
      25,
      1.149595,
      NULL,
      0,
      0,
      0.921356,
      0.691760,
      NULL,
      NULL,
      0,
      1.511075,
      0.234260,
      1.883912,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.357223,
      3.753242,
      1,
      3,
      10.314299,
      NULL,
      1.913542,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.881426,
      1.223112,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.288084,
      NULL,
      1.370821,
      NULL,
      NULL,
      NULL,
      1.354739,
      NULL,
      0.789044,
      NULL,
      NULL,
      0,
      1.972805,
      NULL,
      1.336232,
      NULL,
      NULL,
      2.518209,
      1,
      1.238632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700741,
      NULL,
      0.366217,
      NULL,
      1,
      NULL,
      4,
      1,
      5,
      0.876173,
      NULL,
      NULL,
      2,
      42.966343,
      4,
      NULL,
      NULL,
      '2002',
      '',
      '',
      2,
      '2130',
      '',
      '',
      5.047564,
      '4243',
      '3130',
      NULL);
commit;
end;
/


