set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      1,
      2.147297,
      NULL,
      3.023115,
      1,
      0,
      '213',
      '13321344',
      68.096624,
      31,
      NULL,
      2,
      NULL,
      4,
      NULL,
      '0244',
      4,
      0.516825,
      NULL,
      NULL,
      NULL,
      0.178038,
      48.045613,
      NULL,
      NULL,
      1.343005,
      '10-17-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1981',
      NULL,
      0,
      3.298182,
      0.946648,
      1,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      6.657877,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.835693,
      1,
      3,
      NULL,
      1.193471,
      1,
      1,
      2,
      3,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0,
      3,
      0,
      0,
      0,
      0,
      1,
      5.783452,
      0,
      0,
      2,
      0,
      1.544746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0.864345,
      NULL,
      0,
      3,
      0,
      0,
      0,
      0,
      2,
      0,
      1,
      0,
      2,
      3,
      1,
      1,
      1,
      2,
      4,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      3.827368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.524248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.332090,
      3,
      0,
      3,
      5,
      1,
      NULL,
      NULL,
      0.173057,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.935339,
      2,
      NULL,
      NULL,
      0.896283,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      0,
      2,
      2,
      1,
      0,
      2,
      NULL,
      2.811887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318826,
      NULL,
      1.944610,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.555374,
      0.880159,
      6.727461,
      NULL,
      7.863432,
      5,
      2,
      3,
      4.463347,
      0.804670,
      2.055498,
      NULL,
      38.852880,
      1,
      1.977866,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.669624,
      '31244',
      '',
      '',
      1.923645,
      NULL,
      '',
      '',
      0.836362,
      NULL,
      NULL,
      '',
      NULL,
      1.941689,
      95.540604,
      3,
      NULL,
      17,
      4,
      1,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2.594130,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.616493,
      0,
      0.210486,
      NULL,
      NULL,
      1,
      0,
      1.771920,
      3,
      0.603175,
      NULL,
      0.731520,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      0.016653,
      NULL,
      NULL,
      NULL,
      3.741799,
      1.013343,
      1,
      2.222795,
      3,
      1.069223,
      1.870718,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.821633,
      0.788202,
      NULL,
      1.125910,
      1.477688,
      3.955881,
      1.016035,
      NULL,
      1.092588,
      2,
      NULL,
      NULL,
      3,
      1.834995,
      1,
      0.656042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731201,
      NULL,
      NULL,
      2.987705,
      0.958776,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.785306,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049156,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.629892,
      NULL,
      NULL,
      0.646197,
      NULL,
      NULL,
      0.697854,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.090432,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      NULL,
      1.256613,
      NULL,
      3,
      6,
      4.743459,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      0,
      0.284378,
      3.517136,
      2,
      1,
      0.047450,
      3.064696,
      2.461016,
      NULL,
      0.862250,
      NULL,
      NULL,
      1.165396,
      3,
      0,
      NULL,
      2,
      5,
      4.922442,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.764801,
      1.605444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244592,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.115127,
      NULL,
      NULL,
      1.749462,
      NULL,
      NULL,
      1.195406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338333,
      NULL,
      NULL,
      NULL,
      0,
      1.388945,
      NULL,
      1.432510,
      NULL,
      1,
      NULL,
      1.945501,
      NULL,
      NULL,
      NULL,
      3.292268,
      0.239773,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.831696,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.097552,
      1,
      NULL,
      NULL,
      3.800044,
      NULL,
      NULL,
      NULL,
      3.945978,
      1.888596,
      NULL,
      NULL,
      1.726775,
      0.708205,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.909906,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.377053,
      3,
      NULL,
      NULL,
      NULL,
      1.684964,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.117062,
      6,
      6.450270,
      3.918439,
      8,
      NULL,
      0.577227,
      NULL,
      NULL,
      2,
      2.043228,
      NULL,
      0.660704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.540727,
      1,
      1,
      0.514409,
      NULL,
      NULL,
      NULL,
      1.888476,
      0,
      1,
      1,
      0.601206,
      0,
      0,
      0.953246,
      1.833998,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.869414,
      0.384586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213726,
      0.797144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645213,
      1.747794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342999,
      3.087186,
      NULL,
      0,
      NULL,
      1.330611,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.762040,
      NULL,
      0,
      1.425003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0.391694,
      1,
      2.806002,
      1,
      8.375392,
      1.757849,
      NULL,
      0.395614,
      1,
      1.663917,
      0,
      3,
      0.669126,
      1,
      3.665185,
      1,
      3,
      1.534460,
      1.816753,
      0,
      1,
      2.486444,
      3.459294,
      1.965098,
      1,
      1.403838,
      1,
      NULL,
      0,
      0,
      1.635939,
      0.378148,
      1,
      0,
      1,
      1,
      NULL,
      3,
      1.109926,
      NULL,
      0,
      NULL,
      2.897676,
      0.469357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447757,
      NULL,
      1.840596,
      0.918101,
      0,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      72,
      35,
      NULL,
      3.528309,
      1,
      '32241',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


