set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '33',
      10,
      NULL,
      '1021302',
      0,
      1.664646,
      2,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      ' 0-10-2002',
      20,
      NULL,
      NULL,
      NULL,
      1,
      ' 0-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-16-1995',
      '10-16-1999',
      ' 3-10-1988',
      0.893900,
      3.292988,
      1,
      0,
      1.347329,
      2,
      2,
      NULL,
      0.561865,
      12.740923,
      NULL,
      4,
      9.080786,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      NULL,
      0,
      1.075948,
      1,
      NULL,
      NULL,
      NULL,
      1.507206,
      1,
      1.307621,
      1,
      2,
      3,
      NULL,
      5,
      0,
      4,
      1,
      1,
      4,
      3,
      3,
      1,
      2,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      1.694959,
      NULL,
      1.929971,
      1.004005,
      2,
      1.264657,
      0,
      3,
      NULL,
      0,
      2,
      1.705507,
      1.031108,
      0,
      NULL,
      1.160134,
      0.738506,
      1,
      NULL,
      NULL,
      1.301336,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.976051,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      4,
      0,
      2,
      4,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      4,
      3,
      5,
      5.111159,
      3.481129,
      ' 8- 8-1987',
      2.965546,
      NULL,
      1.298761,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      11.232978,
      0.691424,
      1.201469,
      NULL,
      1.951212,
      0,
      NULL,
      2.849679,
      5.917635,
      NULL,
      0.789701,
      NULL,
      1.368957,
      2,
      NULL,
      4,
      NULL,
      2.255972,
      NULL,
      NULL,
      5.728932,
      2.408826,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816301,
      NULL,
      0.856466,
      0,
      0.566252,
      1,
      0.677232,
      9,
      2,
      1.034144,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      3,
      2,
      0,
      NULL,
      2,
      2.926003,
      4.187985,
      0,
      0.868600,
      0,
      1,
      1.972999,
      1,
      1.429501,
      1.286825,
      0,
      1.140182,
      0,
      0,
      1,
      NULL,
      5.064782,
      NULL,
      8,
      6,
      NULL,
      0.941815,
      NULL,
      2,
      2,
      NULL,
      1,
      3.186795,
      3.775348,
      1,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      23,
      5,
      0,
      1.549093,
      '10103',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      3,
      15.098847,
      10,
      23,
      1,
      1,
      2.804660,
      5.658596,
      5,
      1.538572,
      3.478572,
      0,
      NULL,
      NULL,
      NULL,
      0.428951,
      NULL,
      NULL,
      0.621686,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.089443,
      NULL,
      NULL,
      0,
      1,
      1.802241,
      1.660374,
      NULL,
      NULL,
      0.978939,
      NULL,
      NULL,
      0.511478,
      NULL,
      NULL,
      1.685416,
      NULL,
      NULL,
      1.453012,
      NULL,
      NULL,
      3,
      2,
      2,
      0,
      1.993730,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.061006,
      3,
      2.365629,
      2.451938,
      0,
      0,
      3.824263,
      1.193598,
      1.311128,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.555148,
      0,
      3.051843,
      1.827152,
      0,
      3.381267,
      1,
      0.304306,
      NULL,
      1.808857,
      1.020328,
      2,
      3,
      3.468348,
      0,
      NULL,
      NULL,
      0,
      3.490584,
      0.933185,
      NULL,
      4.797681,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560086,
      NULL,
      0.710399,
      0.371455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.734283,
      NULL,
      1.860796,
      0.846448,
      NULL,
      NULL,
      3,
      3.260029,
      2,
      1.726504,
      NULL,
      1,
      3.379263,
      0.073402,
      NULL,
      3.829015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.431208,
      NULL,
      1.331750,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6,
      3,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      2.741620,
      3.224217,
      1.729216,
      7.343899,
      0.564306,
      1,
      2.057537,
      0.650943,
      1.330721,
      3,
      3.029308,
      NULL,
      3.905599,
      1.270721,
      0.321990,
      1,
      3.367614,
      0.137738,
      3.405725,
      5.263091,
      NULL,
      4,
      2,
      4.113980,
      2.230514,
      NULL,
      4,
      NULL,
      0,
      0,
      0.512747,
      1.704971,
      3.766003,
      NULL,
      NULL,
      0.386407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.837840,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.113914,
      NULL,
      NULL,
      1.810139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.881361,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.685893,
      NULL,
      1.095846,
      NULL,
      7,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.118552,
      NULL,
      1.588187,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.933903,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.458078,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.250830,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.424609,
      NULL,
      2.689586,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      6.388618,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      7.307528,
      4,
      NULL,
      2.673786,
      0.622121,
      1,
      NULL,
      NULL,
      1,
      2.041099,
      0.107643,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.901898,
      8,
      0.330011,
      0,
      1.818693,
      1.099096,
      1.469411,
      NULL,
      1,
      0.247203,
      0.348622,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      6,
      1,
      3,
      NULL,
      2,
      7.732285,
      1,
      NULL,
      1.097893,
      1,
      1.557415,
      0,
      1,
      1.536072,
      NULL,
      0.831066,
      0,
      1.880155,
      0.366045,
      0,
      0,
      0,
      0.602697,
      1.850273,
      0.990724,
      0,
      0,
      NULL,
      0.925738,
      2.177773,
      1,
      1,
      0,
      NULL,
      1.256063,
      0.922809,
      2,
      1.442365,
      NULL,
      0,
      0,
      2.365433,
      2.429471,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982229,
      0.230850,
      0,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      80.356911,
      15.275220,
      5,
      5.612488,
      0,
      '40121',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '200',
      '',
      '');
commit;
end;
/


