set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.612028,
      NULL,
      NULL,
      3.807447,
      2,
      3.508214,
      3.397835,
      3.742211,
      '201',
      '20304034',
      37,
      22,
      '1401420',
      3,
      0,
      3,
      2,
      '1402',
      5.504766,
      0,
      NULL,
      NULL,
      '11- 9-2001',
      189,
      107,
      NULL,
      1.238910,
      3,
      ' 8-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 7- 0-1978',
      ' 9- 7-2003',
      NULL,
      NULL,
      NULL,
      3.132213,
      NULL,
      0.613679,
      1,
      3,
      1,
      1.072640,
      0.401183,
      NULL,
      NULL,
      9.706224,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.870118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      0,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1,
      4,
      4,
      1,
      0,
      2,
      1.230519,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      0,
      2.656521,
      1.094809,
      2.645567,
      1.194390,
      0,
      1.309455,
      3.913054,
      0,
      0.196260,
      1.708797,
      1,
      2,
      0.185760,
      2,
      NULL,
      0,
      1,
      1,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      0,
      4,
      1,
      NULL,
      1,
      3,
      0,
      1,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      4,
      2,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      3,
      2,
      1,
      5,
      2,
      0,
      4,
      1,
      NULL,
      3,
      2.668911,
      3.434235,
      ' 4-16-1983',
      110.452440,
      NULL,
      5.782531,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      1.619348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.322255,
      NULL,
      2.051717,
      2.944950,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148751,
      1.260068,
      5.265975,
      2.161072,
      3.294318,
      1.573979,
      1,
      NULL,
      NULL,
      NULL,
      1.592674,
      0.274984,
      1.665379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.090465,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      14.967410,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.127232,
      2.983486,
      3,
      NULL,
      2,
      0,
      2,
      1,
      2,
      2,
      3,
      3,
      NULL,
      1,
      0,
      1.891744,
      0,
      NULL,
      1.933036,
      NULL,
      0,
      0,
      0,
      1,
      1.368720,
      1.380658,
      1,
      1,
      NULL,
      NULL,
      1.756597,
      1,
      10.698732,
      4.743854,
      8.969638,
      4,
      4.047202,
      NULL,
      0.977579,
      1,
      3,
      3.870063,
      2,
      26,
      2,
      3,
      17,
      NULL,
      NULL,
      44.583709,
      1,
      5,
      0.980816,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      20,
      65,
      38.827773,
      3,
      25,
      9.031022,
      5.160123,
      NULL,
      NULL,
      3.161425,
      3,
      1.309509,
      NULL,
      NULL,
      2.804316,
      NULL,
      NULL,
      1.851375,
      3,
      1.566870,
      3.671394,
      1,
      1.431420,
      2,
      2.413393,
      1,
      0.362776,
      0.805948,
      3.377046,
      3,
      1.071939,
      3.679705,
      2,
      NULL,
      NULL,
      1.020717,
      0,
      0.453695,
      2.936743,
      0.905729,
      0.988842,
      0.997767,
      3,
      NULL,
      NULL,
      2.256259,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.728343,
      0.979025,
      2,
      3,
      1,
      NULL,
      0,
      3,
      NULL,
      0.960210,
      NULL,
      2.074095,
      NULL,
      1.600966,
      NULL,
      1.955700,
      1.545031,
      2,
      0,
      NULL,
      1,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      5.273690,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.253675,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610195,
      0,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.005355,
      0,
      3.507336,
      0,
      0.029233,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.885467,
      1,
      0.531474,
      1,
      NULL,
      NULL,
      0.348650,
      NULL,
      NULL,
      7.087786,
      0,
      0.229483,
      NULL,
      5,
      0.993993,
      2.445798,
      NULL,
      NULL,
      1,
      0,
      1,
      1.333382,
      0.930216,
      3,
      NULL,
      5,
      5.412429,
      NULL,
      0,
      3.118811,
      NULL,
      3,
      0,
      1,
      2,
      1.154230,
      0,
      2.981733,
      NULL,
      4,
      2.469432,
      1,
      1,
      1.933944,
      2.535850,
      2.161962,
      3,
      4,
      0.755917,
      NULL,
      1,
      0.712754,
      1,
      NULL,
      NULL,
      NULL,
      0.878267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.990013,
      NULL,
      NULL,
      1.526157,
      NULL,
      NULL,
      1.672062,
      NULL,
      NULL,
      2,
      2.256469,
      3,
      1.623724,
      0.323802,
      3,
      0,
      NULL,
      4.842718,
      1,
      9,
      NULL,
      6,
      1.283633,
      0.039924,
      NULL,
      1.095193,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.011871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.952660,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      0.498213,
      1.256353,
      NULL,
      3.418658,
      2,
      0.571501,
      NULL,
      2.609928,
      2,
      2.036254,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.338695,
      NULL,
      0,
      1.299081,
      1.592911,
      NULL,
      7.634674,
      1.851651,
      0,
      NULL,
      0.996758,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0.794647,
      0,
      9.667739,
      0.559855,
      0.481281,
      NULL,
      NULL,
      3,
      0,
      1.924661,
      0.782942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.067255,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      1.343609,
      1.651155,
      NULL,
      0.914770,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.955692,
      0.349017,
      1.942790,
      0.790788,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0.957392,
      NULL,
      1.866772,
      1.412748,
      NULL,
      2,
      1.601017,
      2,
      1.551109,
      0,
      0,
      1.675729,
      NULL,
      1.516890,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0.837654,
      NULL,
      1,
      1.983518,
      1,
      1,
      0.145299,
      1.085629,
      1.695845,
      1.066074,
      3.763305,
      1.689488,
      0.818794,
      NULL,
      0,
      3.161824,
      3,
      1.694493,
      1,
      3.306680,
      1,
      NULL,
      0.816921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517803,
      0.156070,
      0,
      1.463721,
      1.577623,
      NULL,
      3,
      4,
      1,
      1.595427,
      NULL,
      NULL,
      95,
      59.432823,
      NULL,
      0.024742,
      NULL,
      '43122',
      '41423',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


