set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1103220',
      1,
      0,
      NULL,
      2,
      '3100',
      1.406982,
      0,
      NULL,
      NULL,
      NULL,
      22.392318,
      NULL,
      5,
      3.603565,
      3.400297,
      ' 2- 3-1977',
      38.152768,
      3,
      186,
      NULL,
      3,
      ' 3-29-1987',
      '10- 1-1987',
      NULL,
      NULL,
      NULL,
      0.812434,
      NULL,
      1,
      NULL,
      3,
      1.665450,
      NULL,
      NULL,
      NULL,
      13.412216,
      NULL,
      18.587611,
      1.309647,
      5,
      20,
      2,
      NULL,
      7.492023,
      NULL,
      0,
      1,
      0.652435,
      0.611850,
      0,
      NULL,
      0,
      NULL,
      0,
      1.116788,
      NULL,
      3,
      NULL,
      1.449576,
      5,
      1,
      1,
      5,
      NULL,
      1,
      5,
      0,
      2,
      1,
      0,
      1,
      6,
      0,
      2,
      2,
      1,
      1.325888,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.361713,
      1.307360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.139773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0.020604,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1.821411,
      3,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      5,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      2,
      1,
      3,
      5,
      5,
      0,
      5,
      2,
      NULL,
      97.777080,
      ' 4-12-1989',
      12.378247,
      1.755157,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.782915,
      3.178308,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.208058,
      NULL,
      0.191302,
      1.550130,
      7.686563,
      NULL,
      NULL,
      NULL,
      1,
      8,
      0.298399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.171290,
      1.077607,
      NULL,
      1,
      0.908041,
      0.045610,
      1.163945,
      14.921566,
      2.453917,
      0.786053,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      3.059860,
      NULL,
      0,
      1,
      6,
      0.614460,
      0,
      0.916365,
      0,
      NULL,
      1,
      1,
      0.537997,
      1,
      0.406214,
      0,
      NULL,
      8.231492,
      3.369184,
      NULL,
      2,
      11,
      0.149605,
      0.024139,
      0.441127,
      0,
      0,
      1.289005,
      0,
      14,
      0,
      0.964338,
      NULL,
      16,
      NULL,
      55.034760,
      2,
      NULL,
      1.221192,
      '20110',
      NULL,
      '',
      0.242462,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      48.013245,
      2.364513,
      3.686288,
      29.605686,
      1,
      1.162306,
      2,
      2.765293,
      1.420923,
      3,
      1.154678,
      NULL,
      NULL,
      NULL,
      1.499217,
      3,
      NULL,
      NULL,
      2.407576,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      3.261632,
      1.998315,
      NULL,
      NULL,
      NULL,
      3.125304,
      0,
      3,
      1.691107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.966072,
      NULL,
      NULL,
      6,
      4.308931,
      5,
      NULL,
      0.794154,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.547273,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.313021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.167632,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.544399,
      1.677680,
      1,
      3.063319,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309595,
      NULL,
      NULL,
      0.111669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.048934,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      3,
      1.862249,
      1.803652,
      1.866129,
      NULL,
      NULL,
      1.102498,
      NULL,
      NULL,
      NULL,
      0.625724,
      0,
      0,
      NULL,
      NULL,
      5,
      1.441829,
      5.503660,
      1,
      NULL,
      2.297399,
      1,
      0.761447,
      1,
      NULL,
      1,
      3,
      3,
      2.394531,
      0,
      6.887067,
      4,
      7.614371,
      4.506896,
      3,
      4.982819,
      0,
      1,
      1,
      1.747745,
      0,
      1.178522,
      1.554918,
      1,
      2.306390,
      NULL,
      NULL,
      2.474822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.115249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.787362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.042039,
      NULL,
      NULL,
      3,
      1.563765,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4.927547,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      0.353082,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.268791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.441355,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.563844,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.870841,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.795272,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.438129,
      0.525258,
      NULL,
      1,
      1.039643,
      NULL,
      NULL,
      NULL,
      0.084936,
      NULL,
      NULL,
      1.652605,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      621.302497,
      0,
      NULL,
      0.551285,
      0.175891,
      1,
      0,
      1,
      0.884044,
      0,
      NULL,
      0.847371,
      NULL,
      0.431641,
      1,
      1.011019,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4.685859,
      0,
      0,
      3,
      1,
      NULL,
      3,
      3.784148,
      NULL,
      1,
      1.548094,
      NULL,
      0,
      0,
      NULL,
      2.671459,
      1.760860,
      NULL,
      1.064349,
      NULL,
      NULL,
      1.293238,
      0,
      NULL,
      NULL,
      1.573074,
      NULL,
      1.691517,
      2.524789,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.247751,
      NULL,
      0.296237,
      0,
      NULL,
      0.730063,
      0,
      NULL,
      3.932676,
      1.674192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702900,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.799558,
      NULL,
      NULL,
      NULL,
      0.220186,
      NULL,
      0,
      NULL,
      2.498717,
      NULL,
      0.803814,
      NULL,
      3,
      NULL,
      2,
      NULL,
      7.197345,
      0,
      NULL,
      0.255135,
      NULL,
      3,
      NULL,
      1,
      NULL,
      4,
      3,
      6,
      NULL,
      NULL,
      NULL,
      66.041301,
      NULL,
      3,
      NULL,
      5,
      '40442',
      '02241',
      '',
      NULL,
      '22030',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


