set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944128';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3010240',
      3.640304,
      1,
      2,
      3,
      '3003',
      NULL,
      0,
      NULL,
      NULL,
      ' 3- 2-1980',
      NULL,
      NULL,
      NULL,
      0,
      0.111749,
      ' 7-14-1981',
      33.603284,
      5.875007,
      16.083645,
      145.230590,
      1,
      NULL,
      '11- 8-1979',
      ' 6-20-1982',
      1.876845,
      NULL,
      3.657801,
      0.601657,
      1.095216,
      2,
      3,
      1.651433,
      0.646194,
      162.555292,
      3,
      15,
      6.773066,
      189,
      75.746249,
      1,
      14,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      1.087895,
      1,
      0.066404,
      1,
      1,
      NULL,
      0.613934,
      131,
      NULL,
      2,
      2,
      2.377063,
      3,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      1,
      1,
      1.352414,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.307207,
      0,
      0.773291,
      1.346945,
      1,
      1,
      1.276275,
      0,
      NULL,
      0.852087,
      NULL,
      1,
      0.979111,
      0,
      0,
      NULL,
      2,
      0,
      5,
      8.763076,
      1,
      0,
      2,
      NULL,
      1.289203,
      0,
      0.922722,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      5,
      1,
      2,
      1,
      3,
      5,
      1,
      1,
      1,
      9.240483,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.647793,
      1,
      2,
      3,
      2,
      0,
      NULL,
      5,
      0,
      3,
      0,
      1,
      1,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      4,
      1,
      1,
      4,
      5,
      0,
      5,
      8,
      NULL,
      ' 7-10-1991',
      NULL,
      '10- 7-2003',
      254,
      1.806613,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      4.608474,
      2,
      ' 1- 4-1990',
      1.646535,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764819,
      0.623509,
      7.944476,
      0,
      0,
      1,
      1.572019,
      NULL,
      NULL,
      NULL,
      0.545247,
      4,
      1.574581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      0.366212,
      1,
      0,
      1,
      24.532582,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.201204,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      3,
      0.214483,
      1.858754,
      3.100172,
      NULL,
      0.061212,
      1,
      6.122908,
      NULL,
      NULL,
      0.487311,
      NULL,
      0,
      1.956793,
      0.363318,
      NULL,
      1,
      1.416428,
      3,
      1,
      10.469033,
      3.263942,
      7,
      0,
      10.624036,
      NULL,
      2.043894,
      3,
      NULL,
      NULL,
      2.769507,
      1.926439,
      NULL,
      1,
      1.943779,
      NULL,
      37,
      11,
      65,
      0,
      1,
      2.638255,
      '03302',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      2,
      '1311',
      '2242',
      '',
      2,
      11.860084,
      193,
      18,
      NULL,
      45.379638,
      5.439648,
      157.488662,
      1,
      0.797582,
      1.191140,
      2,
      0.770754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      1.092618,
      2.567574,
      0.045174,
      3,
      1.156183,
      0.279065,
      NULL,
      2,
      NULL,
      2.981303,
      3.843957,
      1.522782,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.963650,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      3,
      0.456450,
      2.206390,
      0.578193,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.340150,
      1,
      NULL,
      NULL,
      NULL,
      15.924575,
      NULL,
      NULL,
      NULL,
      1,
      1.927779,
      1,
      0,
      NULL,
      1,
      0,
      1.058238,
      NULL,
      1.362569,
      1.560683,
      1.288374,
      0.123860,
      1,
      0.489203,
      0,
      0.396006,
      0.018930,
      0,
      NULL,
      NULL,
      2,
      1.845439,
      1,
      6.053804,
      5,
      1,
      1,
      NULL,
      4,
      18,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.272929,
      2,
      2,
      3,
      NULL,
      2.343649,
      3.750577,
      2.715851,
      3,
      1,
      NULL,
      NULL,
      4,
      2,
      7.354568,
      NULL,
      3,
      1.829159,
      1.378388,
      3.674815,
      NULL,
      9.883879,
      9,
      1.888426,
      1.441382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.241188,
      NULL,
      0,
      1.561359,
      3,
      0,
      9.974095,
      NULL,
      NULL,
      2,
      NULL,
      1.925836,
      2.583983,
      3.069581,
      2,
      NULL,
      3.888694,
      NULL,
      2,
      3.173417,
      NULL,
      1.842465,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.456258,
      1,
      3.059969,
      2.347449,
      NULL,
      1.063073,
      0.863638,
      3,
      0,
      0,
      2.769243,
      2.328252,
      9,
      4,
      3.908509,
      0,
      5.794156,
      0,
      1.515741,
      2,
      NULL,
      3.903739,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      20.186778,
      NULL,
      1.228035,
      1.012848,
      NULL,
      1.237460,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.078206,
      NULL,
      2.895350,
      0,
      NULL,
      NULL,
      0.770295,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.029871,
      2.253607,
      NULL,
      3.540105,
      7,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.815206,
      1.122134,
      1,
      2.425205,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318358,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.350647,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.411637,
      3,
      NULL,
      NULL,
      0,
      0.479453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.933724,
      1.297048,
      NULL,
      NULL,
      9,
      1.668742,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      94.551447,
      15.210488,
      0,
      NULL,
      NULL,
      1.054689,
      15.604325,
      4.527294,
      NULL,
      NULL,
      NULL,
      0.519174,
      3.486955,
      0.689824,
      NULL,
      NULL,
      NULL,
      NULL,
      8.515801,
      0.548741,
      1.762746,
      NULL,
      0.031085,
      1.713650,
      0.803044,
      NULL,
      0,
      1.436115,
      0,
      1.012995,
      1,
      1.936782,
      0.636501,
      1.998475,
      1,
      1.564965,
      1.731346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.977805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113494,
      0.945476,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.198017,
      NULL,
      NULL,
      NULL,
      1,
      1.948581,
      1.014670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.155711,
      NULL,
      1.115204,
      1.862447,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.829142,
      0,
      NULL,
      0,
      3.824310,
      NULL,
      2,
      NULL,
      0,
      0,
      0.367507,
      0,
      0.922152,
      1,
      1.824461,
      NULL,
      1,
      1,
      1.144734,
      1,
      0,
      1,
      1.033386,
      1.096899,
      0,
      1,
      NULL,
      1.897570,
      NULL,
      1.545724,
      0,
      0.955062,
      1.152446,
      0.548318,
      1.905919,
      0,
      3,
      NULL,
      1.939269,
      1.041591,
      3.672098,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.723834,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      7,
      1.952470,
      NULL,
      0.491218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469930,
      NULL,
      1.605781,
      1,
      1,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      2.066045,
      28.369981,
      48,
      1,
      NULL,
      0,
      '04324',
      NULL,
      '',
      1.675451,
      '',
      '',
      NULL,
      1.331710,
      '0322',
      '3401',
      '');
commit;
end;
/


