set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      2,
      '2314',
      1,
      0,
      NULL,
      NULL,
      ' 4-26-1999',
      14.533865,
      NULL,
      1,
      2.861502,
      4.882005,
      ' 2-24-2003',
      24,
      3.460127,
      190.882418,
      103.903400,
      3,
      NULL,
      ' 0- 9-1996',
      ' 0- 9-1985',
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.554522,
      0,
      2.543620,
      NULL,
      1.318580,
      5.579841,
      27.279552,
      24,
      3,
      5,
      NULL,
      0,
      7,
      0.719255,
      NULL,
      0,
      0,
      0,
      0.912094,
      NULL,
      NULL,
      1.597549,
      1,
      0,
      3,
      5,
      2,
      2.867078,
      4,
      0,
      0,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.170268,
      NULL,
      NULL,
      3,
      1,
      8,
      NULL,
      NULL,
      2.614429,
      3.586040,
      3.242092,
      0,
      2.447882,
      3,
      0.421229,
      1,
      2.495634,
      0,
      3.553197,
      1,
      NULL,
      2.481267,
      2,
      NULL,
      3,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1.422521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      5.321553,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.386054,
      1,
      0,
      2,
      4,
      1,
      2,
      5,
      NULL,
      3,
      3,
      4,
      NULL,
      4,
      5,
      1,
      NULL,
      5,
      1,
      NULL,
      5,
      5,
      0,
      2,
      2,
      1,
      5.206595,
      1.826756,
      ' 8-24-1985',
      408.450070,
      '10-12-1987',
      75,
      2,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.924275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.795059,
      3,
      0.873622,
      1,
      2.129759,
      0.433356,
      0,
      0,
      6,
      1,
      3.805593,
      1.643434,
      NULL,
      NULL,
      NULL,
      1,
      7.475138,
      2,
      5.794165,
      2,
      4.241280,
      0,
      NULL,
      NULL,
      NULL,
      0.076217,
      9.563910,
      0.875959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545251,
      1.924465,
      1.692037,
      NULL,
      0,
      NULL,
      0,
      NULL,
      17,
      2.092764,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      3,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      NULL,
      2,
      3,
      0,
      3,
      1.529432,
      0.880710,
      0,
      0.306270,
      NULL,
      NULL,
      0.401380,
      NULL,
      1,
      1.709832,
      1,
      1,
      0,
      1.836936,
      3.737826,
      0.901789,
      9,
      0.823451,
      5,
      3,
      4,
      2.487519,
      4.757356,
      2,
      1.958295,
      2.708851,
      3.386344,
      2.936844,
      NULL,
      3,
      3.876680,
      NULL,
      64,
      30,
      48.720450,
      NULL,
      NULL,
      2,
      '44401',
      '',
      NULL,
      1.826704,
      '',
      '',
      '',
      0.307908,
      NULL,
      '',
      NULL,
      0.263111,
      31,
      81,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.137425,
      NULL,
      0.573576,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.106134,
      3,
      3.951455,
      1.996013,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      3,
      2,
      3.019319,
      NULL,
      3,
      NULL,
      0,
      0.986659,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      0,
      3,
      0,
      0.731097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264618,
      1.663906,
      2.325724,
      0.889554,
      0.150934,
      0,
      NULL,
      2.334328,
      1,
      0,
      NULL,
      0,
      1.883619,
      2.999322,
      2.840137,
      2.238485,
      0.963091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.563913,
      0.869021,
      1.622046,
      8.490180,
      0.118069,
      3.762932,
      1,
      1.029148,
      NULL,
      NULL,
      NULL,
      3.499002,
      3,
      NULL,
      0,
      1.280119,
      NULL,
      NULL,
      0.298451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.514582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.821073,
      NULL,
      NULL,
      1.278535,
      NULL,
      NULL,
      1.066900,
      NULL,
      NULL,
      2.936644,
      3,
      2.897432,
      1.269373,
      NULL,
      NULL,
      NULL,
      0.770429,
      2,
      6.157781,
      2,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3.109245,
      3,
      NULL,
      2.328379,
      NULL,
      0,
      0.700295,
      NULL,
      NULL,
      1.540673,
      1.321371,
      1.782030,
      3.631592,
      NULL,
      1,
      NULL,
      2,
      8,
      0.395770,
      NULL,
      5.207541,
      3.785972,
      1.023313,
      2,
      4,
      2,
      0.083334,
      0.724621,
      1,
      1,
      1.961173,
      NULL,
      NULL,
      NULL,
      0.830591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992304,
      NULL,
      0,
      1.246528,
      1.570409,
      3,
      0,
      NULL,
      0,
      5.035085,
      NULL,
      NULL,
      NULL,
      5.235008,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.147448,
      NULL,
      NULL,
      3,
      1.393158,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.149589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079938,
      NULL,
      NULL,
      NULL,
      0.623850,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.517231,
      NULL,
      NULL,
      NULL,
      0,
      1.352624,
      NULL,
      NULL,
      1,
      1.199681,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.917639,
      0,
      NULL,
      NULL,
      0.292269,
      0.255638,
      NULL,
      NULL,
      6,
      10.822592,
      NULL,
      NULL,
      0.045124,
      1,
      NULL,
      NULL,
      NULL,
      0.909767,
      10.476753,
      0,
      0,
      5.629934,
      1.709755,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223699,
      0,
      0.054760,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.420318,
      9.341573,
      1,
      1,
      0,
      0.918605,
      0.213611,
      0,
      1.991098,
      NULL,
      0,
      0,
      1.764018,
      1,
      NULL,
      0.209004,
      NULL,
      1.165577,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      3,
      1,
      NULL,
      1,
      7,
      3,
      NULL,
      0,
      1.921626,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      1.216287,
      NULL,
      1.857889,
      0,
      NULL,
      1,
      2.055495,
      NULL,
      0.063905,
      3.989571,
      NULL,
      0.277146,
      1.421628,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.227599,
      NULL,
      1.791069,
      NULL,
      NULL,
      0.856022,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231010,
      NULL,
      1.377686,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      29,
      1,
      0.132960,
      2,
      '41333',
      '',
      '',
      1.186461,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


