set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2311123',
      2,
      1.286780,
      1,
      3,
      '0132',
      0,
      1,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      1,
      3.296580,
      NULL,
      ' 2-21-1982',
      23,
      1,
      343.082370,
      90,
      2,
      NULL,
      NULL,
      ' 9-23-1984',
      1,
      1.984242,
      2.843912,
      3.535435,
      1.203680,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11.593118,
      2.747569,
      17.969554,
      13,
      1,
      NULL,
      0,
      NULL,
      4,
      0.904457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      1,
      3,
      NULL,
      3,
      5,
      1,
      0,
      3,
      0,
      1,
      0,
      NULL,
      5,
      6.151120,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      0,
      1.573938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      7.814038,
      0,
      2,
      0.814106,
      1.495634,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      NULL,
      2,
      0,
      4,
      0,
      4,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.319960,
      1,
      1,
      5,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      4,
      3,
      NULL,
      1,
      1,
      NULL,
      3,
      5,
      0,
      NULL,
      0,
      4,
      5,
      2.319671,
      NULL,
      ' 4-10-2001',
      1.809303,
      ' 5-29-2003',
      6,
      0.564041,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9,
      0.119695,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.662596,
      3.953877,
      1,
      2,
      0.823473,
      0.191789,
      NULL,
      3,
      7,
      6.401606,
      1.753227,
      4,
      0.061801,
      NULL,
      NULL,
      1.607144,
      13,
      0,
      2,
      NULL,
      NULL,
      3,
      ' 1- 8-1996',
      8.624883,
      ' 8-27-1990',
      7.805601,
      1.918059,
      1,
      NULL,
      NULL,
      1.213582,
      0.505551,
      1.462145,
      1,
      0,
      1,
      0,
      57,
      0.053718,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.611763,
      2.106101,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      3,
      3,
      1,
      3,
      0.535590,
      3,
      2.947979,
      0.397995,
      1,
      0,
      0.774582,
      NULL,
      1,
      1.831528,
      NULL,
      0,
      0,
      0.895984,
      NULL,
      0,
      2,
      0.523328,
      7.210041,
      NULL,
      4.173927,
      5.122611,
      7,
      NULL,
      2,
      3.685520,
      NULL,
      3,
      1.040385,
      0,
      52.560954,
      1,
      1.072743,
      NULL,
      16,
      17,
      69.016331,
      NULL,
      0.785025,
      3,
      NULL,
      '',
      '',
      0.917260,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3.564376,
      67.678072,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.697459,
      1.089224,
      0.514854,
      1.587911,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098629,
      NULL,
      NULL,
      1.450891,
      NULL,
      NULL,
      0.204563,
      3.951444,
      3.277901,
      1,
      NULL,
      NULL,
      1.330626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931256,
      NULL,
      NULL,
      7.050815,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.543004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3.279290,
      0.518624,
      1.751667,
      0.417770,
      NULL,
      NULL,
      2,
      1,
      3.084893,
      0,
      NULL,
      NULL,
      0.854707,
      NULL,
      NULL,
      0.848669,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598799,
      NULL,
      NULL,
      2.084731,
      3,
      NULL,
      0,
      NULL,
      3.640629,
      8.505089,
      5,
      3,
      6,
      NULL,
      1.606429,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.282675,
      NULL,
      0,
      0.239765,
      NULL,
      NULL,
      3.449142,
      NULL,
      0,
      1.465728,
      NULL,
      NULL,
      0.883370,
      3,
      1,
      3,
      2.082340,
      1.460068,
      1,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3.497559,
      7,
      NULL,
      0.672847,
      4,
      3,
      NULL,
      NULL,
      0.648225,
      0.530752,
      1,
      0.804440,
      NULL,
      NULL,
      0.828441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877975,
      NULL,
      NULL,
      1.947023,
      NULL,
      NULL,
      1.900418,
      NULL,
      NULL,
      0.369048,
      NULL,
      NULL,
      1.801022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.199506,
      NULL,
      NULL,
      1,
      0.578663,
      0.504446,
      1,
      NULL,
      0.126006,
      2,
      NULL,
      NULL,
      4.114581,
      1.601495,
      NULL,
      NULL,
      4.318099,
      61,
      NULL,
      NULL,
      2.373629,
      1,
      NULL,
      NULL,
      3,
      3.882453,
      NULL,
      NULL,
      0,
      1.854028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.624785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.952726,
      NULL,
      NULL,
      NULL,
      1,
      1.512210,
      NULL,
      NULL,
      1.965769,
      0,
      NULL,
      NULL,
      2.770612,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0.656738,
      1,
      NULL,
      NULL,
      8,
      4.825575,
      NULL,
      NULL,
      1.677652,
      NULL,
      NULL,
      NULL,
      2,
      156.684819,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566222,
      NULL,
      1.681060,
      0,
      NULL,
      1.128152,
      NULL,
      0.090476,
      NULL,
      1,
      0.739045,
      NULL,
      0,
      1.449692,
      NULL,
      1,
      0,
      1.951749,
      0.532541,
      NULL,
      0.959986,
      1.180137,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.670578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.316556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015246,
      0,
      NULL,
      1,
      NULL,
      0.324613,
      NULL,
      NULL,
      NULL,
      1.829332,
      NULL,
      1.505612,
      NULL,
      0,
      NULL,
      1.161658,
      1.567185,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143594,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.048232,
      NULL,
      0.523942,
      NULL,
      NULL,
      NULL,
      1.796273,
      1,
      0.900739,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.687594,
      NULL,
      0,
      NULL,
      0.546855,
      0,
      0.764755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0.168697,
      NULL,
      0,
      5.101490,
      3.632714,
      NULL,
      3,
      0,
      1,
      0,
      0,
      2.543242,
      NULL,
      1.283963,
      2.040477,
      1,
      0,
      1.925215,
      1.700998,
      0.861056,
      1,
      1.581065,
      0,
      0.032230,
      NULL,
      1.099474,
      1.557374,
      0.894433,
      0,
      0.301661,
      NULL,
      0.020427,
      0.578118,
      NULL,
      1,
      NULL,
      0.256464,
      0.913834,
      1.758551,
      NULL,
      1.150850,
      3.091136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.963317,
      1.900254,
      2.346887,
      NULL,
      2,
      NULL,
      1.826451,
      NULL,
      3.526756,
      NULL,
      2.432043,
      NULL,
      1,
      NULL,
      0.800087,
      NULL,
      1.124215,
      NULL,
      1,
      NULL,
      0.256658,
      NULL,
      0,
      NULL,
      0.729085,
      NULL,
      NULL,
      1.443365,
      0.869001,
      NULL,
      0.981293,
      1,
      1,
      0.518689,
      0.504287,
      1,
      NULL,
      6,
      4,
      1,
      NULL,
      NULL,
      NULL,
      61,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.530421,
      '',
      '',
      NULL);
commit;
end;
/


