set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7807074';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3103103',
      NULL,
      NULL,
      3,
      2,
      '1031',
      2.746968,
      1,
      NULL,
      NULL,
      ' 6-22-1990',
      48,
      NULL,
      2,
      NULL,
      1.696836,
      ' 3- 6-1976',
      NULL,
      2.254842,
      150,
      2.171639,
      NULL,
      ' 0-21-1986',
      ' 2-28-2001',
      '10-19-1985',
      3.303810,
      1.824080,
      2,
      0,
      NULL,
      1,
      3,
      0.728305,
      1.152663,
      NULL,
      NULL,
      19.221336,
      2,
      13.631280,
      8,
      4,
      NULL,
      4,
      5,
      3,
      0,
      NULL,
      0,
      1,
      0.673309,
      1,
      0,
      0.517919,
      0,
      0.404025,
      159.421187,
      8,
      4,
      4,
      2.301889,
      2,
      1,
      3,
      NULL,
      0,
      1,
      3,
      1,
      3,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.689474,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0.129554,
      0,
      NULL,
      2.631224,
      0,
      0.273254,
      1.672642,
      0,
      0.098168,
      1,
      0,
      3,
      1,
      NULL,
      1.715877,
      NULL,
      0,
      1,
      3,
      0,
      0,
      3.629217,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      0,
      6,
      1,
      0,
      0,
      0,
      1.582395,
      NULL,
      0,
      4,
      NULL,
      0,
      5,
      1,
      5,
      0,
      1,
      0,
      2,
      0,
      1,
      0,
      5,
      0,
      0,
      1,
      4,
      NULL,
      5,
      NULL,
      4,
      NULL,
      1,
      0,
      2.283484,
      2.583404,
      ' 1-26-1995',
      926,
      ' 3-11-1999',
      330,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.975405,
      4,
      0.968930,
      0.430497,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0.274213,
      1.052376,
      0.399921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.796548,
      0.216590,
      NULL,
      1,
      1,
      0,
      NULL,
      24.615515,
      2,
      3.279768,
      61.747128,
      0,
      42.253672,
      3,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      3,
      1,
      2,
      2,
      2,
      0,
      NULL,
      0,
      NULL,
      0.918185,
      1,
      3.232833,
      0.215094,
      NULL,
      1.838295,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.364410,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      9,
      9.762998,
      NULL,
      NULL,
      0.092172,
      NULL,
      1,
      1.271305,
      3.675523,
      60.388114,
      3,
      2.875245,
      NULL,
      25,
      1,
      28,
      1,
      NULL,
      4,
      '20200',
      '02242',
      '',
      1.196885,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      243,
      31.703731,
      NULL,
      4,
      16.594465,
      248.035347,
      2,
      NULL,
      1.706036,
      2,
      1,
      NULL,
      NULL,
      3,
      0.763874,
      1,
      1.832482,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.782838,
      0.712355,
      1.035911,
      NULL,
      1.573969,
      NULL,
      NULL,
      1.018888,
      1,
      NULL,
      NULL,
      NULL,
      0.383110,
      1.267489,
      0,
      1,
      1.521173,
      NULL,
      NULL,
      2.423808,
      1.318306,
      4,
      0,
      1.030725,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.976385,
      0,
      0.078018,
      NULL,
      1,
      NULL,
      NULL,
      1.966181,
      NULL,
      NULL,
      0,
      0.849153,
      1,
      NULL,
      1,
      0.218483,
      0,
      1.343287,
      1,
      0,
      1.202587,
      0,
      3,
      1.795453,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1.151365,
      1,
      4.848605,
      0.856984,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.179677,
      2.577622,
      0.121533,
      NULL,
      0.614053,
      NULL,
      NULL,
      1.866596,
      0.847803,
      1,
      0.203153,
      2.878085,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0.916490,
      2,
      NULL,
      1.172303,
      1,
      NULL,
      NULL,
      5,
      1,
      3,
      1.423338,
      NULL,
      NULL,
      0.230909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.848216,
      NULL,
      NULL,
      NULL,
      0.331188,
      NULL,
      0,
      NULL,
      3,
      2.165071,
      4.774225,
      1.832189,
      1,
      5,
      6.856463,
      3,
      5.527736,
      0.209384,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1.825784,
      0.278653,
      1,
      5.220007,
      NULL,
      NULL,
      2.063215,
      1,
      1,
      3.391306,
      1,
      0,
      1.201811,
      0,
      0.593522,
      3,
      1,
      3,
      7.687120,
      0,
      NULL,
      5,
      2.301085,
      5,
      1,
      0,
      4,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.707615,
      NULL,
      2,
      0,
      NULL,
      1.161110,
      0.919381,
      6.531636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.079537,
      NULL,
      NULL,
      NULL,
      2.573415,
      NULL,
      0.127909,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.919298,
      NULL,
      NULL,
      NULL,
      0.143310,
      NULL,
      1.848769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.475033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803682,
      NULL,
      NULL,
      NULL,
      0.350515,
      NULL,
      3.373459,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      2,
      NULL,
      1.810770,
      NULL,
      2,
      2.077205,
      NULL,
      0,
      2,
      206,
      15.898683,
      3,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      2.211688,
      0.395088,
      1.816177,
      10.071113,
      3.994506,
      0.527447,
      NULL,
      NULL,
      0,
      NULL,
      1.683261,
      578,
      34,
      1,
      3.201689,
      0.157731,
      0,
      1.177983,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.926017,
      0.397209,
      NULL,
      1.800232,
      1.646882,
      0,
      2.452267,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.857194,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467747,
      1.514735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183211,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.598771,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.851732,
      NULL,
      1.865556,
      NULL,
      NULL,
      NULL,
      0.938067,
      0.804203,
      0.925484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432873,
      2,
      NULL,
      NULL,
      NULL,
      0.254732,
      NULL,
      NULL,
      NULL,
      1,
      1.934326,
      1.935644,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.761296,
      NULL,
      0,
      NULL,
      0.269845,
      0,
      1.609405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.061602,
      0,
      5,
      3.659763,
      NULL,
      21.065830,
      3,
      NULL,
      0.543094,
      0.577550,
      1,
      NULL,
      0.744043,
      0,
      NULL,
      3.533210,
      3,
      NULL,
      0.523261,
      1.503457,
      NULL,
      2,
      3.965296,
      NULL,
      1.630043,
      0,
      NULL,
      NULL,
      3.222455,
      NULL,
      NULL,
      2,
      NULL,
      0.425417,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      1.863792,
      1.388683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.706402,
      3,
      NULL,
      3.516771,
      NULL,
      NULL,
      NULL,
      2.798659,
      NULL,
      2.152577,
      NULL,
      NULL,
      NULL,
      1.207301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453031,
      NULL,
      0.011610,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.364314,
      NULL,
      NULL,
      5,
      NULL,
      2.209582,
      NULL,
      3,
      53.538236,
      63,
      NULL,
      0.414049,
      3,
      '10443',
      '24311',
      NULL,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


