set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9666881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '44',
      24.675178,
      27,
      '3004404',
      NULL,
      1.031063,
      NULL,
      3,
      '3421',
      0,
      NULL,
      NULL,
      NULL,
      '10- 6-1997',
      39.712922,
      NULL,
      NULL,
      1,
      0,
      ' 2- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 4- 5-1989',
      ' 0-16-1980',
      NULL,
      0.295982,
      NULL,
      NULL,
      1,
      0,
      2,
      6,
      NULL,
      1.375041,
      190.923794,
      NULL,
      0.252002,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      1,
      1,
      0,
      1.062352,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0.264292,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.949806,
      0.000509,
      0,
      1,
      0.068348,
      2.899358,
      0,
      2.731906,
      1,
      1,
      2.283098,
      0.273297,
      1.600204,
      3.888950,
      0,
      0,
      NULL,
      NULL,
      0,
      3.073635,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.321652,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.033042,
      0,
      0,
      1,
      0,
      3,
      NULL,
      8.357241,
      1,
      1,
      NULL,
      0,
      5,
      3,
      3,
      NULL,
      4,
      5,
      4,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      4,
      5,
      NULL,
      4,
      NULL,
      4,
      NULL,
      4,
      7.838541,
      1,
      NULL,
      NULL,
      ' 2-15-1975',
      1762,
      1.700613,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.931539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      NULL,
      0.724849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.063148,
      9,
      NULL,
      0.206243,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1.316299,
      0.100266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.024258,
      1,
      1,
      0,
      NULL,
      NULL,
      6,
      3.714650,
      3,
      10,
      NULL,
      NULL,
      NULL,
      0,
      0.946833,
      2,
      NULL,
      2,
      3,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      75,
      NULL,
      2,
      91.135417,
      5,
      3,
      NULL,
      '40131',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '3231',
      '',
      '',
      2.478514,
      31.712222,
      412.994935,
      NULL,
      NULL,
      23.114283,
      0.086507,
      3,
      1,
      1,
      2.217373,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.303001,
      2.182798,
      1,
      2.147609,
      1,
      1,
      0,
      NULL,
      NULL,
      1.812150,
      NULL,
      NULL,
      0.852967,
      0,
      0.520075,
      0.250682,
      1.730074,
      1.630398,
      NULL,
      5.708744,
      5.904990,
      0,
      0.477330,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742710,
      3.594173,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.413454,
      1.359430,
      0.137454,
      0,
      0,
      1.341605,
      0.101737,
      1,
      1,
      0.369808,
      2.466774,
      1,
      3.048112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664703,
      NULL,
      NULL,
      5,
      1,
      0.861549,
      0,
      1.191445,
      NULL,
      NULL,
      NULL,
      0.658577,
      NULL,
      NULL,
      NULL,
      1.578892,
      NULL,
      NULL,
      1.183085,
      NULL,
      NULL,
      3.593357,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.732527,
      0.387846,
      NULL,
      NULL,
      NULL,
      0.331225,
      NULL,
      NULL,
      0.706101,
      NULL,
      NULL,
      0.633979,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.305847,
      2,
      2,
      NULL,
      NULL,
      3,
      3,
      0,
      1.478113,
      NULL,
      NULL,
      4,
      5,
      5.504047,
      NULL,
      3.844265,
      3.054807,
      0.114436,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335207,
      NULL,
      3.200988,
      3.660986,
      3,
      3.944684,
      3.392483,
      7.866511,
      2.062426,
      4,
      0.689282,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      3.540799,
      0.065808,
      1.920409,
      0.507470,
      4.615219,
      5,
      1,
      3,
      2,
      2.924286,
      NULL,
      2,
      NULL,
      1,
      0.545886,
      1.398498,
      0,
      0.742082,
      1.173176,
      NULL,
      NULL,
      0.653981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254432,
      NULL,
      NULL,
      1.388341,
      NULL,
      NULL,
      NULL,
      NULL,
      2.973659,
      1.297282,
      1.509794,
      NULL,
      0.584760,
      NULL,
      NULL,
      1.704533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.929563,
      NULL,
      NULL,
      NULL,
      3.709491,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.365081,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.183745,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.745266,
      NULL,
      NULL,
      NULL,
      1.750651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      4,
      3,
      2,
      70.898622,
      53,
      1,
      NULL,
      11,
      1.569758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768537,
      0,
      NULL,
      0,
      2.024078,
      0.453354,
      1.180849,
      1.588907,
      0,
      1,
      1,
      0.853896,
      NULL,
      NULL,
      1.524035,
      1.914002,
      NULL,
      0.457460,
      2.446930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485139,
      NULL,
      0.922359,
      NULL,
      0.478605,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.765213,
      0.543547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528374,
      1,
      1.197564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898174,
      NULL,
      1.258020,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      0.435643,
      2.147589,
      NULL,
      NULL,
      1,
      5,
      0,
      '40014',
      '',
      '',
      1.546954,
      NULL,
      '',
      '',
      0.185418,
      '0234',
      '',
      '');
commit;
end;
/


