set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8135230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '0022004',
      NULL,
      1,
      0,
      1,
      '1102',
      2,
      3,
      1.259360,
      2.538321,
      '10-10-1979',
      20,
      NULL,
      0,
      NULL,
      NULL,
      ' 4- 3-1989',
      NULL,
      4.162204,
      229,
      84,
      5,
      NULL,
      NULL,
      ' 3-18-2000',
      1,
      1.851884,
      0.496007,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.373839,
      1,
      10,
      12,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.815262,
      0.204053,
      1.522387,
      0,
      0,
      1.668908,
      9,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.386152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.575047,
      5,
      1,
      4,
      2,
      0,
      4,
      3,
      2,
      2,
      5,
      4,
      0,
      1,
      0,
      4,
      4,
      0,
      NULL,
      4,
      NULL,
      2,
      1,
      0,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.580998,
      1,
      1.037562,
      0,
      NULL,
      1.789040,
      NULL,
      NULL,
      NULL,
      1.108662,
      0.412358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.348073,
      0.925606,
      0.109486,
      0.967746,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3,
      2,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      3,
      0,
      2.590832,
      NULL,
      3.062395,
      0,
      0,
      1,
      0.184660,
      NULL,
      1,
      0,
      0,
      0.234082,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      9,
      5.631263,
      NULL,
      3,
      8.148148,
      NULL,
      NULL,
      3,
      7,
      2,
      2.328080,
      1.425200,
      22,
      NULL,
      1.235152,
      62,
      NULL,
      NULL,
      NULL,
      3,
      0.849615,
      NULL,
      '03122',
      '34321',
      '',
      0.865729,
      '',
      '',
      '',
      NULL,
      '11011',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      1,
      10,
      7.481615,
      5,
      4,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      0.115191,
      NULL,
      NULL,
      0.896321,
      1,
      3.894851,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.528712,
      2.975159,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.267701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      0.737531,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.867822,
      NULL,
      NULL,
      NULL,
      2,
      1.851529,
      0,
      0,
      3.247625,
      0,
      NULL,
      0,
      NULL,
      1,
      1.670722,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      2.117866,
      NULL,
      NULL,
      3.443734,
      NULL,
      3.244322,
      1.069509,
      2,
      3,
      0,
      1.360821,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803905,
      1.891344,
      NULL,
      NULL,
      2,
      NULL,
      1.401740,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.681408,
      NULL,
      1,
      2,
      2,
      NULL,
      1.582432,
      NULL,
      NULL,
      2.156147,
      8.272566,
      5.993880,
      0,
      NULL,
      NULL,
      3.381579,
      3.739277,
      NULL,
      5.747273,
      1,
      3.151389,
      0.585200,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.079792,
      NULL,
      NULL,
      1.606881,
      NULL,
      NULL,
      1.020122,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.046139,
      NULL,
      1,
      0.974412,
      NULL,
      NULL,
      0.986412,
      6,
      4,
      NULL,
      7,
      5,
      3.978632,
      3.103897,
      1,
      2,
      NULL,
      0.476399,
      3,
      2,
      2,
      1.049485,
      1,
      1.430500,
      3.793399,
      9.713504,
      NULL,
      2,
      0.612323,
      2,
      1.144772,
      NULL,
      NULL,
      0.950280,
      NULL,
      NULL,
      1.150603,
      1.327681,
      1,
      5,
      5,
      4.481020,
      4.956584,
      NULL,
      NULL,
      3.445467,
      NULL,
      NULL,
      0,
      0,
      1,
      0.253259,
      0,
      3.366414,
      NULL,
      NULL,
      5.775277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033386,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.331435,
      NULL,
      NULL,
      5.451888,
      NULL,
      NULL,
      2.623315,
      1,
      0.335914,
      NULL,
      1,
      1.855525,
      3,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      0.471722,
      NULL,
      NULL,
      2.020460,
      0.636796,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.110072,
      1.084682,
      NULL,
      NULL,
      1,
      1.220062,
      NULL,
      NULL,
      2,
      3.830058,
      NULL,
      NULL,
      0.109904,
      NULL,
      NULL,
      NULL,
      2.257843,
      15.002977,
      NULL,
      NULL,
      0.619964,
      14,
      NULL,
      NULL,
      2,
      8.475892,
      NULL,
      NULL,
      NULL,
      6.384986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.432326,
      1,
      NULL,
      NULL,
      1.956136,
      0,
      NULL,
      NULL,
      1,
      3.789126,
      NULL,
      NULL,
      1.565243,
      0,
      NULL,
      NULL,
      1.736838,
      0,
      NULL,
      NULL,
      0,
      0.045523,
      NULL,
      NULL,
      4.018254,
      1.922030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.354031,
      3.428659,
      17,
      NULL,
      NULL,
      1.398185,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.300980,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275468,
      937,
      10,
      0,
      2.914357,
      1.374703,
      3,
      0,
      2,
      NULL,
      2,
      0,
      0.622271,
      1.630838,
      2.068904,
      NULL,
      2,
      0.903392,
      0.241834,
      1.784044,
      3,
      NULL,
      NULL,
      NULL,
      1.603550,
      NULL,
      1.260599,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      14,
      NULL,
      1,
      32.709756,
      25,
      3.935772,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.013623,
      NULL,
      NULL,
      NULL,
      1.253063,
      NULL,
      0.215613,
      NULL,
      1.388928,
      NULL,
      1.959685,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.855787,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.761069,
      NULL,
      1.134535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.017589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802731,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956918,
      1.519995,
      NULL,
      NULL,
      0.154110,
      0.764016,
      0.005041,
      0,
      0,
      1,
      0.712073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.210970,
      6.162661,
      1,
      NULL,
      9,
      2,
      2.576516,
      NULL,
      1.489490,
      1.665466,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1.648479,
      NULL,
      2,
      1,
      3,
      3,
      0.207779,
      1,
      0,
      1,
      2.130763,
      NULL,
      NULL,
      NULL,
      2.409340,
      NULL,
      0,
      1.047406,
      0.719046,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.784841,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.912616,
      NULL,
      0.128271,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.229494,
      NULL,
      2,
      NULL,
      1.816171,
      NULL,
      0,
      NULL,
      0.328483,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.423562,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.628590,
      NULL,
      1.991586,
      NULL,
      1.810320,
      NULL,
      2.249530,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.162077,
      NULL,
      1,
      NULL,
      1.139233,
      NULL,
      NULL,
      0.681301,
      1,
      NULL,
      0.408845,
      1,
      0,
      2,
      6,
      7,
      NULL,
      0,
      1,
      NULL,
      8,
      0,
      0,
      1.831429,
      '03430',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


