set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4005977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3001432',
      2,
      1,
      0,
      1,
      '0444',
      3.560634,
      1,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      0,
      1,
      0,
      ' 9-22-1983',
      63,
      0.180016,
      217.160193,
      164.517495,
      0,
      NULL,
      ' 3-28-1982',
      ' 8-15-1983',
      1.006652,
      0.971689,
      1,
      1.371961,
      0,
      3.226927,
      2,
      0,
      1.952545,
      266,
      7,
      10,
      NULL,
      3.011559,
      17,
      NULL,
      6,
      2,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      3.877578,
      NULL,
      1,
      0,
      0,
      4,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      8,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.262783,
      3,
      NULL,
      1,
      2,
      0.544575,
      1.214515,
      2,
      3.006637,
      3,
      0,
      NULL,
      1,
      3.667841,
      1.084455,
      NULL,
      1.618488,
      1,
      1,
      0,
      5.404400,
      1,
      2,
      3,
      1.031143,
      NULL,
      NULL,
      1.970962,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      2,
      4,
      0,
      1,
      1,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      5,
      0,
      1,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      5,
      1,
      NULL,
      2,
      5,
      5,
      1,
      4,
      0,
      4,
      1,
      1,
      3.638725,
      ' 1- 9-1985',
      1782,
      NULL,
      1600,
      1,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      1,
      1,
      1,
      4,
      1,
      0.652931,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      3,
      0,
      3,
      NULL,
      0.286702,
      1.845205,
      NULL,
      4.892562,
      2,
      0,
      0,
      3,
      0,
      NULL,
      0.082540,
      1.538900,
      7,
      5.364929,
      6,
      2.420198,
      4.239798,
      1.577671,
      NULL,
      NULL,
      1,
      NULL,
      0.833841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346974,
      1.561902,
      0.340844,
      1.657949,
      0.232572,
      0,
      NULL,
      99.432729,
      1.899758,
      3.353160,
      29.264823,
      306,
      NULL,
      0,
      1.930343,
      1.186123,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      3,
      3,
      0.234513,
      1.532584,
      1.344747,
      0.115198,
      0.678528,
      NULL,
      2,
      1,
      1.199878,
      0.735978,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      11,
      NULL,
      NULL,
      10,
      3,
      NULL,
      0,
      NULL,
      7,
      1,
      0,
      3.813551,
      20,
      2,
      NULL,
      NULL,
      40,
      NULL,
      3.148175,
      0,
      1.303918,
      NULL,
      '21310',
      '',
      '',
      1.122182,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      603,
      NULL,
      3,
      0.088860,
      13.233871,
      NULL,
      1,
      2,
      NULL,
      3.568828,
      1,
      NULL,
      NULL,
      2.405742,
      2.253352,
      0.505415,
      0.965766,
      NULL,
      NULL,
      0.628682,
      0.654631,
      NULL,
      1.053627,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      NULL,
      0.097011,
      0,
      NULL,
      NULL,
      1.204631,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.052000,
      NULL,
      NULL,
      1,
      7.498890,
      7,
      1,
      1.254410,
      NULL,
      NULL,
      NULL,
      0.212311,
      NULL,
      NULL,
      NULL,
      0.924595,
      0.423991,
      3,
      1,
      NULL,
      NULL,
      0.676688,
      NULL,
      NULL,
      NULL,
      0.136836,
      NULL,
      NULL,
      2.504549,
      1.808756,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      3,
      3.097681,
      1.635270,
      0,
      1.854241,
      NULL,
      NULL,
      0.413027,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.382739,
      2.855377,
      0.588592,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.771833,
      NULL,
      NULL,
      1.125642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.683156,
      NULL,
      NULL,
      3.617683,
      NULL,
      NULL,
      1,
      1,
      0,
      0.716521,
      0,
      NULL,
      3,
      0.533708,
      0,
      1.343307,
      NULL,
      NULL,
      0.120736,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.379930,
      NULL,
      NULL,
      2,
      1.335394,
      0,
      1,
      NULL,
      0,
      5.597552,
      NULL,
      1,
      7,
      1,
      4.260507,
      NULL,
      NULL,
      NULL,
      3.046717,
      1.970455,
      1,
      1,
      0.307680,
      1,
      1.685979,
      1,
      2.865610,
      NULL,
      3.038034,
      6.600148,
      NULL,
      NULL,
      2,
      3,
      0.266679,
      0,
      1,
      1.071882,
      3.035590,
      2,
      1,
      2,
      8,
      1,
      3,
      NULL,
      0.720411,
      4,
      NULL,
      2,
      1,
      0.793087,
      NULL,
      1,
      1,
      1.968872,
      3.962665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.117083,
      NULL,
      NULL,
      0.151824,
      NULL,
      NULL,
      1.781049,
      NULL,
      NULL,
      0.456628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.458682,
      NULL,
      NULL,
      1.590338,
      NULL,
      NULL,
      2,
      2,
      0.046803,
      1,
      0.147913,
      2.347302,
      1,
      NULL,
      NULL,
      8.287062,
      NULL,
      NULL,
      NULL,
      92.308244,
      NULL,
      NULL,
      NULL,
      2.782820,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.865902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155351,
      NULL,
      NULL,
      NULL,
      2.413203,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.650096,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.575490,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.137136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522946,
      NULL,
      NULL,
      NULL,
      1.027228,
      254.114376,
      287.158312,
      NULL,
      17,
      1,
      1.026583,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.062933,
      637,
      53.755288,
      NULL,
      1,
      NULL,
      1,
      0.817967,
      1,
      0.250730,
      0.180277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.734733,
      NULL,
      NULL,
      1.025959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      10.353677,
      NULL,
      0.439831,
      NULL,
      NULL,
      8.431389,
      3.611481,
      NULL,
      1,
      0.678722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.410145,
      0.213376,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696442,
      0.340698,
      NULL,
      0,
      0.476197,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.516965,
      NULL,
      NULL,
      1,
      0.345994,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.131298,
      NULL,
      0,
      NULL,
      0,
      0,
      6,
      NULL,
      1,
      NULL,
      NULL,
      13.032999,
      NULL,
      0.750265,
      NULL,
      '20300',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


