set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6015584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '3030122',
      3.997818,
      NULL,
      3,
      0,
      '3030',
      0.222846,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      3,
      1.695010,
      ' 2- 3-1976',
      33.199031,
      NULL,
      98,
      NULL,
      NULL,
      NULL,
      ' 9-27-1982',
      '11-23-2003',
      1.731680,
      1.504450,
      NULL,
      0.523397,
      1.354657,
      3.817173,
      0,
      0,
      0.524426,
      11.514202,
      1,
      NULL,
      15,
      96.296086,
      143.001445,
      1,
      18,
      NULL,
      1,
      0.221416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1,
      0,
      0,
      1,
      0,
      3.122151,
      1,
      1,
      2,
      1,
      0.976336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.803692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      0,
      5,
      0,
      0,
      0,
      0,
      0.866164,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      2,
      2,
      1,
      1,
      0,
      1,
      NULL,
      5,
      1,
      2,
      2,
      0,
      5,
      2,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2.843685,
      NULL,
      ' 4- 6-1990',
      NULL,
      ' 0-19-1993',
      162,
      0.242537,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.886343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236836,
      0,
      3.432935,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248810,
      0.951278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0.494499,
      0.268165,
      1,
      2.838326,
      NULL,
      2,
      0.131515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.483229,
      6,
      4.733173,
      9,
      3.955356,
      0.596745,
      1,
      2,
      5,
      NULL,
      NULL,
      1,
      35,
      0,
      3,
      NULL,
      11,
      39,
      10.490691,
      1,
      1,
      2.693836,
      '23020',
      '',
      NULL,
      0.715125,
      '',
      '',
      NULL,
      0.399611,
      '',
      '',
      '',
      0,
      49,
      NULL,
      1.888241,
      1.376395,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599125,
      NULL,
      NULL,
      1.543218,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.860024,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.335760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      6,
      5,
      1,
      0.851463,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.816437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.149308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.341339,
      NULL,
      3.359196,
      3,
      1,
      0,
      1.149172,
      NULL,
      NULL,
      6.290298,
      NULL,
      0.017077,
      0.458205,
      NULL,
      NULL,
      0.737113,
      NULL,
      NULL,
      1.845198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.702115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.716409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      2.474294,
      3,
      1,
      1.519445,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.277185,
      2,
      0,
      1.214281,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      3,
      3.591471,
      0.547772,
      0.018449,
      NULL,
      2,
      0,
      4.259442,
      9.457516,
      2.683015,
      1.447444,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      0,
      2.203819,
      NULL,
      NULL,
      0.686897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550866,
      NULL,
      NULL,
      0.460123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.535072,
      NULL,
      NULL,
      1.623825,
      NULL,
      NULL,
      1.001922,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.026254,
      0.951188,
      NULL,
      NULL,
      1.692281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.212485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729972,
      NULL,
      NULL,
      NULL,
      3.172300,
      NULL,
      NULL,
      NULL,
      1.007302,
      NULL,
      NULL,
      NULL,
      1.433021,
      NULL,
      NULL,
      1.296896,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.788450,
      NULL,
      NULL,
      0.848189,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7785.177069,
      1084,
      1.909227,
      NULL,
      1,
      0.171795,
      NULL,
      1.610078,
      0.909193,
      0,
      0,
      1,
      0,
      0,
      0.185193,
      1.147078,
      1.301972,
      1,
      NULL,
      1.948857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780308,
      3.297957,
      1,
      9.951638,
      18.249734,
      NULL,
      11,
      19,
      NULL,
      4,
      NULL,
      NULL,
      14,
      7.784464,
      NULL,
      11.319162,
      18.504688,
      NULL,
      NULL,
      19,
      NULL,
      1.929147,
      5.088847,
      NULL,
      10.685519,
      16.986183,
      NULL,
      5.084819,
      18.985832,
      NULL,
      NULL,
      2,
      NULL,
      14.784554,
      11.944368,
      NULL,
      NULL,
      1,
      0.415166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908400,
      NULL,
      NULL,
      NULL,
      0.390871,
      NULL,
      2,
      5,
      5,
      0,
      0,
      0.570569,
      71.198374,
      39.473908,
      3,
      1.495884,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


