set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '0243402',
      NULL,
      NULL,
      0,
      3,
      '0124',
      0,
      NULL,
      NULL,
      NULL,
      ' 5-14-1978',
      8.156345,
      NULL,
      6,
      1.439488,
      0.664693,
      ' 2- 4-1989',
      24.988229,
      NULL,
      NULL,
      NULL,
      1,
      ' 4-14-1997',
      ' 1-25-1985',
      ' 4-17-1989',
      1,
      NULL,
      3.932484,
      3,
      1,
      1.664937,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10.787125,
      NULL,
      15,
      NULL,
      2,
      19,
      NULL,
      5,
      7,
      NULL,
      NULL,
      1,
      1,
      1.038976,
      1,
      0.939082,
      1.044093,
      0.942326,
      0,
      0,
      NULL,
      5,
      2,
      1.640697,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.349667,
      0,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.683188,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0.722808,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      3,
      5,
      5,
      NULL,
      5,
      NULL,
      2,
      0,
      3,
      1,
      5,
      5,
      NULL,
      0,
      0,
      4,
      1,
      5,
      7.416144,
      1,
      NULL,
      601.094034,
      ' 0-11-1997',
      NULL,
      2,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1.661170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608233,
      0.680664,
      3.774352,
      1,
      1.790991,
      2.959449,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750011,
      2.797492,
      1.315856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547095,
      0.942643,
      1,
      1.533946,
      0,
      1,
      NULL,
      22.969997,
      0.495400,
      1.167137,
      NULL,
      NULL,
      NULL,
      1,
      0.112063,
      NULL,
      3,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      2,
      2,
      3,
      2.475423,
      3,
      2.206853,
      NULL,
      0.381049,
      0,
      1.356308,
      1,
      0.982541,
      0.841322,
      NULL,
      0.136620,
      1.348723,
      0,
      NULL,
      0,
      0.439598,
      3,
      1.003635,
      6,
      7.309957,
      7.626596,
      11.570502,
      3,
      1,
      NULL,
      0.547236,
      6,
      0,
      2,
      NULL,
      0.218689,
      0,
      0.724198,
      NULL,
      30,
      NULL,
      33.925294,
      2,
      NULL,
      1,
      '',
      '',
      '',
      3,
      '14300',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      9.722340,
      87.149171,
      9,
      0.954354,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.196173,
      3.259260,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.797185,
      NULL,
      NULL,
      0.831788,
      NULL,
      NULL,
      1.203718,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      4,
      0,
      0.160348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641087,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      3,
      NULL,
      3,
      1.937248,
      NULL,
      NULL,
      NULL,
      2.927860,
      0,
      5.183313,
      4.451516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318310,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      6,
      2.893363,
      NULL,
      6,
      5.674556,
      4,
      1,
      4.166084,
      1.581200,
      0,
      1,
      0,
      1.092222,
      1.591249,
      0.624184,
      2,
      3.205236,
      0.400035,
      7.786725,
      8.525664,
      0,
      0.521756,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.621905,
      3.131381,
      NULL,
      NULL,
      NULL,
      1.343575,
      9.244449,
      8,
      1.656774,
      5,
      NULL,
      3,
      NULL,
      0.070154,
      0.195520,
      1.623231,
      0,
      0.122282,
      3.091798,
      NULL,
      NULL,
      1.193232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154003,
      NULL,
      NULL,
      0.400397,
      NULL,
      NULL,
      1.018325,
      NULL,
      NULL,
      0.976262,
      NULL,
      NULL,
      1.018538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.555968,
      1,
      0,
      0,
      1,
      0.325882,
      NULL,
      NULL,
      3.031974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617346,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.691539,
      NULL,
      NULL,
      NULL,
      1.791428,
      NULL,
      NULL,
      NULL,
      0.713231,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.605920,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.859175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.990587,
      NULL,
      NULL,
      0,
      NULL,
      1.152666,
      0.057502,
      1,
      0.095983,
      0.287889,
      1.130114,
      0,
      1.935831,
      1,
      0,
      NULL,
      0.001431,
      1,
      0.626667,
      0.299396,
      1,
      0.374921,
      1.027374,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      4,
      5.152257,
      2.022582,
      NULL,
      0,
      10,
      0,
      3.838924,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895008,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.374902,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.213947,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2.520807,
      NULL,
      2,
      1.662169,
      0.197323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      3,
      4,
      1.246021,
      0,
      NULL,
      61,
      NULL,
      0,
      1,
      0,
      '',
      NULL,
      '',
      1,
      '21403',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


