set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      0,
      5,
      6.599400,
      6.083062,
      1.112824,
      0.334977,
      1,
      '234',
      '30240244',
      NULL,
      52.872213,
      '1330111',
      2.570459,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-1987',
      NULL,
      38.632998,
      NULL,
      0.614292,
      NULL,
      ' 6- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1- 8-1996',
      '10-27-1999',
      ' 0- 5-1984',
      3.901398,
      2,
      1,
      0.809771,
      1,
      0.018444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.613439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.590820,
      1,
      0.104970,
      NULL,
      1,
      0.677383,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      4,
      5,
      0,
      5,
      3,
      NULL,
      1,
      1,
      0,
      6,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.472174,
      3.463807,
      1,
      1,
      3,
      0,
      0.401104,
      1.803870,
      2,
      1.524490,
      0.323536,
      NULL,
      0.943673,
      1.141019,
      3.658333,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      2,
      0.215020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      4,
      1,
      0,
      NULL,
      NULL,
      5,
      1,
      5,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1.348755,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      3,
      1,
      4,
      2,
      2,
      NULL,
      3,
      0,
      5,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      4,
      NULL,
      3,
      1,
      0,
      3.890811,
      NULL,
      ' 5-16-2000',
      131.443449,
      ' 0-17-1985',
      7,
      1.443568,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      1,
      3.064973,
      NULL,
      1.408933,
      0,
      2.735726,
      NULL,
      1.827517,
      1,
      0,
      2,
      3.480160,
      NULL,
      NULL,
      NULL,
      NULL,
      2.756230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420471,
      5.375275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.251196,
      0,
      3.563342,
      1,
      NULL,
      1,
      1,
      16.592361,
      1.026468,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005634,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      0,
      0,
      3.500051,
      0.614735,
      1,
      NULL,
      NULL,
      0.744917,
      1.587267,
      3.739027,
      0.894168,
      1.013293,
      1,
      1,
      1,
      0,
      1,
      0.518201,
      1.216413,
      0,
      3,
      0.636022,
      1,
      5,
      6.451239,
      0,
      NULL,
      6,
      1.358298,
      3,
      NULL,
      29.074952,
      1,
      2.070921,
      8,
      NULL,
      23,
      0,
      NULL,
      3,
      1,
      '23042',
      '32030',
      NULL,
      1.178643,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      29,
      43.409133,
      1.186254,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.443038,
      0.784797,
      1,
      NULL,
      NULL,
      1.352874,
      NULL,
      NULL,
      1.552171,
      1.910498,
      0,
      1.218794,
      NULL,
      NULL,
      1.062587,
      NULL,
      NULL,
      2.944954,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103896,
      NULL,
      NULL,
      NULL,
      5.489453,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689780,
      NULL,
      NULL,
      NULL,
      1.916374,
      3.220417,
      0.187182,
      0,
      3,
      2,
      1.078836,
      NULL,
      NULL,
      1,
      NULL,
      1.342513,
      NULL,
      1.981631,
      NULL,
      1.543452,
      0.828435,
      0.730198,
      NULL,
      2.958886,
      NULL,
      0.080518,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.450882,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.878728,
      1.261606,
      1.304809,
      NULL,
      NULL,
      0.076646,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584581,
      NULL,
      NULL,
      2.325909,
      NULL,
      3.379058,
      NULL,
      NULL,
      NULL,
      0,
      4.334028,
      3,
      3.676517,
      NULL,
      5.981197,
      1,
      NULL,
      NULL,
      1,
      2.517671,
      0.798288,
      3.197442,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      5.056028,
      NULL,
      2.415021,
      2.897384,
      2,
      1.044322,
      1,
      0,
      0.081227,
      NULL,
      NULL,
      0.428356,
      2,
      NULL,
      NULL,
      6.737923,
      0.529587,
      4.257094,
      4,
      5,
      1.842199,
      NULL,
      NULL,
      NULL,
      1,
      0.712657,
      NULL,
      0,
      0.052762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.099898,
      0.179414,
      0.693582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945053,
      NULL,
      NULL,
      NULL,
      2.215790,
      NULL,
      NULL,
      0.416192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670817,
      0,
      1.692172,
      1.427447,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      70.409262,
      2.399519,
      0,
      1.566574,
      0.421405,
      0.741848,
      0.372209,
      NULL,
      0.885331,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1.250289,
      NULL,
      1.452259,
      0.440344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.253098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155880,
      0.736029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.346508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326494,
      1.089874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.091888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      24,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      7.310048,
      1.941594,
      3.139684,
      NULL,
      0,
      11,
      3,
      NULL,
      1.886741,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.836800,
      NULL,
      0,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      NULL,
      0.614009,
      0.721188,
      NULL,
      3.571983,
      NULL,
      NULL,
      0.249700,
      0.694741,
      NULL,
      2,
      1.049375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749934,
      NULL,
      NULL,
      NULL,
      1.436521,
      NULL,
      0,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      4,
      '10310',
      '23142',
      '',
      1,
      '',
      '',
      NULL,
      0.968280,
      '',
      '',
      NULL);
commit;
end;
/


