set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1983-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3421131',
      3,
      0,
      2,
      1,
      '1431',
      2.499258,
      1.881668,
      NULL,
      NULL,
      ' 8-12-1991',
      NULL,
      NULL,
      NULL,
      2.637991,
      NULL,
      '10-15-1998',
      NULL,
      0,
      180.713258,
      17,
      0,
      ' 9-21-1974',
      ' 9- 4-1994',
      NULL,
      3.706439,
      NULL,
      0.957555,
      2.113600,
      1,
      3,
      0,
      NULL,
      0,
      3.435800,
      3,
      1.323479,
      NULL,
      43.952812,
      25.326872,
      5,
      9,
      0,
      NULL,
      5,
      NULL,
      3,
      1,
      1.110210,
      1,
      NULL,
      1.371514,
      2,
      0.758262,
      1.971723,
      NULL,
      3,
      4,
      5,
      NULL,
      NULL,
      0,
      NULL,
      0,
      5,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      4,
      1,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      1,
      0.850759,
      3,
      0.146483,
      0.067641,
      1.532814,
      NULL,
      2.282958,
      1,
      0,
      0.735199,
      NULL,
      1.902797,
      NULL,
      0,
      1,
      3,
      5.545779,
      1,
      NULL,
      1,
      0.372625,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      4,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.169732,
      NULL,
      NULL,
      1,
      5,
      1,
      1,
      1,
      NULL,
      3,
      3,
      2,
      1,
      NULL,
      0,
      0,
      2,
      3,
      4,
      1,
      NULL,
      0,
      3,
      0,
      5,
      0,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      319.231629,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.696440,
      0,
      5,
      1,
      3.339333,
      1,
      1.235527,
      NULL,
      NULL,
      NULL,
      0.837257,
      NULL,
      0.352408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.230656,
      1.192357,
      NULL,
      3,
      1,
      1.413304,
      3.267601,
      16.915667,
      3.220489,
      1.510167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      2.157332,
      NULL,
      80,
      30,
      NULL,
      5,
      1,
      0,
      '23100',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      37.319438,
      49.036332,
      7,
      0,
      32.876650,
      2,
      3,
      NULL,
      1.512559,
      NULL,
      NULL,
      1.225028,
      NULL,
      NULL,
      1,
      0.659617,
      1.414593,
      3,
      2,
      1.997968,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      0.248075,
      1.842749,
      0,
      NULL,
      NULL,
      0.132913,
      NULL,
      NULL,
      0.307008,
      NULL,
      NULL,
      1.287965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662105,
      10,
      0.265068,
      2,
      1.810308,
      NULL,
      NULL,
      NULL,
      0.500957,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304662,
      1.216952,
      2.436301,
      3.945697,
      0,
      0,
      NULL,
      NULL,
      1.773478,
      NULL,
      1,
      3,
      0,
      0,
      3,
      NULL,
      1.059892,
      3.629110,
      0.919133,
      1,
      1.799601,
      0,
      0.022847,
      1,
      1.619460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      11,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.219600,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.264349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      4.370562,
      1,
      0,
      0.427246,
      0.543049,
      1.581149,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.328540,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      2.108824,
      8,
      0,
      NULL,
      3.214020,
      3,
      1.681265,
      NULL,
      NULL,
      5.891742,
      7,
      2,
      3.818588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      0.731208,
      3.311979,
      1,
      1.212078,
      0,
      2.818395,
      NULL,
      7,
      10.202247,
      4.090533,
      3.579382,
      3,
      NULL,
      NULL,
      0,
      3.937991,
      1,
      0.717648,
      0.685118,
      1.179745,
      0.927605,
      1,
      0.352828,
      3,
      3,
      2,
      2,
      NULL,
      NULL,
      3,
      2,
      0.047162,
      0.864866,
      NULL,
      0.947278,
      0,
      3.029630,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.595092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.127168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.931691,
      1.983094,
      3,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.473851,
      NULL,
      NULL,
      0.505990,
      NULL,
      NULL,
      NULL,
      3.641988,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.755724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.533940,
      NULL,
      NULL,
      NULL,
      2,
      0.379179,
      NULL,
      NULL,
      1,
      1.258625,
      NULL,
      NULL,
      3.701656,
      NULL,
      NULL,
      NULL,
      1.790774,
      1,
      NULL,
      NULL,
      0.737553,
      1,
      NULL,
      NULL,
      0.268964,
      0.676283,
      NULL,
      NULL,
      1.166364,
      1.059541,
      NULL,
      NULL,
      NULL,
      2.321249,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.323040,
      23.369459,
      96.865294,
      1,
      NULL,
      NULL,
      0.379729,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      14,
      8.981198,
      0,
      NULL,
      NULL,
      2.978248,
      14,
      0,
      18272.628323,
      NULL,
      1.949098,
      1.622632,
      0,
      1.950122,
      0.162652,
      0,
      1.660532,
      0.983876,
      NULL,
      1.548788,
      0,
      NULL,
      0,
      0.380102,
      1.917217,
      1.659174,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.385232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780855,
      2,
      NULL,
      1.690512,
      NULL,
      1.461065,
      NULL,
      NULL,
      NULL,
      1.543282,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.557112,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.979678,
      1.153041,
      1.494711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      47.225137,
      3,
      NULL,
      0,
      '33121',
      '',
      NULL,
      0.237820,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


