set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      '3024',
      1,
      1,
      NULL,
      NULL,
      ' 0-20-1975',
      38.348399,
      NULL,
      0,
      0.734597,
      2.809119,
      NULL,
      35,
      0,
      2.717344,
      140.579982,
      1,
      '10-12-1988',
      ' 9-13-1984',
      ' 6-23-1987',
      0,
      0.135053,
      3,
      1.358332,
      0.889373,
      3.958456,
      2,
      0.341470,
      1.442042,
      20,
      7,
      1,
      1,
      24.519756,
      17.215821,
      1,
      10,
      NULL,
      2,
      8.060664,
      0.226021,
      3,
      0,
      NULL,
      0.473670,
      1.145809,
      0.978709,
      1,
      0.761673,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.884138,
      NULL,
      NULL,
      0.456804,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.154321,
      0.029390,
      1.629153,
      2,
      3,
      0,
      0.052539,
      1,
      2,
      0,
      0.099800,
      0.155877,
      0.120360,
      1,
      1.379618,
      0,
      1,
      0,
      1,
      8.022246,
      0,
      NULL,
      1,
      0.772763,
      NULL,
      NULL,
      0.179917,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3,
      4,
      3,
      1,
      2,
      1,
      NULL,
      0,
      1,
      3.937665,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.940041,
      0,
      0,
      1,
      1,
      0,
      0,
      4,
      0,
      0,
      1,
      NULL,
      1,
      4,
      1,
      NULL,
      3,
      0,
      4,
      2,
      1,
      3,
      5,
      5,
      0,
      3,
      0.186214,
      2,
      ' 0-19-1993',
      86.354412,
      ' 1-16-1978',
      2.633495,
      0.149012,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0.005440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.702366,
      NULL,
      0,
      3,
      5.103939,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.293636,
      4,
      NULL,
      3,
      3.220132,
      4,
      1.044914,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.813119,
      0.018882,
      1,
      NULL,
      3,
      13.748333,
      1.573801,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.834071,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.091866,
      2,
      1.354195,
      1,
      NULL,
      1.767552,
      NULL,
      0,
      1.207419,
      1.551668,
      0,
      2,
      1,
      0.080132,
      2.690017,
      11,
      5,
      7,
      9.848869,
      1.130315,
      2,
      3.136613,
      7,
      0,
      3.632234,
      2.220472,
      25.446148,
      0,
      3,
      NULL,
      19,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '30213',
      '',
      NULL,
      1.220285,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      0.136725,
      34.938695,
      NULL,
      NULL,
      2,
      19,
      NULL,
      27.716175,
      4,
      2,
      NULL,
      1.594334,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.710971,
      0.217373,
      0,
      NULL,
      NULL,
      2,
      0,
      1.301270,
      1.702481,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.779646,
      4.501185,
      0.647316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812195,
      2.296831,
      2,
      3,
      0,
      0,
      0,
      3,
      2,
      1,
      3.867834,
      3,
      3.917128,
      3,
      1,
      1.216198,
      NULL,
      NULL,
      0,
      1.468257,
      0.597914,
      2.710323,
      NULL,
      0,
      1.915454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.748334,
      1.972264,
      6.846375,
      10.278905,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.439781,
      1.817845,
      NULL,
      NULL,
      0.292635,
      1.512728,
      0.366018,
      NULL,
      NULL,
      3.305829,
      3,
      0,
      1.038856,
      3.328466,
      0,
      1.066733,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.331509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870557,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.538658,
      NULL,
      NULL,
      3.170821,
      NULL,
      NULL,
      0,
      4,
      3,
      3.688777,
      NULL,
      NULL,
      0.398682,
      0,
      1.682754,
      3,
      1.011199,
      0.499705,
      1,
      1.679649,
      NULL,
      3,
      3,
      0,
      9.328229,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      2.891838,
      3,
      3,
      NULL,
      4,
      3,
      NULL,
      0.917683,
      NULL,
      0,
      NULL,
      NULL,
      1.653956,
      1.734739,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.277655,
      NULL,
      NULL,
      0.261687,
      NULL,
      NULL,
      1.425836,
      NULL,
      NULL,
      1.524698,
      NULL,
      NULL,
      3.645792,
      NULL,
      NULL,
      0,
      2.780947,
      2,
      0,
      1.606063,
      3.740063,
      2.594868,
      0,
      NULL,
      5.669094,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.498255,
      1.789948,
      NULL,
      0.252459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993436,
      NULL,
      0.113567,
      1.052694,
      3,
      NULL,
      1.223928,
      NULL,
      NULL,
      NULL,
      1.077767,
      1.365330,
      NULL,
      NULL,
      NULL,
      0,
      0.271185,
      NULL,
      1.256632,
      1.794066,
      1.718864,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.288128,
      3,
      NULL,
      1,
      0,
      0.726003,
      NULL,
      0,
      2.099825,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      10,
      NULL,
      3.300369,
      NULL,
      NULL,
      1.957902,
      7,
      0,
      0.605643,
      5.402548,
      NULL,
      0.700744,
      20.836690,
      3.576562,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1.922510,
      1.126541,
      7,
      3,
      1.835238,
      NULL,
      NULL,
      1,
      3.552781,
      1.683506,
      NULL,
      5.620184,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.396041,
      0,
      1,
      0.034991,
      0.547276,
      NULL,
      1.233283,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.188477,
      0.671294,
      NULL,
      NULL,
      1.120665,
      3.121359,
      1.327720,
      NULL,
      1,
      1,
      1,
      1.271213,
      0.138199,
      NULL,
      0.088139,
      0,
      0.071232,
      0.766467,
      1,
      1,
      0.396339,
      1,
      1,
      NULL,
      0,
      3.929879,
      0,
      1.477830,
      2,
      0.982549,
      NULL,
      3.767313,
      0.254226,
      0,
      1.380235,
      1.501009,
      0,
      2,
      0,
      0,
      3.640379,
      2,
      3.224930,
      1.600129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143022,
      NULL,
      0,
      NULL,
      0.887340,
      1,
      0,
      1,
      5,
      1.062611,
      NULL,
      NULL,
      65,
      71,
      NULL,
      NULL,
      0,
      NULL,
      '14211',
      '',
      0.756985,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


