set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      2.749712,
      NULL,
      NULL,
      2,
      3,
      0.719548,
      2.082236,
      '102',
      NULL,
      58.522619,
      35,
      NULL,
      1.632842,
      NULL,
      4,
      3,
      NULL,
      2,
      1.181985,
      NULL,
      NULL,
      ' 2-12-1992',
      3,
      9.117803,
      NULL,
      0.347472,
      1.935706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 0-14-1986',
      ' 7- 3-1989',
      0,
      1.199889,
      2.342792,
      3.759328,
      1,
      1.312468,
      NULL,
      2.683812,
      NULL,
      NULL,
      NULL,
      8.497305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.447368,
      0,
      NULL,
      0.255453,
      1.318194,
      1,
      0.349093,
      5,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      4,
      NULL,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      0.338331,
      1.205923,
      0.326798,
      1,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      3,
      1,
      NULL,
      3,
      9,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.714137,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.377788,
      1,
      NULL,
      0,
      0,
      1.619787,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      5,
      0,
      1,
      4,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      4,
      1,
      3,
      NULL,
      NULL,
      1.372451,
      2,
      ' 9-26-2002',
      114,
      NULL,
      4.592321,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      1.547418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.996302,
      3.212629,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846761,
      0,
      1,
      6.301430,
      3.370261,
      0.314432,
      NULL,
      NULL,
      0,
      4.332555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.401220,
      1,
      1.790759,
      3,
      30,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      1,
      2,
      2,
      1,
      3,
      0,
      0,
      2,
      2,
      2.481815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.672124,
      1,
      0.925700,
      0.542758,
      0.961818,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      27,
      3,
      NULL,
      NULL,
      0.223138,
      '12020',
      '',
      NULL,
      1.625468,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      0,
      30.977921,
      13.800489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020529,
      3.859470,
      1,
      1.430150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.512518,
      NULL,
      3.247442,
      3,
      1,
      2,
      1.945392,
      NULL,
      NULL,
      1,
      3.921734,
      0.213583,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.676053,
      1.699856,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.773472,
      NULL,
      NULL,
      NULL,
      3.664649,
      NULL,
      3,
      0.759818,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.561610,
      1.442219,
      NULL,
      0.483285,
      1,
      2,
      0.948326,
      1,
      1.099382,
      0.932543,
      0.389727,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.693818,
      3.092597,
      0,
      NULL,
      NULL,
      2.371317,
      NULL,
      1,
      4,
      0.985675,
      4.794050,
      0,
      1.310428,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.876092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.076645,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      2,
      4.276377,
      1,
      NULL,
      NULL,
      0.528127,
      NULL,
      NULL,
      0.302636,
      NULL,
      NULL,
      0.351484,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447365,
      NULL,
      NULL,
      1.221053,
      NULL,
      NULL,
      1.353831,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2.154447,
      5,
      NULL,
      NULL,
      2,
      2,
      0.203745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.331036,
      NULL,
      0,
      2.926222,
      2,
      NULL,
      5,
      4,
      3.170444,
      2,
      NULL,
      2,
      NULL,
      3.390534,
      2,
      NULL,
      3.334575,
      1.153985,
      1.029239,
      0.888252,
      2,
      1.105837,
      NULL,
      NULL,
      NULL,
      1,
      1.573267,
      1,
      NULL,
      NULL,
      1.440667,
      1,
      1.483959,
      0,
      0.398129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654254,
      0.246022,
      0,
      0,
      0.421017,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.791717,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.899221,
      NULL,
      0,
      0.132572,
      1.860872,
      0,
      NULL,
      1.652020,
      0,
      0,
      0,
      0.293551,
      0,
      0,
      NULL,
      1.606800,
      1.805655,
      1.962320,
      1,
      NULL,
      0.904595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13,
      4,
      5,
      2.813227,
      0,
      NULL,
      NULL,
      0.971539,
      0,
      0,
      0.032541,
      NULL,
      1,
      3.029681,
      NULL,
      2.988695,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.518892,
      3.621965,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.037833,
      NULL,
      3.632954,
      0,
      NULL,
      1,
      0.739523,
      NULL,
      0.418816,
      0.126194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      4,
      5,
      1.424904,
      NULL,
      NULL,
      59.071408,
      49,
      NULL,
      NULL,
      0,
      '34024',
      '',
      '',
      1.094928,
      '',
      NULL,
      '',
      0.457416,
      '',
      NULL,
      '');
commit;
end;
/


