set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7618530';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1101021',
      1,
      0.523772,
      2,
      NULL,
      '2202',
      0,
      1,
      NULL,
      NULL,
      ' 1-17-1991',
      NULL,
      NULL,
      4,
      0.119623,
      1,
      NULL,
      20,
      NULL,
      26.013270,
      10.543032,
      1,
      ' 4-21-1988',
      NULL,
      ' 9-21-1983',
      1.606066,
      3.343448,
      0,
      1,
      1,
      NULL,
      3,
      1,
      1.353299,
      1,
      2,
      6.886434,
      3.004172,
      23.558745,
      7.797215,
      1,
      8,
      NULL,
      2,
      4.495383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.524988,
      2,
      0,
      3,
      1,
      1,
      1,
      2,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.742874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      3,
      0,
      1,
      1,
      1,
      2.800682,
      1,
      0,
      1,
      1,
      0.357602,
      NULL,
      NULL,
      2,
      4,
      1,
      1,
      0,
      4,
      NULL,
      5,
      0,
      5,
      3,
      3,
      3,
      1,
      NULL,
      4,
      5,
      5,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      5,
      NULL,
      ' 3-21-1987',
      333.265335,
      ' 3- 8-1996',
      300.618412,
      3.459333,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      0,
      0,
      2.482600,
      NULL,
      3.062849,
      3.798288,
      0.181635,
      5,
      1.979786,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597142,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.017787,
      1.032436,
      2.963302,
      0,
      0.038573,
      0.137525,
      3.270339,
      36.231059,
      3,
      1.220202,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867329,
      1.768682,
      0,
      2,
      1,
      3,
      0,
      0,
      1,
      3,
      NULL,
      2,
      1.399516,
      2.745974,
      1.971500,
      3.755154,
      0.409888,
      NULL,
      3,
      1,
      1.579384,
      1,
      NULL,
      1.757893,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.672456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      43.072707,
      NULL,
      0.505932,
      3,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1.574203,
      46,
      85.447174,
      20.000251,
      1.085256,
      39,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.646686,
      NULL,
      NULL,
      1.553388,
      NULL,
      NULL,
      3,
      3.951936,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003984,
      NULL,
      NULL,
      1.276539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.398191,
      2.463314,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.033214,
      NULL,
      NULL,
      NULL,
      1.845966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.961665,
      1,
      NULL,
      0,
      1,
      0,
      7,
      7,
      2,
      1.869303,
      1,
      0.797008,
      1.433348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605274,
      NULL,
      NULL,
      1.697501,
      NULL,
      NULL,
      0.783754,
      NULL,
      NULL,
      0.377511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.086504,
      3,
      0.165599,
      NULL,
      NULL,
      2,
      0.319010,
      3,
      1.152223,
      0,
      0,
      5.263534,
      5.687001,
      2.986983,
      1.133179,
      0.750063,
      3,
      0.099722,
      1.432119,
      0,
      2,
      0.739471,
      1,
      6.895894,
      6,
      1,
      3,
      3.544202,
      NULL,
      1.622857,
      NULL,
      3.954071,
      2,
      2.529049,
      NULL,
      0.174599,
      NULL,
      1.808284,
      7,
      6,
      1.683247,
      0.943395,
      1.453124,
      1,
      0.554583,
      0,
      4,
      0,
      0.317145,
      NULL,
      1.494236,
      1.386363,
      NULL,
      NULL,
      NULL,
      1.620119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.668850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935866,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.156985,
      0.526158,
      NULL,
      1.285296,
      0,
      1.801290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.487637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710033,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.311785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      0,
      NULL,
      1.222604,
      NULL,
      NULL,
      NULL,
      0.781075,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      115.184120,
      1369,
      0,
      0,
      1.446591,
      NULL,
      1,
      0.755696,
      0,
      0,
      1.539879,
      0.806432,
      NULL,
      0.451511,
      0,
      1,
      NULL,
      0,
      0,
      1.813839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.344554,
      0,
      0,
      NULL,
      3,
      1.774001,
      0,
      3.149917,
      1.526242,
      0,
      NULL,
      NULL,
      1.627516,
      0.279520,
      NULL,
      NULL,
      2,
      NULL,
      0.931884,
      1.776466,
      NULL,
      0.047114,
      0.954861,
      NULL,
      1.198121,
      0.256712,
      NULL,
      0,
      0.172915,
      NULL,
      2.318805,
      2.526001,
      NULL,
      1.008219,
      1,
      NULL,
      2,
      2.819298,
      NULL,
      NULL,
      3.938176,
      NULL,
      3.327226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841281,
      NULL,
      0.915983,
      NULL,
      0.024386,
      NULL,
      4,
      5,
      0,
      1.528411,
      0,
      3.735190,
      14,
      70,
      NULL,
      NULL,
      1,
      '03300',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


