set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.256402,
      NULL,
      2,
      0.550726,
      1,
      0,
      2.622716,
      '204',
      '10421412',
      NULL,
      24.429588,
      NULL,
      1,
      0.998667,
      3,
      3,
      '0244',
      5,
      0.562657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1976',
      NULL,
      1.469080,
      0.585069,
      2,
      1,
      3.948306,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.737255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      3,
      0,
      NULL,
      0,
      4,
      1,
      3,
      1,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.428475,
      NULL,
      NULL,
      4,
      NULL,
      5,
      NULL,
      0,
      1.490031,
      3,
      3,
      3.710534,
      0,
      3,
      1.320325,
      NULL,
      2.723236,
      2,
      3.523183,
      3.049944,
      2.883543,
      3,
      1,
      0,
      0,
      1.618092,
      NULL,
      1,
      NULL,
      0.478416,
      NULL,
      NULL,
      1.203313,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      3,
      1,
      4,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      3.512576,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.796570,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      3,
      0,
      NULL,
      4,
      2,
      0,
      1,
      5,
      3,
      4,
      0,
      2,
      NULL,
      4,
      2,
      0,
      4,
      4.436253,
      1.453124,
      ' 9-19-1979',
      NULL,
      ' 5- 2-1986',
      10,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      2,
      1.618936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.236865,
      NULL,
      0,
      1,
      3,
      1.758146,
      1,
      1,
      3,
      1.826497,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      5.149548,
      0.832391,
      NULL,
      2.129002,
      NULL,
      NULL,
      NULL,
      1.437403,
      1,
      0.339106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.764113,
      0.566641,
      1.626776,
      1,
      0.062470,
      0.692286,
      NULL,
      NULL,
      2.529629,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.268375,
      0,
      NULL,
      1,
      3,
      NULL,
      3,
      2,
      0,
      0,
      2,
      NULL,
      0.974865,
      NULL,
      1.346285,
      0.321982,
      1.252395,
      0.177545,
      NULL,
      1.786817,
      0.157309,
      0.592303,
      1,
      1.762793,
      1,
      NULL,
      0,
      NULL,
      3.496703,
      0.671551,
      4.103732,
      NULL,
      1,
      6,
      7,
      1,
      5.430696,
      3,
      NULL,
      1,
      2.476866,
      3,
      15.385565,
      0,
      1.883061,
      30,
      NULL,
      NULL,
      NULL,
      5,
      5.428326,
      1,
      NULL,
      '',
      '',
      0.683652,
      '',
      NULL,
      '',
      1.187644,
      '',
      '',
      NULL,
      NULL,
      8,
      5.555464,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.836437,
      1,
      1.957244,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.330590,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.242095,
      0.275784,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.326084,
      NULL,
      NULL,
      1.906247,
      NULL,
      NULL,
      0.157643,
      NULL,
      NULL,
      1.188605,
      1,
      NULL,
      0,
      0.817738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079495,
      3,
      1,
      2.596661,
      0,
      2,
      0,
      1,
      0,
      NULL,
      0,
      3,
      1,
      0,
      3,
      1.719069,
      NULL,
      1,
      0.621646,
      0.516094,
      1.499959,
      0.336663,
      3,
      0.867280,
      2.649823,
      1.425408,
      0,
      NULL,
      NULL,
      NULL,
      1.021333,
      NULL,
      NULL,
      0,
      3.169172,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.126466,
      NULL,
      NULL,
      NULL,
      2.526764,
      2.729549,
      0.329568,
      3.713468,
      1.777250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.753905,
      0.583210,
      1.191477,
      0,
      NULL,
      NULL,
      3.971446,
      NULL,
      1.275239,
      0,
      NULL,
      NULL,
      0.411862,
      NULL,
      NULL,
      0.514446,
      NULL,
      NULL,
      0.144022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.395048,
      NULL,
      NULL,
      1.068187,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.429761,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.342560,
      0.931591,
      1.410195,
      6.247355,
      4.088075,
      0,
      1.223159,
      0.584495,
      1.448799,
      3.012012,
      3,
      1,
      2,
      3,
      0,
      1,
      3.981609,
      1.798114,
      2,
      1,
      1.309725,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747960,
      1.349896,
      0,
      0.214525,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473607,
      NULL,
      NULL,
      0.827199,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.566213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.570695,
      NULL,
      NULL,
      1,
      3,
      1.845971,
      NULL,
      1.304023,
      0.433331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      3.267346,
      NULL,
      NULL,
      NULL,
      0.771368,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456876,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.570495,
      NULL,
      NULL,
      NULL,
      3.190888,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.368853,
      NULL,
      NULL,
      NULL,
      2.991680,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.052841,
      NULL,
      NULL,
      NULL,
      1.754134,
      NULL,
      NULL,
      3,
      0.168572,
      0.671771,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403139,
      NULL,
      1,
      0.628841,
      1,
      1,
      0.047629,
      0,
      NULL,
      1.021939,
      0.917146,
      1,
      1,
      NULL,
      0.808707,
      1,
      0,
      1.993678,
      0.947059,
      1.019946,
      0,
      0.783640,
      1.339244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      5.122501,
      2.577494,
      1.374864,
      1.541311,
      2,
      9.262279,
      1,
      1,
      0.541995,
      0.172559,
      0,
      1,
      0.125152,
      0.086824,
      NULL,
      1.514593,
      1.425225,
      NULL,
      NULL,
      2.577505,
      NULL,
      0,
      2.862369,
      1,
      0,
      1,
      1.465213,
      1.708872,
      1.973366,
      NULL,
      1,
      1.459296,
      0,
      0.390818,
      NULL,
      0.144906,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.959131,
      0,
      3.374562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.947552,
      1,
      1.742587,
      NULL,
      0,
      2,
      NULL,
      1.620290,
      NULL,
      NULL,
      50.965323,
      50.230262,
      1,
      5,
      NULL,
      '34303',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


