set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      NULL,
      0.768740,
      3.402900,
      0,
      2,
      1.743185,
      '241',
      NULL,
      NULL,
      42.984690,
      NULL,
      NULL,
      1.304330,
      3,
      3,
      '4114',
      NULL,
      0,
      NULL,
      NULL,
      '10-23-1987',
      115.428760,
      174.720843,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 6-15-1980',
      3,
      1,
      0.962860,
      1.863307,
      1,
      1.428466,
      0,
      NULL,
      0,
      NULL,
      3,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      1.767004,
      1.600487,
      0.896464,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      4,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      3,
      1,
      5.072055,
      2,
      0,
      0,
      NULL,
      0.066695,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      4.902242,
      3,
      1,
      NULL,
      1.681826,
      NULL,
      NULL,
      0.468048,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.319089,
      0,
      3,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      1,
      3,
      1,
      1,
      5,
      0,
      NULL,
      4,
      0,
      NULL,
      0,
      1,
      5,
      1,
      5,
      0,
      5,
      NULL,
      1.905487,
      ' 8-16-2000',
      NULL,
      NULL,
      NULL,
      0.694230,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      4,
      2,
      0.078773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      3.426423,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334778,
      NULL,
      0,
      4,
      1,
      5.576479,
      NULL,
      1,
      NULL,
      NULL,
      0.473068,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493935,
      NULL,
      0.439001,
      2.208146,
      0,
      0.213878,
      NULL,
      NULL,
      NULL,
      1.376099,
      0.165077,
      NULL,
      NULL,
      NULL,
      0,
      0.488500,
      NULL,
      1,
      0,
      2,
      0,
      2,
      0,
      1,
      2,
      2,
      3,
      0,
      5.041283,
      0.391974,
      0.089720,
      1,
      0.829912,
      2,
      0,
      0,
      1,
      0,
      0.317060,
      0,
      1.873621,
      0,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      4.991005,
      0,
      5,
      4.577703,
      NULL,
      NULL,
      3.191665,
      2,
      2,
      0.437245,
      16.775847,
      1,
      0.517295,
      32,
      NULL,
      NULL,
      NULL,
      5,
      3.073437,
      2.262418,
      '2044',
      '13321',
      NULL,
      0,
      NULL,
      '',
      '',
      1.443936,
      '',
      '',
      NULL,
      3,
      37,
      13,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378220,
      1.152488,
      3.117566,
      NULL,
      NULL,
      NULL,
      1.627174,
      NULL,
      NULL,
      3,
      2,
      2.148279,
      0,
      1,
      1.956051,
      NULL,
      NULL,
      NULL,
      1.127160,
      2.227029,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.171395,
      1.049990,
      NULL,
      NULL,
      0,
      0.255450,
      1.246843,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.863585,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.101612,
      NULL,
      NULL,
      1.554277,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.398535,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475375,
      NULL,
      NULL,
      0.887875,
      NULL,
      NULL,
      NULL,
      1.023213,
      1.505392,
      1.245736,
      1.435047,
      0.526842,
      3,
      NULL,
      0.157667,
      1.997885,
      NULL,
      NULL,
      0,
      3.909767,
      3.592229,
      0.461407,
      2.182624,
      2.537258,
      NULL,
      2.306471,
      1.683448,
      9,
      2,
      3.397350,
      2,
      2.761670,
      NULL,
      1.580511,
      1,
      NULL,
      3,
      0.548907,
      0,
      0,
      1,
      0,
      2,
      6.518295,
      NULL,
      3.864102,
      NULL,
      NULL,
      0.796513,
      3,
      NULL,
      1,
      1,
      0.484574,
      1.143264,
      0,
      2.045738,
      NULL,
      NULL,
      1.854916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.021903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.140597,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.180509,
      0.086173,
      0.548680,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.586927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.072124,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884470,
      2.245281,
      1.601068,
      1.631555,
      1.923500,
      NULL,
      NULL,
      3,
      NULL,
      0.251332,
      1.871454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      281.153707,
      NULL,
      0.692719,
      0,
      0,
      NULL,
      0.190995,
      0.008654,
      1.136821,
      1,
      1.703137,
      0,
      0,
      1.973213,
      1,
      NULL,
      NULL,
      1,
      1,
      1.109461,
      NULL,
      1.341340,
      NULL,
      2,
      NULL,
      1.654365,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8.752849,
      NULL,
      NULL,
      14.806082,
      21,
      3.325797,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120283,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.621273,
      NULL,
      0.552054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590180,
      NULL,
      NULL,
      NULL,
      1.829968,
      1.056897,
      1.419381,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513558,
      0.369112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.039136,
      NULL,
      2.331179,
      NULL,
      0.833109,
      NULL,
      0,
      NULL,
      2.439656,
      NULL,
      0.715541,
      NULL,
      1,
      NULL,
      0.171414,
      NULL,
      NULL,
      0.553350,
      1.331922,
      NULL,
      3.230852,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.042211,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333678,
      0.145897,
      0,
      NULL,
      1.800184,
      NULL,
      NULL,
      NULL,
      1.260511,
      NULL,
      1.707611,
      NULL,
      0,
      NULL,
      3,
      NULL,
      74.067051,
      NULL,
      2.111891,
      NULL,
      2,
      NULL,
      0.348777,
      NULL,
      0,
      1,
      10,
      NULL,
      NULL,
      1.179728,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.638847,
      3.288088,
      0.440067,
      3,
      0,
      3.050307,
      3.605656,
      1.223588,
      2.444272,
      2.775598,
      NULL,
      2,
      3.879181,
      NULL,
      3,
      3.402599,
      NULL,
      1.645969,
      0,
      NULL,
      1.614819,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.248420,
      NULL,
      0.156011,
      1.576641,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.835741,
      1.201848,
      NULL,
      NULL,
      1.199748,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401957,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.986331,
      NULL,
      NULL,
      23,
      49,
      5,
      5.345511,
      2.504395,
      '1303',
      '04020',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


