set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      '13',
      1.828099,
      10,
      '0103204',
      3.149981,
      1,
      0,
      2,
      '4202',
      0,
      0.981977,
      NULL,
      NULL,
      ' 5-28-1991',
      27,
      31,
      NULL,
      2,
      0.258175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1978',
      ' 2- 9-1994',
      ' 1- 6-2001',
      3,
      1.010719,
      1,
      0.104600,
      1.474296,
      NULL,
      4,
      1,
      1,
      34,
      0,
      17,
      0.204601,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.191538,
      NULL,
      1,
      1,
      2,
      1,
      0,
      0,
      0,
      3,
      NULL,
      1,
      0,
      0,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.966754,
      NULL,
      NULL,
      2.695598,
      0.637983,
      1.779496,
      0.821038,
      1,
      NULL,
      NULL,
      NULL,
      2.415527,
      0,
      1.868238,
      1,
      1,
      1,
      0,
      1.590244,
      0,
      1,
      2,
      1.562153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      3,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1.612849,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      3,
      5,
      5,
      5,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      '11- 5-2002',
      146.054274,
      NULL,
      42,
      1.655033,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.530318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.664731,
      1.929698,
      1,
      0,
      0,
      NULL,
      0.933555,
      1,
      3.982372,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.773773,
      0.117739,
      8,
      2,
      7.593364,
      1,
      1.981743,
      NULL,
      NULL,
      NULL,
      1.553000,
      9,
      1.635659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.308934,
      0,
      0,
      0,
      0,
      0,
      0,
      0.825028,
      1,
      2.899635,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.653288,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      3,
      0.813217,
      NULL,
      NULL,
      5,
      1.555603,
      0.321035,
      1.546545,
      NULL,
      1.245587,
      0.708306,
      1,
      1.720711,
      0,
      1.546167,
      1,
      1,
      1.673749,
      2,
      NULL,
      5,
      NULL,
      NULL,
      9,
      0.039529,
      NULL,
      3.958015,
      NULL,
      2.105787,
      1,
      1,
      1,
      25,
      2,
      1,
      1,
      NULL,
      68,
      54.891018,
      2,
      2.032972,
      3,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.946540,
      NULL,
      NULL,
      NULL,
      NULL,
      21.604022,
      2.442659,
      3.818842,
      4,
      2.417969,
      1,
      NULL,
      1.503484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302008,
      2.528961,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.036883,
      NULL,
      NULL,
      3,
      NULL,
      3.980321,
      0,
      NULL,
      NULL,
      2,
      3,
      1,
      0.676114,
      NULL,
      NULL,
      5,
      7.192344,
      3.320019,
      1,
      1.696508,
      NULL,
      NULL,
      NULL,
      0.871190,
      NULL,
      NULL,
      NULL,
      3.734531,
      1,
      2.566581,
      1.483881,
      NULL,
      0.950634,
      2.841662,
      2,
      NULL,
      1,
      1.013603,
      1,
      NULL,
      2.036704,
      1.297562,
      0,
      0.041670,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1.808629,
      1.755397,
      NULL,
      1.848429,
      0.991490,
      0,
      NULL,
      1.799544,
      1.996498,
      0.381837,
      3.467997,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.503449,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.580225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.771501,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.983763,
      2,
      0,
      1.226891,
      NULL,
      NULL,
      5.309627,
      1,
      0.851879,
      NULL,
      5,
      3.255430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450642,
      3,
      NULL,
      0.687693,
      1.154780,
      1.632043,
      1.508029,
      6,
      5.389416,
      1,
      2.979446,
      1.453512,
      NULL,
      3.381877,
      3.761265,
      NULL,
      NULL,
      NULL,
      3.928657,
      0,
      0,
      7,
      NULL,
      4,
      0.776655,
      2,
      5.259102,
      NULL,
      2,
      3,
      1.216114,
      0.501033,
      NULL,
      1,
      0.980788,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.822392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.942868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.739160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.582233,
      1.436100,
      0,
      NULL,
      1,
      1.242862,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      NULL,
      3.768148,
      NULL,
      NULL,
      NULL,
      1.117857,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810852,
      NULL,
      NULL,
      NULL,
      3.291918,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.798387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.346378,
      NULL,
      NULL,
      NULL,
      2.276293,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.492905,
      NULL,
      NULL,
      NULL,
      1.972401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.240325,
      1339,
      0.832067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.022882,
      NULL,
      NULL,
      602.816987,
      154.549745,
      1,
      NULL,
      0.321431,
      0.813034,
      1.207404,
      1,
      0.629391,
      1.221924,
      1.705549,
      0.084198,
      NULL,
      0,
      1.765135,
      1,
      1.847006,
      NULL,
      1,
      1.145783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      6,
      2,
      1.966916,
      4,
      1,
      13.526275,
      1,
      0,
      0,
      1,
      2.182089,
      NULL,
      0.009465,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.844642,
      1,
      NULL,
      1.229733,
      0.738456,
      NULL,
      0.353214,
      1.595766,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      3,
      2.988050,
      NULL,
      NULL,
      1.009487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669858,
      NULL,
      1.434502,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.494356,
      NULL,
      NULL,
      74,
      90.981957,
      5,
      0,
      2,
      '01144',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '4114',
      '',
      '');
commit;
end;
/


