set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7810402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4243312',
      3.455338,
      1.816417,
      2,
      0,
      '2230',
      3,
      1.469792,
      NULL,
      NULL,
      ' 1-20-1975',
      31.435185,
      NULL,
      NULL,
      NULL,
      1.883250,
      '11-24-1990',
      57,
      3,
      26.111688,
      NULL,
      1,
      ' 7-28-1994',
      NULL,
      ' 7-27-1984',
      3.015226,
      2.099836,
      1.347508,
      0,
      0,
      0.936997,
      1,
      1.424927,
      1.915905,
      341.041135,
      NULL,
      10,
      5,
      79,
      143.919864,
      1,
      0.067650,
      NULL,
      2,
      NULL,
      0.918307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      4,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.135754,
      NULL,
      NULL,
      0.998200,
      1,
      1,
      NULL,
      3,
      0,
      1,
      1.808781,
      0.571720,
      1,
      3,
      NULL,
      NULL,
      2,
      1.317717,
      1,
      3,
      1.361985,
      3.618778,
      NULL,
      1,
      2,
      NULL,
      NULL,
      4,
      7,
      0,
      NULL,
      2.254135,
      NULL,
      NULL,
      NULL,
      3.891820,
      0,
      0,
      1,
      4,
      0,
      NULL,
      5,
      0,
      5,
      1,
      0,
      2,
      2,
      NULL,
      0,
      8.642531,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      3,
      1,
      4,
      1,
      1,
      3,
      1,
      4,
      4,
      NULL,
      3,
      1,
      1,
      NULL,
      5,
      NULL,
      0,
      4,
      0,
      NULL,
      1,
      1,
      2,
      5,
      5.813732,
      NULL,
      ' 7-11-1990',
      1396,
      ' 3-18-1988',
      1387,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.733217,
      0.831371,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629271,
      0,
      3.161324,
      NULL,
      1,
      4,
      2.920295,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.287767,
      1,
      5,
      2,
      NULL,
      NULL,
      1975,
      '10- 2-1988',
      2.830413,
      0.887236,
      0,
      NULL,
      0.540422,
      3.871786,
      0,
      0,
      1,
      0.365745,
      1.778555,
      3,
      20,
      2.461722,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.097427,
      3,
      NULL,
      1,
      1,
      1,
      1,
      0,
      2,
      2,
      1,
      3,
      2,
      7,
      18.104968,
      7,
      136.605350,
      156,
      155,
      186.043029,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.538890,
      2.089781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      13,
      1,
      40,
      2,
      NULL,
      2.723889,
      '31424',
      '04210',
      '',
      0,
      '',
      '',
      '',
      0.515302,
      '',
      NULL,
      '',
      2.435679,
      38.313934,
      378.753408,
      10,
      NULL,
      34.434342,
      6,
      NULL,
      1,
      0,
      3.682833,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289692,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.443691,
      NULL,
      NULL,
      0.989433,
      NULL,
      NULL,
      1.716970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      NULL,
      4.865311,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.802237,
      0,
      NULL,
      2.391655,
      2,
      NULL,
      0.162859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902985,
      0,
      1.356365,
      1.708857,
      2,
      2,
      1,
      1,
      2.798510,
      1.278618,
      1.140791,
      1,
      0,
      0,
      3.834006,
      1,
      1.419371,
      1,
      NULL,
      NULL,
      0.431161,
      NULL,
      NULL,
      NULL,
      0.309467,
      1,
      5.251057,
      NULL,
      2,
      1,
      0.577838,
      NULL,
      NULL,
      NULL,
      1,
      1.567116,
      0.616175,
      2.064271,
      0,
      NULL,
      NULL,
      0,
      0.169090,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3.772755,
      0.403194,
      NULL,
      1,
      NULL,
      NULL,
      5.314040,
      0.190674,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689351,
      NULL,
      NULL,
      1.339858,
      NULL,
      NULL,
      0.361679,
      NULL,
      NULL,
      NULL,
      0.848172,
      0,
      2,
      0.615980,
      2,
      5,
      3.910008,
      3,
      1.505111,
      NULL,
      NULL,
      1,
      NULL,
      1.375963,
      1.489861,
      NULL,
      0,
      2,
      2,
      0.118658,
      NULL,
      4,
      NULL,
      0.231311,
      2.715613,
      1,
      3,
      2,
      NULL,
      2.923565,
      1,
      1,
      NULL,
      0.634268,
      0.374715,
      NULL,
      0,
      7.421935,
      1.951571,
      NULL,
      NULL,
      2.982449,
      1,
      4,
      0,
      NULL,
      1.570918,
      NULL,
      0,
      3.492014,
      NULL,
      NULL,
      1.047574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.709609,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.829075,
      NULL,
      NULL,
      1.055230,
      NULL,
      NULL,
      1.120450,
      0.288403,
      NULL,
      1.008945,
      2.361351,
      3,
      2,
      NULL,
      NULL,
      3.241121,
      2.871694,
      NULL,
      4,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.239657,
      3,
      1.142979,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.660223,
      0,
      NULL,
      NULL,
      3.401121,
      NULL,
      0.994254,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.095593,
      NULL,
      NULL,
      NULL,
      3.183891,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.943827,
      NULL,
      1,
      NULL,
      0.924122,
      0,
      0.229165,
      NULL,
      1,
      3,
      0,
      NULL,
      1.987812,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      NULL,
      11.111983,
      15.518717,
      1,
      NULL,
      1.014523,
      2.166585,
      3.326986,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2.854723,
      49,
      3,
      0.138191,
      NULL,
      NULL,
      2.677862,
      2.977835,
      2,
      2.365490,
      11,
      3.127669,
      0.743186,
      NULL,
      NULL,
      1.436033,
      11,
      1,
      393,
      6,
      NULL,
      2,
      1.590583,
      NULL,
      NULL,
      1,
      0,
      0.512120,
      1,
      3.559313,
      1.159975,
      3.387436,
      0,
      NULL,
      0,
      1.207422,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      28,
      0,
      0.034574,
      NULL,
      NULL,
      1.529110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281991,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.729980,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.900055,
      NULL,
      1.416533,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0.901382,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.812232,
      NULL,
      1,
      0.323724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.625962,
      NULL,
      0.283003,
      NULL,
      NULL,
      NULL,
      1.391725,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.937011,
      1.342463,
      NULL,
      1.438584,
      NULL,
      NULL,
      NULL,
      140,
      NULL,
      0.908582,
      NULL,
      0.403497,
      NULL,
      1.682227,
      NULL,
      1,
      1,
      0.088676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.839066,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      2.603373,
      22,
      42,
      1.779609,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1.211402,
      0,
      1.701717,
      0.085653,
      1.296268,
      NULL,
      1.370265,
      3.649765,
      3.238288,
      0.441011,
      NULL,
      2.899537,
      NULL,
      NULL,
      NULL,
      1.351472,
      0,
      0.212716,
      NULL,
      NULL,
      1,
      1,
      2.162088,
      3,
      NULL,
      1,
      3.738655,
      0.489505,
      NULL,
      0.427451,
      1.871600,
      2.212361,
      1,
      NULL,
      1.023377,
      0,
      3,
      3,
      0.673419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.426293,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.740773,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      31.516970,
      0.335285,
      NULL,
      1.369717,
      1,
      1.378039,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0,
      NULL,
      1.764047,
      3,
      22.947841,
      49.774406,
      3,
      0,
      5.629163,
      '01424',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


