set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4243014',
      0,
      1,
      NULL,
      1,
      NULL,
      3.938949,
      0.459756,
      NULL,
      NULL,
      ' 8-17-2000',
      36,
      NULL,
      2,
      NULL,
      1.528043,
      ' 2-14-1985',
      35.898405,
      3.562549,
      255,
      36,
      0,
      NULL,
      NULL,
      ' 1-24-1975',
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      0.440375,
      NULL,
      NULL,
      6,
      16.588516,
      NULL,
      21,
      11.938967,
      NULL,
      1,
      5,
      0,
      7.800128,
      1.690782,
      1,
      1,
      0,
      1,
      1,
      1,
      1.151575,
      0,
      0.847634,
      1.041906,
      2,
      2,
      6,
      0,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0.282979,
      0,
      0,
      2,
      1,
      1.365735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      1.332402,
      2,
      NULL,
      1.975496,
      NULL,
      NULL,
      2,
      1.172368,
      3,
      3,
      0.755764,
      1.420521,
      0,
      1.795876,
      NULL,
      2,
      3.104188,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1.054276,
      0,
      NULL,
      NULL,
      0.515566,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      2,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      1,
      0,
      2,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      5,
      1,
      0,
      1,
      3,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      3,
      1,
      1,
      1,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      5.743783,
      NULL,
      ' 7- 4-1992',
      331,
      NULL,
      171.212976,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0.058058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      0,
      3,
      2,
      0.268627,
      NULL,
      0,
      NULL,
      0.250071,
      0.157355,
      NULL,
      NULL,
      NULL,
      NULL,
      3.024387,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987270,
      1,
      1.116674,
      1.302866,
      1,
      1.612556,
      0,
      NULL,
      0,
      1,
      NULL,
      29.728892,
      36,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      3,
      0,
      2,
      1,
      3,
      0,
      0,
      18,
      8,
      3.175703,
      NULL,
      0.585225,
      30,
      NULL,
      NULL,
      1,
      1.309078,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      9,
      1,
      0,
      6.901597,
      7.997124,
      NULL,
      8.880192,
      5.738305,
      2.220129,
      NULL,
      5.748732,
      0,
      1.598769,
      3,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3,
      4.634271,
      3,
      '02032',
      '',
      '',
      0.899940,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      3,
      103.772436,
      1,
      NULL,
      5.534068,
      1,
      5,
      NULL,
      0,
      2.511882,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.588183,
      0.392228,
      3.007910,
      0.286867,
      0.737807,
      1.576009,
      1,
      2.023959,
      NULL,
      NULL,
      NULL,
      2.757765,
      0.954653,
      3,
      0,
      1.643947,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.090502,
      7,
      4.283720,
      NULL,
      1.552559,
      NULL,
      NULL,
      NULL,
      1.254201,
      NULL,
      NULL,
      NULL,
      0,
      1.337334,
      1.911934,
      1,
      NULL,
      NULL,
      1,
      3.225189,
      1,
      1.085099,
      0.517303,
      0,
      1.187810,
      0.203416,
      0.911858,
      NULL,
      0,
      NULL,
      1.545903,
      NULL,
      2.775852,
      0.656869,
      0,
      1.698035,
      NULL,
      0,
      NULL,
      NULL,
      0.252745,
      NULL,
      NULL,
      0.607805,
      0.328958,
      0,
      1,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.052993,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.057888,
      NULL,
      NULL,
      1,
      3.155689,
      1.906086,
      0,
      NULL,
      NULL,
      2.517922,
      0.190485,
      1.915209,
      2.315591,
      2.256926,
      2,
      1.275719,
      NULL,
      NULL,
      6,
      0.051294,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.985165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.139253,
      0,
      3.492154,
      1.860100,
      NULL,
      NULL,
      3.389809,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.964033,
      0.250861,
      2,
      1,
      NULL,
      NULL,
      3.690152,
      6.745351,
      6,
      NULL,
      1.807802,
      2.332893,
      2,
      1,
      NULL,
      NULL,
      1.569152,
      NULL,
      0.786945,
      2.275342,
      1,
      2.468158,
      4.494760,
      5.966685,
      6.917362,
      2.824152,
      7.244755,
      NULL,
      1.620684,
      2,
      1,
      0,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803089,
      NULL,
      NULL,
      0.961273,
      NULL,
      NULL,
      0.512531,
      NULL,
      NULL,
      0.150856,
      NULL,
      NULL,
      1.272152,
      NULL,
      NULL,
      NULL,
      0.982671,
      1.122651,
      0.400180,
      1,
      0,
      1,
      NULL,
      NULL,
      1.714127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.469037,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.745130,
      NULL,
      NULL,
      NULL,
      1.088244,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.625765,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      15.131176,
      NULL,
      NULL,
      NULL,
      0.052523,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.632081,
      1.947123,
      0,
      0,
      0,
      NULL,
      NULL,
      0.178852,
      7.990756,
      0,
      1.000026,
      NULL,
      NULL,
      1.009450,
      NULL,
      NULL,
      1,
      NULL,
      0.576847,
      427.649125,
      6,
      NULL,
      NULL,
      1,
      0.072168,
      1.010134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.748246,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.592327,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.406953,
      NULL,
      NULL,
      NULL,
      1.465146,
      NULL,
      NULL,
      NULL,
      1.026594,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.884263,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.995212,
      NULL,
      0.422783,
      NULL,
      NULL,
      NULL,
      1.243602,
      NULL,
      NULL,
      NULL,
      1.655257,
      NULL,
      0,
      0,
      0.804307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299088,
      2.042907,
      NULL,
      2.748160,
      NULL,
      1,
      NULL,
      41,
      NULL,
      0.640108,
      1,
      2,
      NULL,
      1.009228,
      NULL,
      1.029877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108315,
      1,
      NULL,
      0,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.513814,
      0.152791,
      1.488123,
      1,
      1,
      0.950160,
      2,
      1,
      0.480788,
      1.999175,
      NULL,
      1,
      0.822047,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      0.875204,
      NULL,
      1.482500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615907,
      NULL,
      0,
      0.125484,
      NULL,
      1,
      2,
      NULL,
      1.506170,
      0,
      NULL,
      NULL,
      NULL,
      1.208031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      38,
      60,
      3,
      5.561604,
      6,
      '12204',
      '23303',
      '32034',
      0.333434,
      '',
      '',
      '',
      1.940264,
      '',
      '',
      '');
commit;
end;
/


