set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4334243',
      NULL,
      0,
      3,
      3,
      NULL,
      1.111632,
      1,
      NULL,
      NULL,
      '11-10-2003',
      53.679617,
      NULL,
      1,
      NULL,
      0.340858,
      '11-27-1999',
      15,
      2.208779,
      41.281839,
      26.863024,
      0,
      ' 2-16-1991',
      ' 3-11-1974',
      ' 8- 5-1988',
      NULL,
      NULL,
      2.606358,
      2.354966,
      1,
      3.966676,
      0,
      1,
      1,
      64.603328,
      2,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      4,
      0,
      3.273352,
      0.377389,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0.034932,
      0,
      1,
      180,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      5,
      2,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.385501,
      NULL,
      NULL,
      1.806899,
      NULL,
      NULL,
      2,
      2,
      6.182361,
      0,
      NULL,
      NULL,
      3.562507,
      0,
      2.676916,
      NULL,
      0,
      NULL,
      0.711515,
      1.024386,
      1,
      0.304488,
      3,
      1.056634,
      1.848979,
      2,
      NULL,
      2,
      9.780832,
      0,
      1,
      NULL,
      0.749144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1.131135,
      NULL,
      NULL,
      0,
      4,
      4,
      NULL,
      0,
      4,
      2,
      NULL,
      2,
      5,
      1,
      3,
      5,
      5,
      5,
      1,
      1,
      0,
      0,
      5,
      NULL,
      1,
      4,
      NULL,
      0,
      NULL,
      NULL,
      ' 6- 8-1980',
      204,
      ' 1-29-1979',
      158,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.510384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.849758,
      3.060568,
      0.904831,
      NULL,
      4,
      1,
      1,
      1,
      0,
      9.145347,
      0.693020,
      NULL,
      NULL,
      NULL,
      1.935067,
      NULL,
      1.223124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.056139,
      1,
      NULL,
      NULL,
      NULL,
      1.728633,
      1,
      0.240232,
      514,
      0,
      1.010010,
      7,
      1.648073,
      244.002161,
      0,
      1.065241,
      3,
      0,
      0,
      3,
      0,
      1,
      NULL,
      0,
      1,
      0,
      3,
      2.366578,
      NULL,
      6,
      1,
      0,
      3.660831,
      0,
      0.394777,
      1,
      0.079367,
      0,
      1,
      1.287696,
      NULL,
      1.114228,
      NULL,
      1,
      NULL,
      1,
      8.884294,
      5.221593,
      5,
      3,
      11.707119,
      1,
      5,
      0,
      0,
      2.545792,
      3.221492,
      3,
      7.060261,
      2,
      NULL,
      NULL,
      7,
      6,
      4.186243,
      NULL,
      1,
      0.083030,
      '23003',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      3.211535,
      '21214',
      '',
      '',
      2.005417,
      32.883311,
      NULL,
      4,
      NULL,
      3.844037,
      2,
      15.902213,
      NULL,
      2,
      NULL,
      1.685711,
      NULL,
      NULL,
      NULL,
      2.537996,
      1,
      0.699265,
      3.328089,
      2.653970,
      0,
      NULL,
      3,
      0.772278,
      2,
      NULL,
      0.219656,
      0,
      2,
      1.753438,
      0,
      NULL,
      NULL,
      0.273104,
      NULL,
      NULL,
      1,
      0,
      0.118598,
      1,
      NULL,
      NULL,
      1.115580,
      NULL,
      NULL,
      4,
      3.152891,
      3.649622,
      2,
      0.173012,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.872263,
      3,
      NULL,
      2,
      1,
      2,
      0,
      NULL,
      3,
      2,
      1.592824,
      2,
      1,
      NULL,
      3,
      3,
      2.897844,
      1,
      NULL,
      3,
      0.315074,
      3.036971,
      3.301184,
      0.022790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.793278,
      1,
      1.067737,
      1,
      1,
      2.054238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747287,
      NULL,
      NULL,
      NULL,
      1.043885,
      NULL,
      NULL,
      0.500454,
      3,
      NULL,
      1.053401,
      1.633580,
      0.536010,
      0.290259,
      NULL,
      NULL,
      7.310385,
      5.501234,
      3,
      2.995883,
      NULL,
      0,
      1,
      1,
      1.064947,
      1,
      0,
      1.622514,
      0.768609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595171,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.393646,
      0.331232,
      1.153590,
      1,
      1.867017,
      NULL,
      1,
      0,
      NULL,
      3.087296,
      1,
      NULL,
      6,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      2,
      0,
      0.763745,
      8,
      7.033133,
      4.589745,
      2,
      1,
      NULL,
      3.874256,
      1.650046,
      3,
      2.114818,
      0,
      NULL,
      1,
      2.423105,
      2,
      NULL,
      8.524719,
      5,
      7.174571,
      3,
      2,
      1,
      3,
      4,
      1,
      NULL,
      0,
      1.675100,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.988292,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1,
      NULL,
      1.204709,
      1,
      0.007784,
      0.051606,
      0,
      NULL,
      NULL,
      NULL,
      0.791005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435070,
      2,
      NULL,
      NULL,
      NULL,
      0.297139,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.776700,
      NULL,
      NULL,
      3.853473,
      1,
      NULL,
      NULL,
      1,
      0.251370,
      NULL,
      NULL,
      2.962586,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.188447,
      NULL,
      NULL,
      NULL,
      3.715317,
      2.501058,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.536223,
      NULL,
      274.007391,
      NULL,
      0,
      1,
      0.130779,
      NULL,
      NULL,
      3.568208,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      11,
      NULL,
      0,
      NULL,
      1,
      69.800153,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.854921,
      0,
      1,
      2,
      NULL,
      0.634531,
      NULL,
      0.558998,
      NULL,
      1.162576,
      1,
      2.631914,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.886017,
      NULL,
      0.403099,
      NULL,
      0,
      NULL,
      1.172594,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.489590,
      NULL,
      1.087972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.065079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343709,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.073051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.507433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.647085,
      NULL,
      0.090288,
      NULL,
      1.710316,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      4.871010,
      2.144092,
      NULL,
      3,
      2,
      8,
      2,
      3,
      3.393986,
      NULL,
      NULL,
      1.957846,
      0.957133,
      0.768863,
      0.989472,
      NULL,
      1.454529,
      0,
      0.714719,
      0,
      0,
      1,
      0,
      0.441506,
      0,
      1.635205,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.970771,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1.133727,
      0.157054,
      1,
      0.719291,
      3.552611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233073,
      1,
      1,
      1.772086,
      0.569922,
      1.122060,
      1,
      5,
      5,
      2.533241,
      1.443848,
      2.493623,
      NULL,
      98,
      4,
      0,
      1,
      '13020',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


