set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6516689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      NULL,
      11.407301,
      34,
      '4343121',
      NULL,
      0,
      2,
      1,
      '4240',
      NULL,
      0.947282,
      NULL,
      NULL,
      ' 5-16-1979',
      NULL,
      8,
      NULL,
      1,
      NULL,
      '10- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10- 6-1994',
      NULL,
      ' 4- 0-1995',
      2,
      NULL,
      3,
      1.098875,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      4,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.743718,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      1,
      0,
      8,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      2.939969,
      NULL,
      0,
      2,
      1.382024,
      0.997937,
      1,
      1.662765,
      0.623786,
      NULL,
      NULL,
      NULL,
      0,
      0.335651,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      NULL,
      0.887519,
      1.793161,
      NULL,
      NULL,
      0.875716,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0.711171,
      0,
      0,
      NULL,
      NULL,
      1.491121,
      NULL,
      3.942234,
      1,
      0,
      1,
      1,
      0,
      1,
      5,
      0,
      3,
      0,
      0,
      0,
      NULL,
      0,
      0,
      5,
      0,
      2,
      NULL,
      4,
      NULL,
      2,
      5,
      1,
      0,
      1.673683,
      2.138804,
      NULL,
      985.005476,
      ' 2-10-1998',
      1063,
      0.521607,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.286563,
      0.032729,
      1.340122,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.891124,
      4,
      NULL,
      0.694509,
      4,
      1.100071,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.813819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.361123,
      NULL,
      0,
      1.796817,
      NULL,
      0,
      48,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371297,
      0,
      3,
      1,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.108995,
      0.890478,
      2,
      1,
      1.349323,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1.593275,
      0.267440,
      0.723688,
      NULL,
      1.404799,
      NULL,
      1,
      3.435475,
      NULL,
      6,
      0.823716,
      3.528730,
      1,
      NULL,
      1,
      1.077807,
      0.785542,
      0.717175,
      2,
      50,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      1,
      5.832583,
      0,
      '43444',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3.441074,
      NULL,
      90,
      28,
      2,
      NULL,
      20.547177,
      NULL,
      NULL,
      2.290503,
      0.681085,
      2,
      1.355638,
      NULL,
      NULL,
      2.467696,
      3,
      1.057275,
      3,
      NULL,
      1.422357,
      0,
      NULL,
      NULL,
      0.259272,
      NULL,
      NULL,
      2.277899,
      0.797806,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1.046572,
      1.077880,
      0,
      NULL,
      NULL,
      1.796623,
      NULL,
      NULL,
      1.927880,
      NULL,
      NULL,
      9.312056,
      3.335218,
      NULL,
      1,
      1.260777,
      NULL,
      NULL,
      NULL,
      NULL,
      2.760427,
      0,
      3.195358,
      3,
      1,
      0.779450,
      1.603870,
      NULL,
      NULL,
      1.429493,
      NULL,
      NULL,
      0.576495,
      0.540187,
      NULL,
      2.522444,
      3,
      1.103981,
      2.057371,
      1.392182,
      NULL,
      3.460398,
      3.292202,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.439245,
      NULL,
      NULL,
      NULL,
      0.046053,
      NULL,
      NULL,
      0,
      4.501390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.319589,
      0,
      1.413008,
      0.968495,
      1,
      NULL,
      NULL,
      0.828250,
      NULL,
      NULL,
      NULL,
      0.504711,
      0,
      1.528791,
      NULL,
      NULL,
      0,
      4.251984,
      1,
      0.283356,
      NULL,
      NULL,
      1.814759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.168158,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      6.340096,
      NULL,
      5.625268,
      1.278974,
      NULL,
      0.605011,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      2.136070,
      0,
      1,
      NULL,
      NULL,
      0,
      0.031438,
      NULL,
      NULL,
      2.717587,
      3,
      2,
      1.604070,
      1.932275,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0.609614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.736318,
      NULL,
      NULL,
      0.973829,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.316137,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.308643,
      1.949598,
      NULL,
      0.916921,
      NULL,
      NULL,
      1.793004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.359759,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.336254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.720545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.217876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.701442,
      NULL,
      NULL,
      NULL,
      3.464547,
      NULL,
      5,
      1,
      2.512748,
      121.452417,
      10.960913,
      3.530735,
      NULL,
      23.674552,
      0,
      NULL,
      NULL,
      1,
      51.016197,
      4,
      0,
      6.805023,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.239701,
      184,
      28,
      1,
      0.412848,
      0,
      1.713518,
      NULL,
      3.510529,
      0,
      0,
      0,
      0,
      1,
      0.509012,
      0,
      0,
      0.146452,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.956133,
      NULL,
      0,
      NULL,
      0,
      NULL,
      8,
      NULL,
      3.359808,
      30.143532,
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.694152,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.561252,
      NULL,
      NULL,
      NULL,
      1.185746,
      NULL,
      0,
      NULL,
      1.434865,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.682347,
      0.929575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.405932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790338,
      0.169466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.209773,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.958128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      0.889051,
      2.764130,
      3.410947,
      2,
      2,
      0.677643,
      0,
      1,
      0,
      1.157795,
      NULL,
      1.825961,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.003123,
      NULL,
      1,
      1,
      NULL,
      1.216365,
      3,
      NULL,
      1,
      0.247724,
      NULL,
      1.371537,
      0.699437,
      0.410534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.234096,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      7,
      74.466356,
      5,
      1.277465,
      0,
      '33040',
      '13031',
      NULL,
      0.810363,
      NULL,
      '',
      '',
      0.904687,
      '',
      '',
      '');
commit;
end;
/


