set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8101660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1132332',
      3.853441,
      NULL,
      0,
      1,
      '4213',
      2,
      3,
      NULL,
      16.328158,
      NULL,
      NULL,
      NULL,
      2,
      3.428805,
      1.013069,
      ' 4-27-1982',
      7,
      2,
      38,
      174,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.970463,
      NULL,
      NULL,
      NULL,
      0,
      23.056206,
      1,
      15,
      3,
      18.864600,
      24,
      3,
      5.584876,
      2,
      4,
      10.539242,
      1,
      0,
      1,
      0,
      1.236671,
      NULL,
      NULL,
      173,
      1.610881,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.204617,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      4,
      NULL,
      3,
      0,
      NULL,
      0,
      5,
      1,
      3,
      1.702694,
      0.463363,
      NULL,
      93,
      ' 4- 0-1996',
      277,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.675956,
      3,
      2.121546,
      0.764495,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.529431,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174285,
      0.551681,
      0,
      1.724888,
      NULL,
      1,
      1.307577,
      1.484787,
      NULL,
      3.027879,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      2.754126,
      NULL,
      0.276141,
      0.913429,
      1,
      1.638216,
      0.688313,
      0,
      1.428073,
      0.169457,
      1,
      1,
      0.702801,
      NULL,
      1.511193,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064921,
      10,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.022914,
      '11312',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      34,
      NULL,
      18.494371,
      NULL,
      8,
      NULL,
      9,
      1,
      1,
      6.747607,
      1.774055,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.669843,
      2.303106,
      3.665638,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      1.617304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944983,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      9,
      0.544181,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972570,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.451995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.119434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.070547,
      3,
      1,
      18.573229,
      3,
      2,
      2,
      0.107097,
      NULL,
      NULL,
      0,
      4.864137,
      5,
      1,
      NULL,
      1.957369,
      1,
      1.381216,
      16,
      7,
      NULL,
      1.224933,
      1.934214,
      NULL,
      NULL,
      0.006385,
      NULL,
      NULL,
      1.798367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340708,
      NULL,
      NULL,
      0.889387,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.555999,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978159,
      NULL,
      NULL,
      0,
      0.110740,
      2.593187,
      NULL,
      9.231497,
      0.580058,
      3,
      NULL,
      0,
      16.553973,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2.232170,
      3,
      0,
      2,
      0,
      2,
      7,
      2.955139,
      2.550065,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.204615,
      0,
      1,
      1,
      1.246804,
      3.136921,
      NULL,
      NULL,
      2.618711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.305592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8.135701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.471952,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.873774,
      NULL,
      NULL,
      NULL,
      0.121384,
      NULL,
      NULL,
      NULL,
      6.535170,
      NULL,
      NULL,
      NULL,
      7.658557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.460970,
      NULL,
      NULL,
      NULL,
      1.213668,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.849058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.564035,
      NULL,
      NULL,
      NULL,
      0,
      82.203814,
      26.333198,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      22.815468,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.926060,
      9417,
      252,
      1.662485,
      1.152986,
      NULL,
      1,
      0,
      0.691225,
      1.193633,
      NULL,
      1,
      0,
      0,
      1.043909,
      1.272318,
      1,
      1,
      0.761459,
      1,
      0.173353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705726,
      3.147918,
      1,
      18,
      7.103836,
      NULL,
      3,
      5,
      NULL,
      0.401144,
      9.566247,
      NULL,
      8.793314,
      16.941448,
      NULL,
      7,
      2,
      NULL,
      0,
      3,
      NULL,
      2,
      0,
      NULL,
      8.915730,
      5.832091,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929787,
      1.307322,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.669240,
      NULL,
      1,
      NULL,
      3,
      5,
      3,
      3,
      0.758148,
      2.440722,
      10.385207,
      38.121580,
      5,
      NULL,
      2.456581,
      '10201',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


