set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9880269';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.021670,
      1,
      6,
      0.147916,
      NULL,
      0,
      0,
      0,
      '142',
      '34103012',
      NULL,
      24,
      NULL,
      1,
      1,
      1,
      3,
      '4143',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      165,
      138,
      NULL,
      1.846848,
      3.020103,
      ' 4-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1989',
      ' 1- 3-1984',
      ' 7- 2-1982',
      2.070671,
      2.481484,
      2,
      2,
      NULL,
      0,
      2,
      1,
      NULL,
      0.030003,
      5,
      12.234159,
      1.420096,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      1,
      1,
      NULL,
      2,
      1,
      1,
      1,
      0,
      2,
      0,
      0,
      1,
      8.251352,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.513832,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      0,
      4,
      4,
      1,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      9,
      1,
      1,
      0,
      1,
      0.019114,
      NULL,
      0,
      NULL,
      4,
      2,
      0,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      4,
      1,
      NULL,
      1,
      0.692968,
      0,
      ' 1-13-1989',
      651.878084,
      ' 8- 0-1974',
      378,
      3.030733,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      1,
      1,
      2,
      0,
      3,
      NULL,
      5,
      4,
      2,
      5,
      0.243157,
      5,
      1.074883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909191,
      0,
      NULL,
      1.647174,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.475981,
      1.498729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.605371,
      0.961022,
      NULL,
      1,
      0,
      0,
      3.984521,
      0.730276,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.700096,
      NULL,
      3,
      3,
      3,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      1,
      3.511436,
      1,
      0.794982,
      1,
      0.710956,
      1.738050,
      1,
      NULL,
      1.081533,
      NULL,
      1.315887,
      1.684457,
      1.550923,
      NULL,
      0,
      0,
      0,
      0.767292,
      0,
      4,
      10,
      1,
      2,
      6.526511,
      0,
      1.328037,
      2,
      3,
      3,
      1,
      0.075388,
      19,
      NULL,
      1.206144,
      NULL,
      NULL,
      NULL,
      12.417870,
      5,
      5,
      NULL,
      '13421',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.644364,
      7.071286,
      16,
      15.873817,
      2,
      NULL,
      7,
      4,
      NULL,
      2.044930,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.840020,
      0.799119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.583353,
      2,
      NULL,
      NULL,
      NULL,
      1.971016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.159431,
      NULL,
      NULL,
      6,
      2.302019,
      NULL,
      0,
      1.514471,
      NULL,
      NULL,
      NULL,
      1.412152,
      NULL,
      NULL,
      NULL,
      1.460815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811778,
      NULL,
      NULL,
      0.523523,
      NULL,
      NULL,
      1.117965,
      NULL,
      NULL,
      1.884400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.776483,
      1,
      1.531551,
      NULL,
      1.765550,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.927246,
      0,
      5,
      5,
      1.810467,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.468002,
      NULL,
      NULL,
      1.635800,
      NULL,
      NULL,
      0.180110,
      NULL,
      NULL,
      0.276299,
      NULL,
      NULL,
      3.090502,
      0.687769,
      3,
      0.515540,
      NULL,
      0.543211,
      NULL,
      1,
      2,
      5.173781,
      1,
      NULL,
      NULL,
      0,
      2.131211,
      3.422765,
      NULL,
      2.957606,
      0.503488,
      NULL,
      NULL,
      0.734721,
      2.067552,
      4,
      1,
      2,
      0,
      0.971779,
      NULL,
      NULL,
      3,
      2,
      3,
      3.494260,
      1.080556,
      0,
      NULL,
      4,
      4,
      0.439089,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0.783035,
      1.877403,
      NULL,
      0,
      NULL,
      NULL,
      3.683773,
      NULL,
      NULL,
      93,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.963696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319663,
      NULL,
      NULL,
      1.571765,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.267685,
      NULL,
      NULL,
      1.363653,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8.456880,
      NULL,
      NULL,
      0.892417,
      1.307590,
      1.354566,
      1.243319,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.673399,
      NULL,
      NULL,
      NULL,
      1.692194,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962992,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.495786,
      NULL,
      NULL,
      NULL,
      0.592239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571021,
      65,
      2.116437,
      NULL,
      14,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.654019,
      9,
      0,
      1,
      NULL,
      NULL,
      1.973318,
      NULL,
      NULL,
      139.514393,
      NULL,
      NULL,
      NULL,
      0.642423,
      1.137218,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.556580,
      0,
      0.775091,
      1,
      1.435953,
      0.541119,
      NULL,
      3.862730,
      NULL,
      0,
      0,
      0.767380,
      NULL,
      1.795148,
      0.513213,
      0.965510,
      1,
      0.560236,
      1.633955,
      1.412980,
      0.000247,
      1.241396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236799,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866363,
      0.428300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.404504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219784,
      0.246958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.730363,
      NULL,
      NULL,
      NULL,
      1,
      0.072431,
      1.633350,
      0.734451,
      1,
      1,
      0.827508,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1,
      1.174952,
      5,
      0,
      4.291151,
      1.364801,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      1.648117,
      NULL,
      0,
      0.197330,
      NULL,
      3,
      3.104441,
      NULL,
      3.202678,
      1.382824,
      NULL,
      3.347882,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.144189,
      NULL,
      0,
      0.054305,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      1.144236,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746381,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.510894,
      NULL,
      0.378149,
      NULL,
      1,
      NULL,
      6.261194,
      0.430523,
      NULL,
      1.449612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.652958,
      NULL,
      0,
      NULL,
      0.152888,
      NULL,
      2,
      3,
      5,
      1,
      NULL,
      NULL,
      9.981549,
      44.214257,
      4,
      4.615488,
      NULL,
      '00124',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.265289,
      NULL,
      '',
      '');
commit;
end;
/


