set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9008277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2444212',
      NULL,
      0,
      2,
      NULL,
      '1040',
      0,
      1.829522,
      NULL,
      NULL,
      ' 5-18-1998',
      39.570881,
      NULL,
      NULL,
      0,
      0.755829,
      ' 4- 0-1988',
      18.742664,
      1.457292,
      265.500548,
      83,
      3,
      ' 3- 3-1982',
      ' 5-20-1998',
      ' 2-25-1980',
      2.818882,
      NULL,
      0,
      3,
      1,
      0.681853,
      7,
      1,
      NULL,
      0,
      3,
      17.995769,
      2,
      NULL,
      25.291668,
      NULL,
      NULL,
      NULL,
      2,
      4.904402,
      1.027330,
      NULL,
      1,
      1.516797,
      0,
      1,
      NULL,
      0,
      0,
      2.021628,
      0.022139,
      2,
      0,
      0,
      2,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      3,
      0,
      0,
      0,
      0,
      NULL,
      0.393757,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.582554,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      0,
      1,
      5,
      0,
      1,
      1,
      2,
      0,
      1,
      0,
      0,
      0.658905,
      NULL,
      1,
      5,
      1,
      0,
      0,
      0,
      4,
      1,
      0,
      1,
      2,
      5,
      2,
      3,
      1,
      5,
      0,
      1,
      NULL,
      5,
      3,
      1,
      4,
      NULL,
      1,
      3,
      4.027606,
      0,
      ' 3-25-1995',
      252.037492,
      '11- 6-1994',
      166.421734,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      4,
      1,
      1.780343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.919224,
      3.121700,
      0,
      NULL,
      1,
      2,
      2,
      5,
      4,
      NULL,
      NULL,
      2,
      NULL,
      2.991124,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      ' 5-11-1985',
      179.678375,
      ' 0-16-1976',
      5,
      0.806882,
      0,
      1.240959,
      3,
      NULL,
      0,
      0.245027,
      0.061227,
      1,
      0,
      3,
      26,
      NULL,
      1.657638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      2,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      0.896571,
      1.591111,
      3.421142,
      2.123806,
      183,
      6.451328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228108,
      1,
      0,
      1.431111,
      NULL,
      1.337612,
      1,
      10,
      6,
      1,
      7,
      4.203283,
      1.264493,
      NULL,
      NULL,
      1.355837,
      1.261461,
      0,
      8,
      0,
      0.994380,
      NULL,
      61,
      69,
      77.330380,
      0,
      0.477718,
      2.929790,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      1.645701,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608397,
      0.589852,
      0.623246,
      NULL,
      0,
      0.475487,
      0,
      NULL,
      NULL,
      1.264362,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.336703,
      NULL,
      NULL,
      0.274732,
      NULL,
      1.582374,
      NULL,
      0,
      1.479603,
      1.198835,
      0,
      1,
      NULL,
      1,
      3.026868,
      1.594720,
      NULL,
      0.569360,
      1,
      0.978068,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      3.436375,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.576316,
      NULL,
      3.993559,
      NULL,
      118,
      NULL,
      2.157125,
      NULL,
      36.689639,
      NULL,
      1,
      0.568671,
      NULL,
      1.312295,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.349006,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.071543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.233757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.631225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902690,
      NULL,
      NULL,
      0.559739,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.072499,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.356997,
      3,
      1,
      1.874286,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.529964,
      NULL,
      0,
      0.565732,
      NULL,
      0.302328,
      0.025937,
      NULL,
      3,
      1.833435,
      NULL,
      1.516164,
      1.298410,
      NULL,
      1.211322,
      2.883249,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.245936,
      NULL,
      1.461170,
      1.212069,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.329350,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.370048,
      NULL,
      NULL,
      NULL,
      2.071541,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.224808,
      NULL,
      1.648176,
      NULL,
      2,
      NULL,
      11.907210,
      2,
      NULL,
      NULL,
      NULL,
      1.260821,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      1.654397,
      NULL,
      NULL,
      21.475600,
      64.086264,
      3,
      1,
      2,
      '33442',
      '13310',
      '',
      0.327486,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


