set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3123024',
      2,
      0,
      1,
      1,
      '2110',
      1,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1988',
      55,
      NULL,
      NULL,
      0,
      1.038488,
      ' 7-25-1978',
      15.184165,
      2.737444,
      41.183249,
      78.279802,
      2,
      ' 5-27-1981',
      NULL,
      ' 3-24-2001',
      3,
      2,
      3.624264,
      1,
      1.383456,
      0.749289,
      2,
      1.198485,
      1.922817,
      3,
      4,
      1.528530,
      7.256578,
      NULL,
      2,
      1,
      22.667384,
      NULL,
      2,
      1.246203,
      0,
      0,
      NULL,
      0.105815,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      5,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033131,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0,
      4,
      5,
      0,
      8.062510,
      0,
      0,
      1,
      0,
      1.923826,
      NULL,
      1.994964,
      3,
      2,
      1,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      3,
      1,
      0,
      1,
      3,
      4,
      0,
      8,
      3,
      ' 5-25-1976',
      270.712162,
      NULL,
      370,
      0,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327592,
      NULL,
      1,
      0.922149,
      1,
      1.267140,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.134982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.061010,
      1.693406,
      1.497431,
      1,
      3,
      0.826091,
      0.480004,
      2,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.022790,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      NULL,
      1,
      2,
      3,
      2,
      2.963847,
      0.052204,
      1.416251,
      NULL,
      0.453447,
      0,
      0.353390,
      NULL,
      NULL,
      0.187496,
      0,
      0,
      1,
      1.201355,
      3,
      1.736764,
      NULL,
      0,
      7,
      5.269004,
      NULL,
      5.243863,
      1.159663,
      0,
      2,
      NULL,
      3.524399,
      NULL,
      3.556523,
      1.699027,
      57,
      0,
      1.357039,
      NULL,
      30,
      NULL,
      22,
      0,
      0,
      1.451349,
      '41212',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.225019,
      51.661988,
      47,
      52,
      1,
      48.713910,
      3,
      2.149529,
      4,
      1,
      2,
      7.793106,
      2.111048,
      1.355075,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432687,
      NULL,
      NULL,
      NULL,
      1.671120,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.493384,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.949040,
      NULL,
      NULL,
      0.252179,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.241929,
      NULL,
      NULL,
      1.166672,
      NULL,
      NULL,
      1.133529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.303504,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      8.084655,
      16.567388,
      1.347037,
      NULL,
      NULL,
      3,
      0.281610,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.781108,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.543733,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      19,
      3.551539,
      5.824114,
      12,
      0.731022,
      15,
      16.070466,
      NULL,
      1.442234,
      0,
      1,
      NULL,
      NULL,
      0.131458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.387854,
      NULL,
      NULL,
      0.071804,
      NULL,
      NULL,
      0.103720,
      1.416174,
      0.361511,
      1.302515,
      2,
      0,
      1.126925,
      0.044682,
      NULL,
      NULL,
      0.346512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.085944,
      NULL,
      NULL,
      0.022917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.314179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.222853,
      NULL,
      NULL,
      NULL,
      1.753383,
      0,
      NULL,
      NULL,
      0,
      0.232534,
      NULL,
      NULL,
      0.316643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.736081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.546865,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.495046,
      NULL,
      NULL,
      NULL,
      0.797064,
      NULL,
      NULL,
      NULL,
      NULL,
      30.003933,
      NULL,
      1,
      NULL,
      NULL,
      0.807931,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2.158170,
      3.175522,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      452.404657,
      12,
      NULL,
      0.671388,
      1,
      NULL,
      1,
      0.076785,
      1.292860,
      1.471176,
      0.973158,
      1.478093,
      NULL,
      1,
      1.172035,
      0,
      0.989240,
      0.479249,
      0.341966,
      1.455649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.168708,
      1,
      1.459075,
      3.961680,
      0,
      2,
      0,
      NULL,
      1,
      0.526039,
      1,
      NULL,
      NULL,
      1.002607,
      NULL,
      0.184621,
      1,
      NULL,
      0.086182,
      NULL,
      NULL,
      NULL,
      1.181231,
      NULL,
      1,
      0.347055,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1.625262,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.860961,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.800070,
      NULL,
      1,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      31.432451,
      3,
      1.495942,
      3.700807,
      '32103',
      NULL,
      '',
      0.987125,
      '',
      '',
      NULL,
      0.773084,
      '',
      '',
      NULL);
commit;
end;
/


