set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1434414',
      1,
      1,
      1,
      3,
      NULL,
      2,
      1.285360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      6,
      NULL,
      11.174271,
      0.556291,
      309.417942,
      116.488697,
      3,
      ' 1- 8-1984',
      NULL,
      NULL,
      1,
      1.391786,
      1.931353,
      1,
      1.113323,
      1.270382,
      2,
      1.259961,
      1,
      75.099096,
      4,
      NULL,
      5.190345,
      NULL,
      15,
      1,
      17.973822,
      2,
      1,
      7.605459,
      1.381322,
      1,
      3,
      1,
      2,
      NULL,
      0,
      NULL,
      1.450796,
      1.829956,
      NULL,
      0,
      3,
      2,
      1,
      4,
      3,
      1,
      4,
      5,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.895816,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.050487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1.878740,
      NULL,
      0.992378,
      1,
      4,
      1,
      4,
      4,
      0,
      2,
      NULL,
      0,
      3,
      5,
      0,
      2,
      3,
      4,
      NULL,
      0,
      NULL,
      2,
      NULL,
      5,
      2,
      NULL,
      4,
      1,
      7.638003,
      1,
      NULL,
      544,
      ' 9- 9-1975',
      358.975688,
      1.900335,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      4,
      0,
      1.124147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.982027,
      1.312355,
      NULL,
      NULL,
      NULL,
      2.053694,
      NULL,
      1,
      4.201232,
      4.393013,
      5.830013,
      3.339455,
      NULL,
      NULL,
      NULL,
      1.173069,
      5.577909,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.761431,
      NULL,
      1.874691,
      1,
      48.737682,
      NULL,
      1.503716,
      NULL,
      NULL,
      NULL,
      0,
      1.628632,
      1,
      3,
      0,
      NULL,
      2,
      3,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      2.051067,
      3.652668,
      1.154354,
      1.521660,
      NULL,
      NULL,
      NULL,
      0.034131,
      107.818566,
      37,
      73,
      126,
      134.838079,
      NULL,
      3,
      16,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      28,
      31,
      62.646671,
      NULL,
      1.527965,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.915602,
      '',
      '',
      '',
      3,
      44.626895,
      38.390088,
      0.275973,
      3.330895,
      55.032710,
      0.970489,
      NULL,
      2,
      NULL,
      3,
      3.626631,
      19.294214,
      NULL,
      NULL,
      1.070703,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.318057,
      0.959564,
      NULL,
      NULL,
      NULL,
      2.356120,
      NULL,
      3.794896,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.231750,
      NULL,
      NULL,
      0.292348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.380184,
      5,
      1,
      0.662577,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.539201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370289,
      2,
      1,
      1,
      0.546537,
      1.081470,
      0.551803,
      2,
      1,
      6.992643,
      NULL,
      NULL,
      7,
      6,
      NULL,
      NULL,
      0.517946,
      0,
      1,
      0.851644,
      3,
      2,
      2,
      6.954573,
      0.962788,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.725297,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.162530,
      NULL,
      NULL,
      2,
      7,
      7.522733,
      7,
      5,
      3.008399,
      1,
      0.933182,
      3,
      3,
      NULL,
      1.056306,
      NULL,
      3.980943,
      NULL,
      7.837048,
      0,
      2.735382,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.579498,
      NULL,
      NULL,
      3,
      3.653755,
      NULL,
      0.692495,
      NULL,
      4,
      2.405224,
      4,
      0,
      2,
      NULL,
      3,
      0.458037,
      0.693399,
      1,
      0,
      0.771405,
      1.663802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.959743,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226169,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318932,
      1,
      1.965656,
      0,
      0.711785,
      2.427490,
      0.897074,
      NULL,
      NULL,
      3.238854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385904,
      NULL,
      NULL,
      NULL,
      2.367189,
      NULL,
      NULL,
      NULL,
      0.402339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469934,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.938136,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.158754,
      NULL,
      NULL,
      NULL,
      1.619310,
      NULL,
      NULL,
      NULL,
      NULL,
      1201.017598,
      NULL,
      1.065028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.824974,
      NULL,
      0.514937,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.539697,
      3,
      1.491983,
      0,
      1.634392,
      0,
      0.846373,
      0,
      1.851647,
      1.946732,
      1.410701,
      1,
      1.159507,
      1.741204,
      1,
      1,
      0.893597,
      1.908651,
      1,
      1.553508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0.299017,
      1,
      3,
      NULL,
      NULL,
      2.553830,
      2.559796,
      0,
      1,
      NULL,
      NULL,
      0.569647,
      0,
      NULL,
      0.605653,
      0.917739,
      NULL,
      1.731317,
      1,
      NULL,
      NULL,
      2.732082,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0.930156,
      NULL,
      1,
      1.150415,
      NULL,
      0,
      1,
      NULL,
      1,
      0.613739,
      NULL,
      2.017146,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770935,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      3,
      1.115915,
      1,
      36,
      NULL,
      3,
      1,
      2.149749,
      '14010',
      '',
      '',
      0.657282,
      NULL,
      NULL,
      NULL,
      1.117742,
      '',
      '',
      '');
commit;
end;
/


