set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      1.451904,
      4,
      1,
      '4404',
      3.570638,
      NULL,
      NULL,
      NULL,
      ' 7-10-1975',
      20,
      NULL,
      5,
      1.578687,
      3.043323,
      ' 7-21-2003',
      23.240332,
      2.995259,
      191.182990,
      80.326523,
      3,
      ' 0- 5-1987',
      ' 8- 6-1984',
      ' 6- 0-2003',
      3.007706,
      0.646126,
      0,
      0.154176,
      0.152162,
      0.067231,
      3,
      0.861055,
      1,
      13.168560,
      3,
      13,
      8,
      NULL,
      9.597705,
      NULL,
      13,
      NULL,
      2,
      1.876596,
      1.939953,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      3,
      0,
      2,
      2,
      NULL,
      0,
      2,
      4,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0.469329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.165614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      4,
      NULL,
      0,
      5,
      5,
      NULL,
      4,
      5,
      2,
      0,
      7.058045,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      5,
      0,
      3,
      1,
      0,
      1,
      1,
      1,
      2,
      4,
      2,
      NULL,
      4,
      1,
      3,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '11-14-1983',
      207.608789,
      ' 2-23-1981',
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3.586408,
      0,
      NULL,
      6,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.114805,
      2,
      0.775363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.332054,
      NULL,
      0,
      0.121869,
      0.019631,
      1,
      2.775007,
      72,
      1.640965,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      3,
      0,
      1,
      2,
      2,
      1,
      3,
      3,
      2,
      1,
      3.666735,
      2.134752,
      NULL,
      0.571593,
      1,
      0.334943,
      NULL,
      0.026120,
      3.174468,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.155112,
      0.476138,
      8.958834,
      8.016929,
      0,
      NULL,
      6,
      0.274870,
      4,
      1,
      NULL,
      1.256645,
      NULL,
      2,
      58,
      NULL,
      1.369677,
      NULL,
      NULL,
      1,
      29,
      3,
      1.915240,
      NULL,
      '32014',
      NULL,
      '',
      1.316523,
      NULL,
      NULL,
      '',
      0.362770,
      NULL,
      '',
      NULL,
      3.128785,
      41,
      16.695526,
      19,
      2,
      13.481191,
      6.887863,
      NULL,
      1,
      NULL,
      2,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.989078,
      0,
      3,
      0.152848,
      NULL,
      NULL,
      2,
      0,
      2.306603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160193,
      NULL,
      NULL,
      1.607053,
      NULL,
      NULL,
      1,
      6.329449,
      3,
      NULL,
      1.121537,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.818228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.916391,
      0.991857,
      3.597289,
      1.287530,
      0.716002,
      0.901538,
      0,
      3.611555,
      NULL,
      NULL,
      NULL,
      6,
      9,
      4.572988,
      2.548154,
      1.656640,
      2,
      1,
      NULL,
      3,
      8,
      NULL,
      3.523090,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.987453,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.155206,
      NULL,
      NULL,
      0.909619,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.081768,
      3.447737,
      5,
      3,
      7,
      7,
      6,
      5.110032,
      6,
      5,
      5,
      3,
      NULL,
      1,
      3.664661,
      3,
      2.833749,
      2,
      1,
      2,
      0.117723,
      9,
      NULL,
      NULL,
      3,
      1,
      3.740254,
      1,
      2,
      NULL,
      0.921953,
      NULL,
      3.726488,
      0.269828,
      3,
      2.097869,
      5,
      3,
      NULL,
      3,
      2,
      1.670138,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      2.335412,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663174,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.890490,
      NULL,
      NULL,
      1.933832,
      NULL,
      NULL,
      0.535548,
      0,
      1,
      0.500553,
      1.644834,
      2.134403,
      0.400651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.048196,
      NULL,
      NULL,
      NULL,
      1.940015,
      NULL,
      NULL,
      NULL,
      3.255296,
      NULL,
      NULL,
      NULL,
      1.462592,
      NULL,
      NULL,
      NULL,
      1.268430,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.389739,
      NULL,
      NULL,
      NULL,
      0.850478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790765,
      NULL,
      NULL,
      NULL,
      2.981057,
      4.238091,
      0,
      0,
      0.935574,
      NULL,
      0.374179,
      NULL,
      NULL,
      NULL,
      0.663744,
      0.506591,
      3,
      NULL,
      0.357745,
      0.921311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      377,
      16,
      0,
      0,
      0,
      1,
      1.598745,
      0.574047,
      0,
      1,
      1.124137,
      0.509821,
      0.465888,
      NULL,
      NULL,
      1,
      0,
      0,
      0.078739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0.212357,
      1,
      3,
      5,
      1,
      3,
      0.331041,
      1,
      1.329478,
      NULL,
      1.843907,
      0,
      NULL,
      0.049196,
      1,
      NULL,
      NULL,
      0.429326,
      NULL,
      1.999906,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.387214,
      NULL,
      1.143374,
      0.987105,
      NULL,
      0,
      0,
      NULL,
      0,
      2.527972,
      NULL,
      1.887631,
      0,
      NULL,
      1.606217,
      0,
      0.848931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161702,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      4,
      3,
      0.878618,
      3.796377,
      58.770180,
      74.834038,
      3,
      0,
      NULL,
      NULL,
      '',
      NULL,
      0.966906,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


