set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3234322',
      NULL,
      1.278997,
      0,
      2,
      '3003',
      1.666573,
      1.144401,
      NULL,
      NULL,
      NULL,
      2.813073,
      NULL,
      5,
      2,
      1,
      '11-25-2002',
      15.350712,
      0,
      160,
      131,
      1,
      ' 1- 8-1982',
      ' 7-29-1976',
      '10- 5-1994',
      NULL,
      NULL,
      1.719189,
      1,
      1.327276,
      1,
      7,
      0.878234,
      NULL,
      79.549157,
      7,
      NULL,
      4,
      1.910589,
      2,
      1,
      17.708613,
      1,
      3,
      3.261676,
      1,
      0,
      0,
      1.462256,
      0.900101,
      NULL,
      0,
      0,
      NULL,
      1,
      44,
      NULL,
      3,
      1,
      1,
      2,
      0,
      2,
      2,
      1,
      1,
      3,
      2,
      0,
      0,
      0,
      0,
      6.799631,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.158788,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.822126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      4,
      5,
      1,
      NULL,
      0,
      2,
      1,
      1,
      0,
      5.217816,
      0,
      0,
      0,
      0,
      1.355044,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      4,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      0,
      3,
      4,
      NULL,
      4,
      3.384202,
      3,
      ' 6- 7-1994',
      977,
      ' 6- 1-1975',
      579.702264,
      1,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1544.714326,
      3.938139,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.127996,
      0.706263,
      0,
      3.675874,
      1,
      1.878883,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      0.724732,
      0,
      1.282420,
      0.548636,
      5389.877750,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.952972,
      NULL,
      0,
      3,
      3,
      0,
      2,
      0,
      1,
      3,
      3,
      3,
      0.682540,
      3,
      2,
      NULL,
      NULL,
      2.484855,
      0.485211,
      NULL,
      NULL,
      0,
      1.542866,
      NULL,
      1.766513,
      NULL,
      0,
      3,
      2.586520,
      NULL,
      10,
      0,
      6,
      NULL,
      8,
      NULL,
      3,
      1.293306,
      4.753938,
      1.902724,
      1,
      1.400432,
      NULL,
      1,
      NULL,
      NULL,
      33,
      20,
      17,
      2,
      1.564449,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256716,
      '',
      '',
      NULL,
      3,
      '24011',
      '40104',
      '4040',
      1,
      26.215684,
      10,
      22.263910,
      3,
      23,
      2,
      NULL,
      5,
      2.094543,
      3.045088,
      0,
      0,
      1.593762,
      NULL,
      0,
      NULL,
      NULL,
      0.130309,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.824064,
      NULL,
      NULL,
      0,
      2,
      2,
      1.348094,
      0,
      1.462690,
      NULL,
      2.248401,
      3,
      0,
      NULL,
      NULL,
      3,
      1.156336,
      0.710860,
      0.793380,
      NULL,
      NULL,
      7.195782,
      6,
      NULL,
      NULL,
      1.041596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095524,
      0,
      1.120820,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0.058188,
      2.161730,
      1,
      1,
      NULL,
      2,
      NULL,
      1,
      2.840306,
      NULL,
      0.205388,
      NULL,
      0.987547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.158416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.516398,
      1,
      0.896409,
      1,
      NULL,
      1.149205,
      NULL,
      NULL,
      NULL,
      7.882886,
      NULL,
      5,
      2.397917,
      3,
      0.082825,
      1.527727,
      NULL,
      NULL,
      1.116584,
      1.050124,
      0.101863,
      1,
      NULL,
      NULL,
      1.847280,
      NULL,
      NULL,
      1.737637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.362639,
      NULL,
      NULL,
      NULL,
      2.357174,
      3,
      1.648287,
      2,
      1.498746,
      4.302874,
      4,
      2,
      0,
      3,
      1.669725,
      5.091017,
      4,
      5,
      1.664557,
      NULL,
      NULL,
      NULL,
      0.575960,
      NULL,
      2.153396,
      NULL,
      1.400327,
      NULL,
      4.620609,
      2.158879,
      NULL,
      2,
      0.667501,
      NULL,
      NULL,
      NULL,
      NULL,
      2.876897,
      2,
      NULL,
      1.377469,
      1,
      NULL,
      0.888688,
      3.084168,
      2.153441,
      3,
      0.334431,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.806473,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586635,
      NULL,
      NULL,
      1.144777,
      NULL,
      NULL,
      1.102222,
      NULL,
      NULL,
      3.959515,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.897500,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.535600,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.180610,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.360000,
      NULL,
      NULL,
      2.788742,
      NULL,
      0.966201,
      0,
      23,
      5,
      NULL,
      NULL,
      NULL,
      3,
      9,
      NULL,
      42,
      80.029875,
      NULL,
      0.809702,
      0.847608,
      2,
      NULL,
      3.834066,
      1.789099,
      NULL,
      0.246034,
      1.990911,
      1,
      1.696464,
      0,
      2.338138,
      NULL,
      0.424160,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921192,
      NULL,
      0,
      NULL,
      54.503562,
      NULL,
      2,
      13.075150,
      NULL,
      1.332057,
      3,
      2.685450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.169465,
      NULL,
      NULL,
      NULL,
      3.718730,
      NULL,
      0.203588,
      NULL,
      1.610114,
      NULL,
      1,
      NULL,
      0.363347,
      NULL,
      0.209726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.327075,
      0,
      9.081101,
      3.579864,
      NULL,
      1,
      0,
      1,
      NULL,
      0.771380,
      1.901951,
      NULL,
      2.569108,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3.810238,
      NULL,
      1.457486,
      1,
      NULL,
      3.079708,
      3.342861,
      NULL,
      0,
      NULL,
      NULL,
      1.704701,
      0,
      NULL,
      0.254740,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.646837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539862,
      NULL,
      NULL,
      1,
      NULL,
      1.185912,
      NULL,
      NULL,
      NULL,
      1.479782,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.972065,
      NULL,
      0.572704,
      NULL,
      2.740948,
      NULL,
      0.525172,
      NULL,
      2,
      NULL,
      1.806645,
      2.108099,
      NULL,
      NULL,
      NULL,
      0.896810,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      3.475504,
      3,
      1.889068,
      31,
      17,
      NULL,
      1,
      6,
      '12131',
      '43300',
      NULL,
      0,
      '',
      NULL,
      NULL,
      4.261534,
      '13004',
      '31331',
      '4244');
commit;
end;
/


