set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '2131144',
      NULL,
      0.557501,
      NULL,
      0,
      '2043',
      1,
      1.184705,
      NULL,
      NULL,
      ' 7- 6-1994',
      NULL,
      NULL,
      0,
      0.160774,
      0.221642,
      ' 1-11-1978',
      2.372684,
      5.636017,
      69,
      36.957491,
      NULL,
      '10- 9-1992',
      ' 3- 1-2002',
      ' 0-22-1991',
      3,
      0,
      0.639075,
      0.552550,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      17.847521,
      NULL,
      4,
      12.631468,
      NULL,
      2,
      0.178042,
      0.351190,
      NULL,
      NULL,
      0.070043,
      0.607686,
      1.589621,
      1,
      4,
      1.810746,
      0,
      1.102668,
      NULL,
      2,
      2,
      NULL,
      2,
      0,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      0,
      6.902934,
      NULL,
      1,
      0.305344,
      2,
      2,
      NULL,
      0,
      1,
      1.479266,
      0,
      NULL,
      3,
      0,
      3,
      0.051917,
      1,
      0,
      1,
      0,
      4,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      3.430235,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0.994093,
      0,
      NULL,
      1,
      0,
      0.076001,
      NULL,
      1.482136,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      0,
      2,
      5,
      NULL,
      5,
      4,
      1,
      1,
      3,
      NULL,
      2,
      2,
      NULL,
      NULL,
      113,
      '10-29-1996',
      NULL,
      1.188934,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0.462956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      57.271378,
      0,
      3.731691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574572,
      9.852834,
      7,
      4.080177,
      6.641894,
      1.032386,
      NULL,
      NULL,
      0,
      NULL,
      0.941527,
      0,
      4,
      NULL,
      0.498245,
      ' 7-27-1974',
      191,
      NULL,
      14,
      3.069189,
      0,
      0.335547,
      0.923629,
      3,
      0.511963,
      3.129321,
      NULL,
      1,
      1,
      1,
      34,
      2,
      1.118584,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232828,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      3,
      2,
      0,
      2,
      0,
      1.519788,
      3.296095,
      NULL,
      3.528483,
      0,
      1,
      1.718361,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      3.385685,
      NULL,
      1,
      NULL,
      1,
      0.091100,
      0,
      4,
      4,
      1,
      4.926030,
      1,
      1,
      NULL,
      17.864757,
      1,
      3.011309,
      NULL,
      31,
      NULL,
      11.693570,
      5,
      0,
      1,
      '40240',
      '',
      NULL,
      0.655928,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      44,
      30,
      NULL,
      30.520805,
      1,
      3.492569,
      4,
      2.145353,
      3,
      0.367439,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.628422,
      1,
      0.320484,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.018413,
      2.639450,
      2.848179,
      NULL,
      NULL,
      NULL,
      0.868601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.094309,
      NULL,
      NULL,
      2.784592,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.888502,
      0,
      3,
      9,
      1,
      2.425773,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.940772,
      3.917730,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      0.036012,
      NULL,
      1,
      3.516291,
      0.976520,
      2.241229,
      1.073758,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697900,
      NULL,
      NULL,
      0.164831,
      NULL,
      NULL,
      NULL,
      1.459614,
      1,
      0,
      1.391985,
      NULL,
      NULL,
      NULL,
      0.604804,
      1,
      2.985820,
      3.610409,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.359063,
      1.823457,
      0,
      1.837870,
      NULL,
      NULL,
      5.560087,
      0,
      2.462909,
      1.568092,
      NULL,
      NULL,
      1.581362,
      NULL,
      NULL,
      1.947933,
      NULL,
      NULL,
      0.748781,
      NULL,
      NULL,
      1.093636,
      NULL,
      NULL,
      0.551261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.596957,
      NULL,
      NULL,
      2.803712,
      2,
      NULL,
      0.482957,
      NULL,
      NULL,
      1,
      1,
      2,
      3.055454,
      9,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.448159,
      3,
      0.381728,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299356,
      0,
      0.548625,
      1,
      0,
      NULL,
      0,
      3.239279,
      2.176337,
      3.590385,
      NULL,
      2,
      0,
      1.965500,
      2.436627,
      6,
      NULL,
      6,
      NULL,
      0,
      0.618179,
      0,
      NULL,
      1,
      0.636606,
      0.281683,
      1.929482,
      1.041124,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.751556,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849449,
      NULL,
      NULL,
      0.394270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.697214,
      NULL,
      NULL,
      1.304723,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933948,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      3,
      0.516739,
      NULL,
      1,
      1.104935,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      57.533572,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.359998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122422,
      NULL,
      NULL,
      NULL,
      0.963321,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.898644,
      NULL,
      NULL,
      NULL,
      1.494057,
      NULL,
      NULL,
      NULL,
      1.144687,
      NULL,
      NULL,
      NULL,
      0.103356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.310286,
      NULL,
      NULL,
      NULL,
      0.965796,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      1.876152,
      NULL,
      NULL,
      0.782077,
      7.276301,
      NULL,
      0,
      NULL,
      NULL,
      0.056328,
      NULL,
      NULL,
      1.507316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.616254,
      469.493972,
      0.247461,
      0,
      1,
      1,
      1,
      NULL,
      1.985566,
      NULL,
      0.475839,
      1,
      0.230332,
      0,
      NULL,
      NULL,
      1,
      0.342327,
      1.274586,
      1,
      0.296504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.614386,
      NULL,
      1.228950,
      2.359894,
      3,
      5.241405,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0.691320,
      NULL,
      1.129650,
      NULL,
      NULL,
      1.542249,
      NULL,
      NULL,
      NULL,
      2.996749,
      NULL,
      0.491760,
      0,
      NULL,
      0,
      3,
      NULL,
      0.705505,
      1,
      NULL,
      1.713397,
      1.894439,
      NULL,
      0,
      1,
      NULL,
      1.310197,
      1.029559,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.803689,
      NULL,
      2,
      1,
      3,
      1.032547,
      NULL,
      NULL,
      NULL,
      26.891074,
      4,
      0,
      0.921739,
      '24311',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


