set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0.104037,
      4,
      1,
      '2230',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.690338,
      ' 7-26-1974',
      23.619956,
      4,
      26,
      6,
      2,
      '11-26-1999',
      ' 0- 6-2002',
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.044619,
      0,
      2.995876,
      NULL,
      NULL,
      NULL,
      9,
      3,
      28,
      7,
      1,
      22,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.265762,
      NULL,
      1.651888,
      1,
      NULL,
      0,
      2,
      0,
      2,
      5,
      1,
      1,
      1,
      1,
      0,
      2,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      6.925451,
      3,
      1,
      0.718047,
      3.752319,
      3,
      NULL,
      1,
      1,
      1.867429,
      1,
      NULL,
      0,
      1,
      3.229746,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      2,
      3,
      1.720723,
      NULL,
      NULL,
      2.583657,
      0,
      1,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.559689,
      NULL,
      1.900851,
      2,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      5,
      2,
      1,
      NULL,
      5,
      4,
      5,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.954706,
      1,
      2.204681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.474329,
      6.375842,
      7,
      7.437426,
      5.160005,
      0.383416,
      NULL,
      NULL,
      1.658679,
      5,
      NULL,
      1,
      4,
      2,
      6,
      NULL,
      205,
      '10- 2-1996',
      58,
      NULL,
      1,
      NULL,
      1.341279,
      1,
      NULL,
      0.811012,
      2,
      1,
      1.545744,
      NULL,
      29,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.344826,
      2.797776,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      1,
      NULL,
      2.119553,
      NULL,
      0,
      5.870485,
      1,
      NULL,
      NULL,
      0.732133,
      1.843085,
      1,
      0.770189,
      0,
      1,
      0.568820,
      NULL,
      0,
      0.979377,
      NULL,
      0.824500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.635324,
      NULL,
      62,
      58,
      NULL,
      0,
      1.563678,
      NULL,
      '32232',
      '',
      '',
      1.956141,
      '',
      '',
      '',
      0.065894,
      '',
      '',
      '',
      0,
      NULL,
      24.710754,
      28.247219,
      0,
      15,
      2,
      1.121670,
      4,
      3.230107,
      0.645393,
      1,
      0.556248,
      NULL,
      NULL,
      0.559405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638113,
      NULL,
      NULL,
      2.755554,
      0.462681,
      0.270000,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229847,
      NULL,
      NULL,
      0.434166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.797088,
      3.775173,
      3.534018,
      1,
      0.488855,
      NULL,
      NULL,
      NULL,
      2.941103,
      2,
      1,
      0.313060,
      0,
      0.136198,
      NULL,
      2.278924,
      1,
      NULL,
      1.295852,
      0,
      1.713448,
      1,
      1.306302,
      1.282731,
      2,
      0,
      0.666015,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.347251,
      NULL,
      NULL,
      1,
      3.041981,
      0.456676,
      1,
      1.351745,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      16,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.702646,
      0.640439,
      3.071645,
      1.342476,
      NULL,
      NULL,
      NULL,
      3.157367,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.231395,
      NULL,
      NULL,
      1.445005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.488630,
      NULL,
      NULL,
      4.861927,
      NULL,
      0.904139,
      2.137583,
      2,
      5,
      1.248441,
      NULL,
      NULL,
      0.719822,
      0,
      0,
      1,
      0.386392,
      1.639229,
      0,
      0,
      2.329863,
      NULL,
      7.445932,
      NULL,
      1.121473,
      3,
      1.603637,
      14.625417,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      9,
      4,
      0.774752,
      NULL,
      NULL,
      0.222046,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.660840,
      0,
      1.873914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.391678,
      0.421020,
      1,
      NULL,
      1,
      1.190026,
      NULL,
      2.326466,
      NULL,
      NULL,
      NULL,
      11.038719,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.514057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7.931176,
      NULL,
      NULL,
      NULL,
      1.004718,
      2.110810,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      6.011742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200362,
      NULL,
      2,
      3.211046,
      NULL,
      0.932852,
      NULL,
      NULL,
      1.766818,
      NULL,
      1,
      473,
      1,
      0,
      1,
      1.793896,
      1.360098,
      1,
      1,
      1.274666,
      NULL,
      0,
      1,
      0.715167,
      0.401257,
      NULL,
      NULL,
      1,
      0.874567,
      1,
      0.441522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      3,
      12,
      3.671185,
      NULL,
      0.033704,
      1,
      1.993979,
      NULL,
      0.793187,
      1,
      NULL,
      1.871783,
      1,
      NULL,
      0,
      1.409545,
      NULL,
      NULL,
      2.116679,
      NULL,
      NULL,
      1.313447,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2.358216,
      NULL,
      1,
      NULL,
      NULL,
      2.051126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.464485,
      NULL,
      0.898216,
      NULL,
      1,
      5,
      2,
      0.871708,
      NULL,
      NULL,
      56,
      75.388179,
      1,
      1,
      3,
      '00112',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.073940,
      '',
      '',
      '');
commit;
end;
/


