set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0322432',
      1,
      0.688372,
      5,
      3,
      '0033',
      0,
      1,
      NULL,
      NULL,
      ' 7-27-1995',
      1.666844,
      NULL,
      5,
      2.163405,
      0.412146,
      ' 7-29-1989',
      31.070166,
      3.491287,
      185,
      NULL,
      NULL,
      ' 9-23-1994',
      ' 9- 9-1976',
      ' 5-25-2001',
      3,
      NULL,
      3,
      1,
      1.681984,
      3.639446,
      3,
      3,
      NULL,
      NULL,
      NULL,
      8.450948,
      6.954903,
      8.372442,
      26,
      5,
      5,
      NULL,
      0,
      7,
      1.822245,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      1.427139,
      0.763726,
      3,
      0,
      2,
      2,
      2,
      1,
      2,
      0,
      0,
      3,
      5,
      0,
      1,
      1,
      5,
      1,
      NULL,
      1,
      1,
      NULL,
      2,
      0.145548,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      7,
      1.738816,
      NULL,
      0,
      1,
      3.550155,
      0.165458,
      0.845125,
      0.972310,
      0,
      0,
      NULL,
      1.969120,
      0.400817,
      0,
      1.051925,
      0,
      0,
      1,
      0,
      2,
      1,
      0,
      1,
      1.460730,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      1,
      1,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      ' 7-21-1994',
      40.433344,
      1.518478,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1,
      1,
      0,
      1.708486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      55,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.264442,
      NULL,
      7,
      7,
      1.748840,
      0,
      1.411017,
      NULL,
      NULL,
      2,
      5.052139,
      0.305984,
      1,
      5,
      3,
      NULL,
      '10-15-2001',
      NULL,
      ' 8-15-1999',
      47.506109,
      3,
      0,
      0.005759,
      NULL,
      1,
      0,
      0,
      3.070045,
      1.972466,
      0,
      1,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      1,
      3,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.600462,
      2.981327,
      NULL,
      0,
      0,
      NULL,
      1.757217,
      0.027146,
      NULL,
      NULL,
      1.563780,
      1.455732,
      0,
      0,
      1,
      0.338581,
      3.052569,
      1,
      NULL,
      4.016086,
      0.842075,
      NULL,
      NULL,
      5.455496,
      1,
      NULL,
      2.219263,
      2,
      NULL,
      1,
      33.903525,
      3,
      1,
      NULL,
      58,
      NULL,
      30,
      4,
      1,
      2,
      '44123',
      '',
      '',
      1.797702,
      '',
      '',
      NULL,
      0.711591,
      '',
      '',
      '',
      3,
      NULL,
      21.977527,
      10.306174,
      NULL,
      NULL,
      3.544264,
      2,
      5,
      3,
      1.381406,
      0.521732,
      0.139639,
      NULL,
      NULL,
      1.846762,
      NULL,
      NULL,
      0,
      2.718776,
      1,
      0,
      NULL,
      NULL,
      0.554594,
      NULL,
      NULL,
      0.344365,
      2,
      1,
      1.207443,
      NULL,
      NULL,
      0.012878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.582961,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.239172,
      3.696814,
      0,
      NULL,
      0.366157,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.843262,
      NULL,
      3.138242,
      1.573456,
      0,
      0,
      NULL,
      NULL,
      2,
      3.215957,
      0,
      2.121864,
      NULL,
      1.456835,
      3,
      1.136008,
      0.627110,
      NULL,
      NULL,
      0.747403,
      1.731725,
      1,
      2,
      1,
      3,
      1,
      0,
      1.286714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172611,
      NULL,
      NULL,
      5,
      6,
      NULL,
      0,
      1.336305,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.419636,
      0.677450,
      0,
      NULL,
      NULL,
      NULL,
      5,
      4.773600,
      1,
      0.452839,
      NULL,
      NULL,
      0.170848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.701655,
      NULL,
      NULL,
      0.456806,
      NULL,
      NULL,
      0.064222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.369909,
      0.554498,
      0,
      NULL,
      NULL,
      NULL,
      3.021834,
      5,
      0,
      NULL,
      7,
      1,
      NULL,
      NULL,
      1,
      0.703109,
      NULL,
      0,
      0,
      1.092663,
      1.733375,
      0.358881,
      NULL,
      7,
      6.441679,
      3.088275,
      NULL,
      0,
      2.769824,
      1,
      NULL,
      3.937975,
      NULL,
      3.745533,
      NULL,
      2.708878,
      1,
      NULL,
      8,
      9.039766,
      4,
      2,
      1,
      2,
      3,
      1,
      0,
      1.041851,
      0.893258,
      1,
      0,
      0.260452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924081,
      NULL,
      NULL,
      0.823604,
      NULL,
      NULL,
      3.837989,
      NULL,
      NULL,
      1.083010,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.761176,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.462254,
      0.888082,
      0.227458,
      0,
      1.776022,
      NULL,
      2.064544,
      NULL,
      NULL,
      NULL,
      61.605921,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.988732,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.664670,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.643833,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.622990,
      2,
      5,
      2,
      5.283105,
      1,
      3.380480,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.260060,
      3.017006,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      275.769853,
      0.980282,
      1,
      1.293943,
      0,
      NULL,
      1,
      1.598539,
      1.175890,
      1.840838,
      0,
      1.710716,
      1,
      1.773804,
      NULL,
      1,
      1.564990,
      0,
      1,
      1.450613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.940365,
      0,
      0,
      NULL,
      1.071625,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      2.457031,
      NULL,
      0.410448,
      0,
      NULL,
      1,
      0.446327,
      NULL,
      1,
      NULL,
      NULL,
      0.056278,
      3.332006,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.251813,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      123.625429,
      0,
      1.923940,
      3,
      NULL,
      NULL,
      '',
      1.361819,
      '',
      '',
      '',
      0.173536,
      '',
      '',
      NULL);
commit;
end;
/


